/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.reflection.model;

import com.bld.commons.exception.JpaServiceException;
import com.bld.commons.reflection.annotations.ConditionsZone;
import com.bld.commons.reflection.model.TupleParameter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ConditionsZoneModel {
    private String key;
    private String where;
    private Map<String, Object> parameters;
    private Set<String> nullables;
    private Map<String, TupleParameter> tupleParamenters;

    private void init() {
        this.where = "";
        this.parameters = new HashMap<String, Object>();
        this.nullables = new HashSet<String>();
        this.tupleParamenters = new HashMap<String, TupleParameter>();
    }

    public ConditionsZoneModel(String key) {
        this.key = key;
        this.init();
    }

    public ConditionsZoneModel(ConditionsZone conditionsZone) {
        this.key = conditionsZone.key();
        this.init();
    }

    public String getKey() {
        return this.key;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(ConditionsZone conditionsZone) {
        if (conditionsZone != null) {
            this.where = StringUtils.isNotBlank((CharSequence)this.where) || conditionsZone.initWhere() ? " where 1=1\n" : "";
        }
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Map<String, TupleParameter> getTupleParamenters() {
        return this.tupleParamenters;
    }

    public void addParameter(String key, Object value) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            this.parameters.put(key, value);
        }
    }

    public void addParameter(String key, TupleParameter tupleParameter) {
        if (key != null && tupleParameter != null) {
            this.tupleParamenters.put(key, tupleParameter);
        }
    }

    public void mergeParameters() {
        if (MapUtils.isNotEmpty(this.tupleParamenters)) {
            for (Map.Entry<String, TupleParameter> entry : this.tupleParamenters.entrySet()) {
                TupleParameter tupleParameter = entry.getValue();
                int i = 0;
                for (Object object : tupleParameter.getObjects()) {
                    for (String param : tupleParameter.getParams()) {
                        try {
                            Object value = PropertyUtils.getProperty((Object)object, (String)param);
                            this.addParameter(param + i, value);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            throw new JpaServiceException("The tuple with the name: \"" + param + "\" is not found");
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public Set<String> getNullables() {
        return this.nullables;
    }

    public void addNullables(String nullable) {
        if (StringUtils.isNotBlank((CharSequence)nullable)) {
            this.nullables.add(nullable);
        }
    }
}

