/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.reflection.model;

import com.bld.commons.exception.JpaServiceException;
import com.bld.commons.reflection.model.BaseParameter;
import com.bld.commons.reflection.model.BaseQueryParameter;
import com.bld.commons.reflection.model.TupleParameter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class QueryParameter<T, ID>
extends BaseQueryParameter<T, ID> {
    private Map<String, Object> parameters;
    private Map<String, TupleParameter> tupleParamenters;
    private Set<String> nullables;

    public QueryParameter() {
        this.init();
    }

    public QueryParameter(BaseParameter baseParameter) {
        super(baseParameter);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.nullables = new HashSet<String>();
        this.parameters = new HashMap<String, Object>();
        this.tupleParamenters = new HashMap<String, TupleParameter>();
    }

    public QueryParameter(ID id) {
        super(id);
        this.init();
        this.parameters.put("id", id);
    }

    public Set<String> getNullables() {
        return this.nullables;
    }

    @Override
    public void addParameter(String key, Object value) {
        if (key != null && value != null) {
            this.parameters.put(key, value);
        }
    }

    public void addNullable(String nullable) {
        if (StringUtils.isNotBlank((CharSequence)nullable)) {
            this.nullables.add(nullable);
        }
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void addParameter(String key, TupleParameter tupleParameter) {
        if (key != null && tupleParameter != null) {
            this.tupleParamenters.put(key, tupleParameter);
        }
    }

    public void mergeParameters() {
        if (MapUtils.isNotEmpty(this.tupleParamenters)) {
            for (Map.Entry<String, TupleParameter> entry : this.tupleParamenters.entrySet()) {
                TupleParameter tupleParameter = entry.getValue();
                int i = 0;
                for (Object object : tupleParameter.getObjects()) {
                    for (String param : tupleParameter.getParams()) {
                        try {
                            Object value = PropertyUtils.getProperty((Object)object, (String)param);
                            this.addParameter(param + i, value);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            throw new JpaServiceException("The tuple with the name: \"" + param + "\" is not found");
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public Map<String, TupleParameter> getTupleParamenters() {
        return this.tupleParamenters;
    }
}

