/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.reflection.model;

import com.bld.commons.exception.JpaServiceException;
import io.jsonwebtoken.lang.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class TupleParameter {
    private Set<Object> objects;
    private String[] params;

    public TupleParameter(String[] params) {
        if (params == null || params.length < 2) {
            throw new JpaServiceException("The params items cannot be less than 2");
        }
        this.params = params;
    }

    public Set<Object> getObjects() {
        return this.objects;
    }

    public String[] getParams() {
        return this.params;
    }

    public void setObjects(Object ... objects) {
        if (ArrayUtils.isNotEmpty((Object[])objects)) {
            this.objects = new HashSet<Object>(Arrays.asList((Object[])objects));
        }
    }

    public void setObjects(Collection<Object> objects) {
        if (CollectionUtils.isNotEmpty(objects)) {
            this.objects = new HashSet<Object>(objects);
        }
    }

    public String getCondition(int i) {
        Object condition = "";
        for (String param : this.params) {
            condition = (String)condition + ",:" + param + i;
        }
        return "(" + ((String)condition).substring(1) + ")";
    }
}

