/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.utils;

import com.bld.commons.exception.PropertiesException;
import com.bld.commons.reflection.utils.ReflectionCommons;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PersistenceMap<K, V> {
    private List<Map.Entry<K, V>> table = new ArrayList<Map.Entry<K, V>>();
    private Map<Class<?>, List<Field>> mapFields = new HashMap();

    public int size() {
        return this.table.size();
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.table);
    }

    private Pair<Integer, Map.Entry<K, V>> getEntry(K key) {
        Pair entry = null;
        Integer i = 0;
        if (key != null) {
            for (Map.Entry<K, V> persistenceEntry : this.table) {
                if (this.equals(key, persistenceEntry.getKey())) {
                    entry = Pair.of((Object)i, persistenceEntry);
                    break;
                }
                Integer n = i;
                i = i + 1;
            }
        }
        return entry;
    }

    public boolean containsKey(K key) {
        return this.getEntry(key) != null;
    }

    public V get(K key) {
        if (key == null) {
            return null;
        }
        Pair<Integer, Map.Entry<K, V>> pair = this.getEntry(key);
        V value = null;
        if (pair != null) {
            value = ((Map.Entry)pair.getValue()).getValue();
        }
        return value;
    }

    private List<Field> fields(Object key) {
        List<Field> listField = null;
        if (!this.mapFields.containsKey(key.getClass())) {
            Set<Field> fields = ReflectionCommons.fields(key.getClass());
            listField = new ArrayList<Field>();
            if (key.getClass().isAnnotationPresent(Entity.class)) {
                for (Field field : fields) {
                    if (!field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(EmbeddedId.class)) continue;
                    listField.add(field);
                }
            } else if (key.getClass().isAnnotationPresent(Embeddable.class)) {
                for (Field field : fields) {
                    if (field.isAnnotationPresent(Transient.class)) continue;
                    listField.add(field);
                }
            }
            this.mapFields.put(key.getClass(), listField);
        } else {
            listField = this.mapFields.get(key.getClass());
        }
        return listField;
    }

    private boolean equals(Object key, Object key1) {
        if (key == null) {
            return false;
        }
        if (key.getClass().getName() != key1.getClass().getName()) {
            return false;
        }
        boolean equals = true;
        if (key.getClass().isAnnotationPresent(Entity.class) || key.getClass().isAnnotationPresent(Embeddable.class)) {
            List<Field> fields = this.fields(key);
            for (Field field : fields) {
                Object value = null;
                Object value1 = null;
                try {
                    value = PropertyUtils.getProperty((Object)key, (String)field.getName());
                    value1 = PropertyUtils.getProperty((Object)key1, (String)field.getName());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    new PropertiesException(e);
                }
                if (equals = value.getClass().isAnnotationPresent(Embeddable.class) ? this.equals(value, value1) : (value.getClass().isPrimitive() ? value == value1 : value.equals(value1))) continue;
                return false;
            }
        } else {
            equals = key.equals(key1);
        }
        return equals;
    }

    public void put(K key, V value) {
        if (key == null) {
            throw new RuntimeException("Illegal key: " + String.valueOf(key));
        }
        Pair<Integer, Map.Entry<K, V>> entry = this.getEntry(key);
        if (entry != null) {
            ((Map.Entry)entry.getRight()).setValue(value);
        } else {
            this.table.add(new PersistenceEntry(key, value));
        }
    }

    public void remove(K key) {
        Pair<Integer, Map.Entry<K, V>> entry = this.getEntry(key);
        if (entry != null) {
            this.table.remove((Integer)entry.getKey());
        }
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(PersistenceMap<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.table.clear();
    }

    public List<K> keySet() {
        ArrayList<K> keys = new ArrayList<K>();
        for (Map.Entry<K, V> entry : this.table) {
            if (entry.getKey() == null) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (Map.Entry<K, V> entry : this.table) {
            if (entry.getValue() == null) continue;
            values.add(entry.getValue());
        }
        return values;
    }

    public List<Map.Entry<K, V>> entrySet() {
        return this.table;
    }

    private class PersistenceEntry
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        private PersistenceEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return this.value;
        }
    }
}

