/*
 * Decompiled with CFR 0.152.
 */
package bld.common.spreadsheet.utils;

import bld.common.spreadsheet.constant.RowStartEndType;
import com.fathzer.soft.javaluator.DoubleEvaluator;
import com.fathzer.soft.javaluator.StaticVariableSet;
import java.lang.reflect.ParameterizedType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.WordUtils;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelUtils {
    public static final String ANNOTATIONS = "annotations";
    public static final String ANNOTATION_DATA = "annotationData";
    public static final short AUTO_SIZE_HEIGHT = -1;
    public static final String ENV_SHEET_NAME = "${sheetName}";

    public static String getNameParameter(String parameter) {
        parameter = WordUtils.capitalize((String)parameter.replace("_", " ").toLowerCase()).replace(" ", "");
        return (parameter.charAt(0) + "").toLowerCase() + parameter.substring(1);
    }

    public static String coordinateCalculation(int row, int idColumn, boolean isBlockColumn, boolean isBlockRow) {
        int mod = 0;
        int div = idColumn;
        String blockColumn = ExcelUtils.blockCoordinate(isBlockColumn);
        String blockRow = ExcelUtils.blockCoordinate(isBlockRow);
        String column = "";
        do {
            mod = div % 26;
            div = div / 26 - 1;
            column = Character.toString((char)(mod += 65)) + column;
        } while (div >= 0);
        column = blockColumn + column + blockRow + row;
        return column;
    }

    private static String blockCoordinate(boolean isBlockCoordinate) {
        String blockCoordinate = "";
        if (isBlockCoordinate) {
            blockCoordinate = "$";
        }
        return blockCoordinate;
    }

    public static String getKeyColumn(Sheet sheet, String key) {
        if (!(key = key.replace(RowStartEndType.VALUE.getValue(), "")).contains(".")) {
            key = sheet.getSheetName() + "." + key;
        }
        return key;
    }

    public static short widthColumn(int widthColumn) {
        return (short)(widthColumn * 1036);
    }

    public static short rowHeight(int rowHeight) {
        if (rowHeight != -1) {
            rowHeight *= 568;
        }
        return (short)rowHeight;
    }

    public static <T> Class<T> getTClass(Object entity) {
        return ExcelUtils.getTClass(entity, 0);
    }

    public static <T> Class<T> getTClass(Object entity, int i) {
        ParameterizedType parameterizedType = null;
        try {
            parameterizedType = (ParameterizedType)entity.getClass().getGenericSuperclass();
        }
        catch (Exception e) {
            parameterizedType = (ParameterizedType)entity.getClass().getSuperclass().getGenericSuperclass();
        }
        Class classT = (Class)parameterizedType.getActualTypeArguments()[i];
        return classT;
    }

    public static Double evaluate(String exprenssionIndex, String param, Number value) {
        Double evaluate = null;
        try {
            DoubleEvaluator eval = new DoubleEvaluator();
            StaticVariableSet variables = new StaticVariableSet();
            variables.set(param, (Object)value.doubleValue());
            evaluate = (Double)eval.evaluate(exprenssionIndex, (Object)variables);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return evaluate;
    }

    public static Matcher matcher(String param, String function) {
        Pattern pattern = Pattern.compile(param);
        return pattern.matcher(function);
    }
}

