/*
 * Decompiled with CFR 0.152.
 */
package com.bld.common.spreadsheet.utils;

import com.bld.common.spreadsheet.exception.SpreadsheetException;
import java.io.FileOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class SpreadsheetUtils {
    public static final int SHEET_NAME_SIZE = 31;
    private static final List<String> CLASS_PACKAGES = Arrays.asList("com.bld.generator", "com.bld.common");

    public static <T extends Annotation> T getAnnotation(Class<?> classExcel, Class<T> classAnnotation) {
        if (!classExcel.isAnnotationPresent(classAnnotation)) {
            throw new SpreadsheetException("Annotation " + classAnnotation.getSimpleName() + " is not presented on " + classExcel.getSimpleName());
        }
        return classExcel.getAnnotation(classAnnotation);
    }

    public static <T extends Annotation> T getAnnotation(Field field, Class<T> classAnnotation) {
        if (!field.isAnnotationPresent(classAnnotation)) {
            throw new SpreadsheetException("Annotation " + classAnnotation.getSimpleName() + " is not presented on " + field.getName());
        }
        return field.getAnnotation(classAnnotation);
    }

    public static <T, K extends Annotation> T reflectionAnnotation(T entity, K annotation) {
        Map<String, Field> mapField = SpreadsheetUtils.getMapField(entity.getClass());
        Class<?> classAnnotation = annotation.getClass();
        Class<?> classEntity = entity.getClass();
        List<Method> listMethod = Arrays.asList(classAnnotation.getDeclaredMethods());
        for (Method method : listMethod) {
            if (!mapField.containsKey(method.getName())) continue;
            Field field = mapField.get(method.getName());
            Object value = null;
            String nameField = field.getName();
            String setMethod = "set" + ("" + nameField.charAt(0)).toUpperCase() + nameField.substring(1);
            Class<?> classField = field.getType();
            try {
                value = method.invoke(annotation, new Object[0]);
                try {
                    classEntity.getMethod(setMethod, classField).invoke(entity, value);
                }
                catch (Exception e) {
                    Annotation fieldAnnotation = null;
                    if (Annotation.class.isAssignableFrom(value.getClass()) && SpreadsheetUtils.startsWith(field.getType().getName())) {
                        fieldAnnotation = (Annotation)value;
                        value = SpreadsheetUtils.reflectionAnnotation(classField.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), fieldAnnotation);
                        classEntity.getMethod(setMethod, classField).invoke(entity, value);
                        continue;
                    }
                    if (Annotation.class.isAssignableFrom(value.getClass()) && field.getType().isArray() && SpreadsheetUtils.startsWith(field.getType().getComponentType().getName())) {
                        fieldAnnotation = (Annotation)value;
                        value = SpreadsheetUtils.reflectionAnnotation(field.getType().getComponentType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), fieldAnnotation);
                        Object[] array = (Object[])Array.newInstance(field.getType().getComponentType(), 1);
                        Array.set(array, 0, value);
                        classEntity.getMethod(setMethod, classField).invoke(entity, new Object[]{array});
                        continue;
                    }
                    if (!value.getClass().isArray() || !Annotation.class.isAssignableFrom(((Object[])value)[0].getClass())) continue;
                    Object[] list = (Object[])Array.newInstance(field.getType().getComponentType(), ((Annotation[])value).length);
                    for (int i = 0; i < ((Annotation[])value).length; ++i) {
                        fieldAnnotation = ((Annotation[])value)[i];
                        Object object = SpreadsheetUtils.reflectionAnnotation(field.getType().getComponentType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), fieldAnnotation);
                        list[i] = object;
                    }
                    classEntity.getMethod(setMethod, classField).invoke(entity, new Object[]{list});
                }
            }
            catch (Exception exception) {}
        }
        return entity;
    }

    private static boolean startsWith(String className) {
        for (String annotationPackage : CLASS_PACKAGES) {
            if (!className.startsWith(annotationPackage)) continue;
            return true;
        }
        return false;
    }

    public static Set<Field> getListField(Class<?> classComponentExcel) {
        HashSet<Field> listField = new HashSet<Field>();
        Class<?> classApp = classComponentExcel;
        do {
            listField.addAll(Arrays.asList(classApp.getDeclaredFields()));
        } while ((classApp = classApp.getSuperclass()).getSuperclass() != null && !classApp.getName().equals(Object.class.getName()));
        return listField;
    }

    public static Map<String, Field> getMapField(Class<?> classComponentExcel) {
        Set<Field> listField = SpreadsheetUtils.getListField(classComponentExcel);
        HashMap<String, Field> mapField = new HashMap<String, Field>();
        for (Field field : listField) {
            mapField.put(field.getName(), field);
        }
        return mapField;
    }

    public static void writeToFile(String pathFile, String fileName, String typeFile, byte[] data) {
        FileOutputStream fos = null;
        try {
            typeFile = SpreadsheetUtils.startString(typeFile, ".");
            fileName = SpreadsheetUtils.startString(fileName, "/");
            fos = new FileOutputStream(pathFile + fileName + typeFile);
            fos.write(data);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String startString(String text, String start) {
        if (!((String)text).startsWith(start)) {
            text = start + (String)text;
        }
        return text;
    }
}

