/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.classes.attributes;

public enum PrimitiveType {
    INT(Integer.TYPE, Integer.class, Integer[].class),
    BYTE(Byte.TYPE, Byte.class, Byte[].class),
    CHAR(Character.TYPE, Character.class, Character[].class),
    BOOLEAN(Boolean.TYPE, Boolean.class, Boolean[].class),
    DOUBLE(Double.TYPE, Double.class, Double[].class),
    FLOAT(Float.TYPE, Float.class, Float[].class),
    LONG(Long.TYPE, Long.class, Long[].class),
    SHORT(Short.TYPE, Short.class, Short[].class),
    VOID(Void.TYPE, Void.class, Void[].class);

    private Class<?> primitiveClass;
    private Class<?> objectClass;
    private Class<?> arrayClass;

    private PrimitiveType(Class<?> primitive, Class<?> object, Class<?> arrayClass) {
        this.objectClass = object;
        this.primitiveClass = primitive;
        this.arrayClass = arrayClass;
    }

    public Class<?> getPrimitiveClass() {
        return this.primitiveClass;
    }

    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public Class<?> getArrayClass() {
        return this.arrayClass;
    }

    public static PrimitiveType getPrimitiveType(String className) {
        for (PrimitiveType primitiveType : PrimitiveType.values()) {
            if (!primitiveType.name().toLowerCase().equals(className)) continue;
            return primitiveType;
        }
        return null;
    }

    public static Class<?> getClass(String className) {
        PrimitiveType primitiveType = PrimitiveType.getPrimitiveType(className.replace("[]", "").trim());
        if (primitiveType != null) {
            return className.contains("[]") ? primitiveType.getArrayClass() : primitiveType.getObjectClass();
        }
        return null;
    }
}

