/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.classes.generator.config;

import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;

public class ConfigurationClassGenerator {
    public static final String CONFIG_CLASS_GENERATOR = "configClassGenerator";
    public static final Validator VALIDATOR = ConfigurationClassGenerator.getValidator();

    public static Configuration configClassGenerator(String templateDirectory) throws Exception {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_31);
        configuration.setClassLoaderForTemplateLoading(ConfigurationClassGenerator.class.getClassLoader(), templateDirectory);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        configuration.setLogTemplateExceptions(false);
        configuration.setWrapUncheckedExceptions(true);
        return configuration;
    }

    private static Validator getValidator() {
        Validator validator = null;
        try {
            ValidatorFactory valdiatorFactory = Validation.buildDefaultValidatorFactory();
            validator = valdiatorFactory.getValidator();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return validator;
    }
}

