/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.classes.generator.utils;

import com.bld.commons.classes.model.EntityModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassGeneratorUtils {
    private static final String EXTENDS = "extends";
    private static final String PUBLIC = "public";
    private static final String PROTECTED = "protected";
    private static final String PRIVATE = "private";
    private static final String REGEX_ENTITY = "@Entity.*?class";
    private static final String REGEX_SUPER_CLASS = "@MappedSuperclass";
    private static final String REGEX_EXTENDS = "class.*?extends.*?\\{";
    private static final String REGEX_ID = "@(Id|EmbeddedId).*?(private|public|protected).*?(;|\\()";
    private static final String REGEX_IMPORT = "^import .*?;";
    private static final Log logger = LogFactory.getLog(ClassGeneratorUtils.class);
    private static final String extension = ".java";
    private static final Pattern PATTERN_ENTITY = Pattern.compile("@Entity.*?class");
    private static final Pattern PATTERN_SUPER_CLASS = Pattern.compile("@MappedSuperclass");
    private static final Pattern PATTERN_ID = Pattern.compile("@(Id|EmbeddedId).*?(private|public|protected).*?(;|\\()");
    private static final Pattern PATTERN_IMPORT = Pattern.compile("^import .*?;");
    private static final Pattern PATTERN_EXTENDS = Pattern.compile("class.*?extends.*?\\{");

    public static List<File> getFiles(String pathDir, String extension) {
        logger.debug("Path directory: " + pathDir);
        if (StringUtils.isNotEmpty((CharSequence)extension) && ((String)extension).charAt(0) != '.') {
            extension = "." + (String)extension;
        }
        ArrayList<File> files = new ArrayList<File>();
        File dir = new File(pathDir);
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                files.addAll(ClassGeneratorUtils.getFiles(file.getPath(), (String)extension));
                continue;
            }
            if (extension != null && (extension == null || !file.getPath().endsWith((String)extension))) continue;
            files.add(file);
        }
        return files;
    }

    public static List<File> getFiles(String pathDir) {
        return ClassGeneratorUtils.getFiles(pathDir, null);
    }

    public static <E, L extends Collection<E>> void addElements(L list, E[] elements) {
        if (ArrayUtils.isNotEmpty(elements)) {
            for (E element : elements) {
                list.add(element);
            }
        }
    }

    public static Set<EntityModel> entitiesModel(String pathDir, String prjPackage, String slash) throws Exception {
        return ClassGeneratorUtils.entitiesModel(pathDir, prjPackage, slash, new HashSet<EntityModel>(), null);
    }

    private static Set<EntityModel> entitiesModel(String pathDir, String prjPackage, String slash, Set<EntityModel> entitiesModel, EntityModel entityModel) throws Exception {
        File dir = new File(pathDir + slash + prjPackage.replace(".", slash));
        if (dir.exists()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory() || extension == null || !file.getPath().endsWith(extension)) continue;
                entityModel = ClassGeneratorUtils.getEntityModel(pathDir, prjPackage, slash, entitiesModel, entityModel, file);
            }
        }
        return entitiesModel;
    }

    private static EntityModel getEntityModel(String pathDir, String prjPackage, String slash, Set<EntityModel> entitiesModel, EntityModel entityModel, File file) throws FileNotFoundException, IOException, Exception {
        BufferedReader read = new BufferedReader(new FileReader(file));
        String line = null;
        HashMap<String, String> mapImport = new HashMap<String, String>();
        StringBuilder str = new StringBuilder("");
        logger.info("File: " + file.getName());
        while ((line = read.readLine()) != null) {
            str.append(line);
            Matcher matcher = PATTERN_IMPORT.matcher(line);
            while (matcher.find()) {
                String imp = matcher.group();
                imp = imp.replace(";", "");
                logger.debug(imp.substring(imp.lastIndexOf(".") + 1) + ", " + imp);
                mapImport.put(imp.substring(imp.lastIndexOf(".") + 1), imp);
            }
        }
        String textFile = str.toString();
        Matcher matcherEntity = PATTERN_ENTITY.matcher(textFile);
        boolean patternEntity = false;
        boolean patternId = false;
        while (matcherEntity.find()) {
            entityModel = new EntityModel();
            entityModel.setName(file.getName().replace(extension, ""));
            entityModel.setPackageName(prjPackage);
            logger.info("Entity: " + entityModel.getClassName());
            patternEntity = true;
            patternId = ClassGeneratorUtils.findTypeId(pathDir, prjPackage, slash, entitiesModel, entityModel, mapImport, textFile, patternId);
            ClassGeneratorUtils.findTypeIdInSuperClass(pathDir, prjPackage, slash, entitiesModel, entityModel, mapImport, textFile, patternId);
            entityModel = null;
        }
        if (!patternEntity && entityModel != null) {
            Matcher matcherSuperClass = PATTERN_SUPER_CLASS.matcher(textFile);
            while (matcherSuperClass.find()) {
                patternId = ClassGeneratorUtils.findTypeId(pathDir, prjPackage, slash, entitiesModel, entityModel, mapImport, textFile, patternId);
                ClassGeneratorUtils.findTypeIdInSuperClass(pathDir, prjPackage, slash, entitiesModel, entityModel, mapImport, textFile, patternId);
            }
        }
        return entityModel;
    }

    private static void findTypeIdInSuperClass(String pathDir, String prjPackage, String slash, Set<EntityModel> entitiesModel, EntityModel entityModel, Map<String, String> mapImport, String textFile, boolean patternId) throws Exception {
        if (!patternId) {
            Matcher matcherExtends = PATTERN_EXTENDS.matcher(textFile);
            while (matcherExtends.find()) {
                String classExtends = matcherExtends.group();
                classExtends = classExtends.substring(classExtends.indexOf(EXTENDS)).replace(EXTENDS, "").trim();
                classExtends = classExtends.substring(0, classExtends.indexOf(" ")).trim();
                logger.info("Class Extends: " + classExtends);
                String imp = ClassGeneratorUtils.getImport(pathDir, prjPackage, slash, mapImport, classExtends);
                String filePath = pathDir + slash + imp.replace(".", slash).replace("import ", "").trim() + extension;
                logger.info("Path: " + filePath);
                File file = new File(filePath);
                if (file.exists()) {
                    ClassGeneratorUtils.getEntityModel(pathDir, imp.substring(0, imp.indexOf("." + classExtends)), slash, entitiesModel, entityModel, file);
                    continue;
                }
                entityModel.setTypeId("Object");
            }
        }
    }

    private static boolean findTypeId(String pathDir, String prjPackage, String slash, Set<EntityModel> entitiesModel, EntityModel entityModel, Map<String, String> mapImport, String textFile, boolean patternId) {
        Matcher matcher = PATTERN_ID.matcher(textFile);
        while (matcher.find()) {
            patternId = true;
            String type = matcher.group();
            if (type.contains(PRIVATE)) {
                type = type.substring(type.indexOf(PRIVATE)).replace(PRIVATE, "").trim();
            } else if (type.contains(PROTECTED)) {
                type = type.substring(type.indexOf(PROTECTED)).replace(PROTECTED, "").trim();
            } else if (type.contains(PUBLIC)) {
                type = type.substring(type.indexOf(PUBLIC)).replace(PUBLIC, "").trim();
            }
            type = type.substring(0, type.indexOf(" ")).trim();
            String imp = ClassGeneratorUtils.getImport(pathDir, prjPackage, slash, mapImport, type);
            entityModel.setImp(imp);
            entityModel.setTypeId(type);
            entitiesModel.add(entityModel);
            logger.info("Entity: " + String.valueOf(entityModel));
        }
        return patternId;
    }

    private static String getImport(String pathDir, String prjPackage, String slash, Map<String, String> mapImport, String type) {
        logger.info("Type: " + type);
        Object imp = mapImport.get(type);
        if (StringUtils.isBlank((CharSequence)imp)) {
            File classFile = new File(pathDir + slash + prjPackage.replace(".", slash) + slash + type + extension);
            imp = classFile.exists() ? prjPackage + "." + type : "";
        }
        return imp;
    }

    public static Set<String> buildPackage(String pathDir, String prjPackage, String regex, String slash, Set<String> packages, Set<String> entities) throws Exception {
        Pattern pattern = Pattern.compile(regex);
        if (packages == null) {
            packages = new HashSet<String>();
        }
        packages.add(prjPackage.replace(".", slash));
        File dir = new File(pathDir + slash + prjPackage);
        if (dir.exists()) {
            for (File file : dir.listFiles()) {
                logger.debug(file);
                if (file.isDirectory() || extension == null || !file.getPath().endsWith(extension)) continue;
                BufferedReader read = new BufferedReader(new FileReader(file));
                String line = null;
                HashSet<String> compileds = new HashSet<String>();
                while ((line = read.readLine()) != null) {
                    Matcher matcher = pattern.matcher(line);
                    Matcher matcherEntity = PATTERN_ENTITY.matcher(line);
                    while (matcher.find()) {
                        String regexImport = matcher.group();
                        logger.debug("regexImport: " + regexImport);
                        regexImport = regexImport.replace("import", "");
                        if (packages.contains(regexImport = regexImport.substring(0, regexImport.lastIndexOf(".")).trim().replace(".", slash))) continue;
                        compileds.add(regexImport);
                    }
                    while (matcherEntity.find()) {
                        entities.add(prjPackage.replace(slash, ".") + "." + file.getName().replace(extension, ""));
                    }
                }
                if (read != null) {
                    read.close();
                }
                logger.debug("--------------------------------import: " + compileds.size() + "---------------------------------------------");
                for (String compiled : compileds) {
                    logger.debug("compile: " + compiled);
                    packages.addAll(ClassGeneratorUtils.buildPackage(pathDir, compiled, regex, slash, packages, entities));
                }
                packages.addAll(compileds);
            }
        }
        return packages;
    }
}

