/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.classes.model;

import com.bld.commons.classes.generator.annotation.FindImport;
import com.bld.commons.classes.model.ModelComponentClass;
import com.bld.commons.classes.model.ModelProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ModelAnnotation
implements ModelComponentClass {
    @JsonProperty(value="annotation")
    @FindImport
    @NotNull
    private String name;
    @Valid
    private List<ModelProperty> properties;

    public ModelAnnotation() {
        this.properties = new ArrayList<ModelProperty>();
    }

    public ModelAnnotation(String name) {
        this.name = name;
        this.properties = new ArrayList<ModelProperty>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ModelProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<ModelProperty> properties) {
        this.properties = properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelAnnotation other = (ModelAnnotation)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public String toString() {
        Object properties = "";
        for (ModelProperty property : this.properties) {
            properties = (String)properties + "," + property.toString();
        }
        if (StringUtils.isNotEmpty((CharSequence)properties)) {
            properties = "(" + ((String)properties).substring(1).trim() + ")";
        }
        if (!this.name.startsWith("@")) {
            this.name = "@" + this.name;
        }
        return this.name + (String)properties;
    }
}

