/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.classes.model;

import com.bld.commons.classes.attributes.LevelType;
import com.bld.commons.classes.generator.annotation.FindImport;
import com.bld.commons.classes.model.ModelGenericType;
import com.bld.commons.classes.model.ModelParameter;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ModelConstructor {
    @FindImport
    @NotNull(message="The \"type\" field can not be null to define the \"method\" entity")
    private @NotNull(message="The \"type\" field can not be null to define the \"method\" entity") String type;
    @JsonProperty(value="level")
    private LevelType levelType;
    @Valid
    private LinkedHashSet<ModelParameter> parameters;
    private List<String> commands;

    public ModelConstructor() {
        this.init();
    }

    private void init() {
        this.levelType = LevelType.PUBLIC;
        this.commands = new ArrayList<String>();
        this.parameters = new LinkedHashSet();
    }

    public ModelConstructor(String type) {
        this.type = type;
        this.init();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LevelType getLevelType() {
        return this.levelType;
    }

    public void setLevelType(LevelType levelType) {
        this.levelType = levelType;
    }

    public LinkedHashSet<ModelParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(LinkedHashSet<ModelParameter> parameters) {
        this.parameters = parameters;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public String toString() {
        Object methodGenericType = "";
        Object parameter = "";
        for (ModelParameter item : this.parameters) {
            parameter = (String)parameter + "," + item.toString();
            for (ModelGenericType gt : item.getGenericTypes()) {
                if (!StringUtils.isNotEmpty(gt.getExtend()) || gt.getName().equals("?")) continue;
                methodGenericType = (String)methodGenericType + "," + gt.toString();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)parameter)) {
            parameter = ((String)parameter).substring(1);
        }
        if (StringUtils.isNotEmpty((CharSequence)methodGenericType)) {
            methodGenericType = "<" + ((String)methodGenericType).substring(1) + ">";
        }
        Object command = "\n";
        for (String item : this.commands) {
            command = (String)command + item + "\n";
        }
        return this.levelType.getLevel() + " " + this.type + " (" + (String)parameter + "){" + (String)command + "    }";
    }
}

