/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.classes.model;

import com.bld.commons.classes.attributes.LevelType;
import com.bld.commons.classes.generator.annotation.FindImport;
import com.bld.commons.classes.model.ModelAnnotation;
import com.bld.commons.classes.model.ModelComponentClass;
import com.bld.commons.classes.model.ModelGenericType;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ModelField
implements ModelComponentClass {
    @JsonProperty(value="field")
    @NotNull(message="The \"field\" field can not be null to define the \"field\" entity")
    private @NotNull(message="The \"field\" field can not be null to define the \"field\" entity") String name;
    @FindImport
    @NotNull(message="The \"type\" field can not be null to define the \"field\" entity")
    private @NotNull(message="The \"type\" field can not be null to define the \"field\" entity") String type;
    @JsonProperty(value="generic-types")
    @Valid
    private List<ModelGenericType> genericTypes;
    @JsonProperty(value="level")
    private LevelType levelType;
    @JsonProperty(value="static")
    private boolean fieldStatic;
    @JsonProperty(value="final")
    private boolean fieldFinal;
    @Valid
    private Set<ModelAnnotation> annotations;
    private Object value;
    private boolean getter;
    private boolean setter;
    private boolean showQuotes;

    public ModelField() {
        this.init();
    }

    private void init() {
        this.annotations = new HashSet<ModelAnnotation>();
        this.levelType = LevelType.PRIVATE;
        this.fieldFinal = false;
        this.fieldStatic = false;
        this.getter = true;
        this.setter = true;
        this.genericTypes = new ArrayList<ModelGenericType>();
        this.showQuotes = true;
    }

    public ModelField(String name, String type) {
        this.name = name;
        this.type = type;
        this.init();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Set<ModelAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<ModelAnnotation> annotations) {
        this.annotations = annotations;
    }

    public LevelType getLevelType() {
        return this.levelType;
    }

    public void setLevelType(LevelType levelType) {
        this.levelType = levelType;
    }

    public boolean isFieldStatic() {
        return this.fieldStatic;
    }

    public void setFieldStatic(boolean fieldStatic) {
        this.fieldStatic = fieldStatic;
    }

    public boolean isFieldFinal() {
        return this.fieldFinal;
    }

    public void setFieldFinal(boolean fieldFinal) {
        this.fieldFinal = fieldFinal;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isGetter() {
        return this.getter;
    }

    public void setGetter(boolean getter) {
        this.getter = getter;
    }

    public boolean isSetter() {
        return this.setter;
    }

    public void setSetter(boolean setter) {
        this.setter = setter;
    }

    public void setGetterSetter(boolean getterSetter) {
        this.setSetter(getterSetter);
        this.setGetter(getterSetter);
    }

    public List<ModelGenericType> getGenericTypes() {
        return this.genericTypes;
    }

    public void setGenericTypes(List<ModelGenericType> genericTypes) {
        this.genericTypes = genericTypes;
    }

    public boolean isShowQuotes() {
        return this.showQuotes;
    }

    public void setShowQuotes(boolean showQuotes) {
        this.showQuotes = showQuotes;
    }

    public String toString() {
        Object genericType = "";
        for (ModelGenericType item : this.genericTypes) {
            genericType = (String)genericType + "," + item.toString();
        }
        if (StringUtils.isNotEmpty((CharSequence)genericType)) {
            genericType = "<" + ((String)genericType).substring(1) + ">";
        }
        Object value = "";
        if (this.value != null) {
            value = "=" + String.valueOf(this.type.equalsIgnoreCase("String") && this.showQuotes ? "\"" + this.value.toString() + "\"" : this.value);
        }
        return this.levelType.getLevel() + (this.fieldFinal ? " final" : "") + (this.fieldStatic ? " static" : "") + " " + this.type + (String)genericType + " " + this.name + (String)value + ";";
    }
}

