/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.classes.model;

import com.bld.commons.classes.attributes.LevelType;
import com.bld.commons.classes.generator.annotation.FindImport;
import com.bld.commons.classes.model.ModelAnnotation;
import com.bld.commons.classes.model.ModelComponentClass;
import com.bld.commons.classes.model.ModelGenericType;
import com.bld.commons.classes.model.ModelParameter;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ModelMethod
implements ModelComponentClass {
    @JsonProperty(value="method")
    @NotNull(message="The \"field\" field can not be null to define the \"method\" entity")
    private @NotNull(message="The \"field\" field can not be null to define the \"method\" entity") String name;
    @FindImport
    @NotNull(message="The \"type\" field can not be null to define the \"method\" entity")
    private @NotNull(message="The \"type\" field can not be null to define the \"method\" entity") String type;
    @JsonProperty(value="level")
    private LevelType levelType;
    @JsonProperty(value="static")
    private boolean staticMethod;
    @JsonProperty(value="abstract")
    private boolean abstractMethod;
    private Set<ModelAnnotation> annotations;
    @JsonProperty(value="generic-types")
    @Valid
    private List<ModelGenericType> genericTypes;
    @Valid
    private LinkedHashSet<ModelParameter> parameters;
    private List<String> commands;

    public ModelMethod() {
        this.init();
    }

    private void init() {
        this.annotations = new HashSet<ModelAnnotation>();
        this.levelType = LevelType.PUBLIC;
        this.staticMethod = false;
        this.abstractMethod = false;
        this.commands = new ArrayList<String>();
        this.genericTypes = new ArrayList<ModelGenericType>();
        this.parameters = new LinkedHashSet();
    }

    public ModelMethod(String name, String type) {
        this.name = name;
        this.type = type;
        this.init();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Set<ModelAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<ModelAnnotation> annotations) {
        this.annotations = annotations;
    }

    public LevelType getLevelType() {
        return this.levelType;
    }

    public void setLevelType(LevelType levelType) {
        this.levelType = levelType;
    }

    public boolean isStaticMethod() {
        return this.staticMethod;
    }

    public void setStaticMethod(boolean staticMethod) {
        this.staticMethod = staticMethod;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public void setCommands(Collection<String> commands) {
        if (CollectionUtils.isNotEmpty(commands)) {
            this.commands = new ArrayList<String>(commands);
        }
    }

    public List<ModelGenericType> getGenericTypes() {
        return this.genericTypes;
    }

    public void setGenericTypes(List<ModelGenericType> genericTypes) {
        this.genericTypes = genericTypes;
    }

    public LinkedHashSet<ModelParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(LinkedHashSet<ModelParameter> parameters) {
        this.parameters = parameters;
    }

    public boolean isAbstractMethod() {
        return this.abstractMethod;
    }

    public void setAbstractMethod(boolean abstractMethod) {
        this.abstractMethod = abstractMethod;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var4_7;
        Object methodGenericType = "";
        Object genericType = "";
        for (ModelGenericType modelGenericType : this.genericTypes) {
            if (StringUtils.isNotEmpty(modelGenericType.getExtend()) && !modelGenericType.getName().equals("?")) {
                methodGenericType = (String)methodGenericType + "," + modelGenericType.toString();
            }
            genericType = (String)genericType + "," + modelGenericType.getName();
        }
        Object parameter = "";
        for (ModelParameter item : this.parameters) {
            parameter = (String)parameter + "," + item.toString();
            for (ModelGenericType gt : item.getGenericTypes()) {
                if (!StringUtils.isNotEmpty(gt.getExtend()) || gt.getName().equals("?")) continue;
                methodGenericType = (String)methodGenericType + "," + gt.toString();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)parameter)) {
            parameter = ((String)parameter).substring(1);
        }
        if (StringUtils.isNotEmpty((CharSequence)methodGenericType)) {
            methodGenericType = "<" + ((String)methodGenericType).substring(1) + ">";
        }
        if (StringUtils.isNotEmpty((CharSequence)genericType)) {
            genericType = "<" + ((String)genericType).substring(1) + ">";
        }
        String string = "\n";
        for (String item : this.commands) {
            String string2 = (String)var4_7 + item + "\n";
        }
        return this.levelType.getLevel() + (this.abstractMethod ? " abstract" : "") + (this.staticMethod ? " static" : "") + " " + (String)methodGenericType + " " + this.type + (String)genericType + " " + this.name + "(" + (String)parameter + ")" + (String)(this.abstractMethod ? ";" : " {" + (String)var4_7 + "    }");
    }
}

