/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.utils.json.annotations.deserialize;

import com.bld.commons.utils.DateUtils;
import com.bld.commons.utils.json.annotations.DateChange;
import com.bld.commons.utils.json.annotations.DateTimeZone;
import com.bld.commons.utils.json.annotations.deserialize.data.DateChangeDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.security.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.AbstractEnvironment;

@JacksonStdImpl
public class DateDeserializer<T>
extends StdScalarDeserializer<T>
implements ContextualDeserializer {
    @Autowired
    private AbstractEnvironment env;
    private DateChangeDeserializer dateFilterDeserializer = null;

    public DateDeserializer() {
        super(Object.class);
    }

    private DateDeserializer(Class<T> classDate, DateChangeDeserializer dateDeserializer, AbstractEnvironment env) {
        super(classDate);
        this.dateFilterDeserializer = dateDeserializer;
        this.env = env;
    }

    protected Date getDate(String dateString) {
        Date date = null;
        try {
            Instant instant = Instant.parse(dateString);
            ZoneId zoneId = ZoneId.of(this.dateFilterDeserializer.getTimeZone());
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zoneId);
            date = Date.from(localDateTime.atZone(zoneId).toInstant());
        }
        catch (Exception e) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateFilterDeserializer.getFormat().replace("/", "-"));
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.dateFilterDeserializer.getTimeZone()));
                date = simpleDateFormat.parse(dateString);
            }
            catch (ParseException e1) {
                throw new RuntimeException(e1);
            }
        }
        return DateUtils.sumDate(date, this.dateFilterDeserializer.getAddYear(), this.dateFilterDeserializer.getAddMonth(), this.dateFilterDeserializer.getAddWeek(), this.dateFilterDeserializer.getAddDay(), this.dateFilterDeserializer.getAddHour(), this.dateFilterDeserializer.getAddMinute(), this.dateFilterDeserializer.getAddSecond());
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String dateString = p.getText();
        Comparable<Date> value = null;
        Date date = this.getDate(dateString);
        if (Date.class.isAssignableFrom(this._valueClass)) {
            value = date;
        }
        if (Calendar.class.isAssignableFrom(this._valueClass)) {
            value = DateUtils.dateToCalendar(date);
        }
        if (Timestamp.class.isAssignableFrom(this._valueClass)) {
            value = DateUtils.dateToTimestamp(date);
        }
        return (T)value;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        DateTimeZone dateTimeZone = (DateTimeZone)property.getAnnotation(DateTimeZone.class);
        DateChange dateFilter = (DateChange)property.getAnnotation(DateChange.class);
        this.dateFilter(dateTimeZone, dateFilter);
        if (property.getType() != null && property.getType().getRawClass() != null) {
            return new DateDeserializer<T>(property.getType().getRawClass(), this.dateFilterDeserializer, this.env);
        }
        return this;
    }

    private void dateFilter(DateTimeZone dateTimeZone, DateChange dateFilter) {
        String timeZone;
        if (dateTimeZone != null) {
            this.dateFilterDeserializer = new DateChangeDeserializer(dateTimeZone.timeZone(), dateTimeZone.format());
        } else if (dateFilter != null) {
            this.dateFilterDeserializer = new DateChangeDeserializer(dateFilter.timeZone(), dateFilter.format(), dateFilter.addYear(), dateFilter.addMonth(), dateFilter.addWeek(), dateFilter.addDay(), dateFilter.addHour(), dateFilter.addMinute(), dateFilter.addSecond());
        }
        String dateFormat = this.dateFilterDeserializer.getFormat();
        if (dateFormat.startsWith("${") && dateFormat.endsWith("}") && StringUtils.isBlank(dateFormat = this.env.resolvePlaceholders(this.dateFilterDeserializer.getFormat()))) {
            dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
        }
        if ((timeZone = this.dateFilterDeserializer.getTimeZone()).startsWith("${") && timeZone.endsWith("}")) {
            timeZone = this.env.resolvePlaceholders(this.dateFilterDeserializer.getTimeZone());
        }
        if (StringUtils.isBlank(timeZone)) {
            timeZone = TimeZone.getDefault().getID();
        }
        this.dateFilterDeserializer.setTimeZone(timeZone);
        this.dateFilterDeserializer.setFormat(dateFormat);
    }
}

