/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.yaml.converter.impl;

import com.bld.commons.classes.generator.utils.ClassGeneratorUtils;
import com.bld.commons.classes.generator.validator.ValidatorBuildClass;
import com.bld.commons.classes.model.ModelClasses;
import com.bld.commons.yaml.converter.ConvertYaml;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertYamlImpl
implements ConvertYaml {
    private static final Log logger = LogFactory.getLog(ConvertYamlImpl.class);

    @Override
    public List<ModelClasses> getListClasses(String path) throws Exception {
        logger.info("Start Convert");
        ArrayList<ModelClasses> containers = new ArrayList<ModelClasses>();
        if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            List<File> files = ClassGeneratorUtils.getFiles(path, "yaml");
            files.addAll(ClassGeneratorUtils.getFiles(path, "yml"));
            for (File file : files) {
                InputStreamReader reader = new InputStreamReader(new FileInputStream(file));
                ModelClasses container = (ModelClasses)objectMapper.readValue((Reader)reader, ModelClasses.class);
                logger.info("End convert");
                logger.info("Start validator");
                ValidatorBuildClass.checkValidatrBuildClass(container);
                containers.add(container);
                logger.info("End validator");
            }
        }
        return containers;
    }
}

