/*
 * Decompiled with CFR 0.152.
 */
package com.bld.processor;

import com.bld.commons.classes.generator.config.ConfigurationClassGenerator;
import com.bld.commons.classes.generator.impl.ClassesGeneratorImpl;
import com.bld.commons.classes.model.ModelClasses;
import com.bld.commons.processor.annotations.QueryBuilder;
import com.bld.processor.build.ClassBuilding;
import jakarta.persistence.Entity;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"jakarta.persistence.Entity", "bld.commons.processor.annotations.QueryBuilder"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class JpaProcessor
extends AbstractProcessor {
    private ModelClasses modelClasses = new ModelClasses();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.runAnnotation(roundEnv, Entity.class);
            this.runAnnotationWithGeneration(roundEnv, QueryBuilder.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
        return true;
    }

    private void runAnnotationWithGeneration(RoundEnvironment roundEnv, Class<? extends Annotation> classAnnotation) throws Exception {
        this.runAnnotation(roundEnv, classAnnotation);
        ClassesGeneratorImpl generatorClass = new ClassesGeneratorImpl(ConfigurationClassGenerator.configClassGenerator("/template"));
        generatorClass.writeClass(this.modelClasses, this.processingEnv);
    }

    private void runAnnotation(RoundEnvironment roundEnv, Class<? extends Annotation> classAnnotation) throws Exception {
        this.modelClasses = new ModelClasses();
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(classAnnotation);
        Set<TypeElement> types = ElementFilter.typesIn(annotatedElements);
        for (TypeElement type : types) {
            System.out.println(type);
            Annotation annotation = type.getAnnotation(classAnnotation);
            if (annotation == null) continue;
            if (Entity.class.isAssignableFrom(classAnnotation)) {
                ClassBuilding.generateJpaClass(this.modelClasses, type);
                continue;
            }
            if (!QueryBuilder.class.isAssignableFrom(classAnnotation)) continue;
            AnnotationMirror annotationMirror = null;
            for (AnnotationMirror annotationMirror2 : type.getAnnotationMirrors()) {
                if (!classAnnotation.getName().equals(annotationMirror2.getAnnotationType().toString())) continue;
                annotationMirror = annotationMirror2;
                break;
            }
            for (TypeMirror typeMirror : type.getInterfaces()) {
                String servicePackage = typeMirror.toString().substring(0, typeMirror.toString().lastIndexOf("."));
                if (!(typeMirror instanceof DeclaredType)) continue;
                TypeElement te = (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror);
                for (TypeMirror typeMirror2 : te.getInterfaces()) {
                    if (!(typeMirror instanceof DeclaredType)) continue;
                    DeclaredType dclt = (DeclaredType)typeMirror2;
                    TypeMirror argument = dclt.getTypeArguments().get(0);
                    TypeElement typeArgument = (TypeElement)this.processingEnv.getTypeUtils().asElement(argument);
                    ClassBuilding.generateQueryClass(this.modelClasses, typeArgument, servicePackage, this.processingEnv, type.getAnnotation(QueryBuilder.class), annotationMirror, type);
                }
            }
        }
    }
}

