/*
 * Decompiled with CFR 0.152.
 */
package com.bld.processor.build;

import com.bld.commons.classes.attributes.ClassType;
import com.bld.commons.classes.attributes.LevelType;
import com.bld.commons.classes.attributes.PrimitiveType;
import com.bld.commons.classes.model.ModelAnnotation;
import com.bld.commons.classes.model.ModelClass;
import com.bld.commons.classes.model.ModelClasses;
import com.bld.commons.classes.model.ModelField;
import com.bld.commons.classes.model.ModelGenericType;
import com.bld.commons.classes.model.ModelMethod;
import com.bld.commons.classes.model.ModelSuperClass;
import com.bld.commons.processor.ConditionType;
import com.bld.commons.processor.annotations.ConditionBuilder;
import com.bld.commons.processor.annotations.CustomConditionBuilder;
import com.bld.commons.processor.annotations.JpqlOrderBuilder;
import com.bld.commons.processor.annotations.NativeOrderBuilder;
import com.bld.commons.processor.annotations.OrderAlias;
import com.bld.commons.processor.annotations.QueryBuilder;
import com.bld.commons.reflection.utils.ReflectionCommons;
import com.bld.processor.data.ClassField;
import com.bld.processor.data.QueryDetail;
import com.bld.processor.exception.ProcessorJpaServiceException;
import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.lang.invoke.CallSite;
import java.security.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;

public class ClassBuilding {
    private static final String ID = "<id>";
    private static final String ORD = "ord_";
    private static final String JOINS = "joins";
    private static final String CONDITIONS = "conditions";
    private static final String SPACE = "        ";
    private static final String OVERRIDE = "Override";
    private static final String FROM_BY_FILTER = "FROM_BY_FILTER";
    private static final String COUNT_BY_FILTER = "COUNT_BY_FILTER";
    private static final String SELECT_BY_FILTER = "SELECT_BY_FILTER";
    private static final String SELECT_ID_BY_FILTER = "SELECT_ID_BY_FILTER";
    private static final String DELETE_BY_FILTER = "DELETE_BY_FILTER";
    private static final String STRING = "String";
    private static final String COMPONENT = "Component";
    private static final String QUERY_JPQL = "QueryJpql";
    private static final String QUERY_JPQL_IMPL = "QueryJpqlImpl";
    private static final ModelAnnotation ANNOTATION_COMPONENT = ClassBuilding.getModelAnnotation("Component");
    private static final ModelAnnotation ANNOTATION_OVERRIDE = new ModelAnnotation("Override");
    private static final ModelMethod SELECT_BY_FILTER_METHOD = ClassBuilding.returnMethodService("selectByFilter", "String", "        return SELECT_BY_FILTER;", LevelType.PUBLIC);
    private static final ModelMethod SELECT_ID_BY_FILTER_METHOD = ClassBuilding.returnMethodService("selectIdByFilter", "String", "        return SELECT_ID_BY_FILTER;", LevelType.PUBLIC);
    private static final ModelMethod COUNT_BY_FILTER_METHOD = ClassBuilding.returnMethodService("countByFilter", "String", "        return COUNT_BY_FILTER;", LevelType.PUBLIC);
    private static final ModelMethod DELETE_BY_FILTER_METHOD = ClassBuilding.returnMethodService("deleteByFilter", "String", "        return DELETE_BY_FILTER;", LevelType.PUBLIC);
    private static final ModelField MAP_CONDITIONS_FIELD = ClassBuilding.getFieldMapConditions("MAP_CONDITIONS", "getMapConditions()");
    private static final ModelField MAP_NATIVE_CONDITIONS_FIELD = ClassBuilding.getFieldMapNativeConditions("MAP_NATIVE_CONDITIONS", "getMapNativeConditions()");
    private static final ModelField MAP_NATIVE_ORDERS_FIELD = ClassBuilding.getFieldMapConditions("MAP_NATIVE_ORDERS", "getMapNativeOrders()");
    private static final ModelField MAP_JPA_ORDERS_FIELD = ClassBuilding.getFieldMapConditions("MAP_JPA_ORDERS", "getMapJpaOrders()");
    private static final ModelMethod MAP_CONDITIONS_METHOD = ClassBuilding.getConditions("mapConditions", "return MAP_CONDITIONS;");
    private static final ModelMethod MAP_DELETE_CONDITIONS_METHOD = ClassBuilding.getConditions("mapDeleteConditions", "return MAP_DELETE_CONDITIONS;");
    private static final ModelMethod MAP_NATIVE_CONDITIONS_METHOD = ClassBuilding.getNativeConditions("mapNativeConditions", "return MAP_NATIVE_CONDITIONS;");
    private static final ModelMethod MAP_NATIVE_ORDERS_METHOD = ClassBuilding.getConditions("mapNativeOrders", "return MAP_NATIVE_ORDERS;");
    private static final ModelMethod MAP_JPA_ORDERS_METHOD = ClassBuilding.getConditions("mapJpaOrders", "return MAP_JPA_ORDERS;");
    private static final ModelField MAP_DELETE_CONDITIONS_FIELD = ClassBuilding.getFieldMapConditions("MAP_DELETE_CONDITIONS", "getMapDeleteConditions()");
    private static Map<String, ClassField> mapClassField = new HashMap<String, ClassField>();
    private static Map<String, List<String>> mapListConditions = new HashMap<String, List<String>>();

    /*
     * WARNING - void declaration
     */
    public static void generateQueryClass(ModelClasses modelClasses, TypeElement type, String servicePackage, ProcessingEnvironment processingEnv, QueryBuilder queryBuilder, AnnotationMirror annotationMirror, TypeElement typeService) throws Exception {
        AnnotationValue annotationValue;
        Object manies;
        String joinPath;
        mapListConditions = new HashMap<String, List<String>>();
        ModelClass classQueryJpql = new ModelClass();
        ModelClass interfaceQueryJpql = new ModelClass();
        interfaceQueryJpql.setType(ClassType.INTERFACE);
        String classEntity = type.getQualifiedName().toString().substring(type.getQualifiedName().toString().lastIndexOf(".") + 1);
        String fieldEntity = Character.toLowerCase(classEntity.charAt(0)) + classEntity.substring(1);
        classQueryJpql.setName(classEntity + QUERY_JPQL_IMPL);
        interfaceQueryJpql.setName(classEntity + QUERY_JPQL);
        classQueryJpql.setPackageName(servicePackage);
        interfaceQueryJpql.setPackageName(servicePackage);
        classQueryJpql.addAnnotations(ANNOTATION_COMPONENT);
        TypeElement typeElement = type;
        ArrayList<String> mapBaseConditions = new ArrayList<String>();
        ArrayList<String> mapNativeConditions = new ArrayList<String>();
        ArrayList<String> mapConditions = new ArrayList<String>();
        LinkedHashSet<String> mapDeleteConditions = new LinkedHashSet<String>();
        LinkedHashSet<String> mapJpaOrders = new LinkedHashSet<String>();
        ArrayList<String> mapNativeOrders = new ArrayList<String>();
        LinkedHashSet<String> mapOneToMany = new LinkedHashSet<String>();
        classQueryJpql.getImports().add("java.util.HashMap");
        classQueryJpql.getImports().add(type.getQualifiedName().toString());
        mapBaseConditions.add("        Map<String,String> map=new HashMap<>();");
        mapDeleteConditions.add("        Map<String,String> map=getMapBaseConditions();");
        mapConditions.add("        Map<String,String> map=getMapBaseConditions();");
        mapNativeConditions.add("        Map<String,Map<String,String>> map=new HashMap<>();");
        mapJpaOrders.add("        Map<String,String> map=new HashMap<>();");
        mapNativeOrders.add("        Map<String,String> map=new HashMap<>();");
        HashMap<CallSite, String> mapOrder = new HashMap<CallSite, String>();
        HashMap<String, QueryDetail> mapAlias = new HashMap<String, QueryDetail>();
        mapAlias.put(fieldEntity, new QueryDetail(fieldEntity, fieldEntity, mapClassField.get(type.asType().toString())));
        HashSet<String> aliases = new HashSet<String>();
        aliases.add(fieldEntity);
        String distinct = " distinct";
        if (!queryBuilder.distinct()) {
            distinct = "";
        }
        String selectByFilter = "\"select" + distinct + " " + fieldEntity + "\"";
        Object selectIdByFilter = "\"select" + distinct + " <id> \"";
        String deleteByFilter = "\"delete from " + classEntity + " " + fieldEntity + " \"";
        String countByFilter = "\"select" + distinct + " count(" + fieldEntity + ")\"";
        Object fromByFilter = " From " + classEntity + " " + fieldEntity + " \"";
        Set<Element> elements = mapClassField.get(type.getQualifiedName().toString()).getElements();
        HashSet<String> manyProps = new HashSet<String>();
        TreeSet<String> keyConditions = new TreeSet<String>();
        for (Element element : elements) {
            JoinColumn[] fieldElementsId;
            String elementToString = element.asType().toString().trim().replace("@" + NotNull.class.getName() + " ", "");
            if (elementToString.contains(" ")) {
                elementToString = elementToString.substring(elementToString.lastIndexOf(" ")).trim();
            }
            ClassField classField = mapClassField.get(elementToString);
            String fieldName = element.getSimpleName().toString();
            if (element.getAnnotation(EmbeddedId.class) != null || element.getAnnotation(Id.class) != null) {
                if (element.getAnnotation(EmbeddedId.class) != null) {
                    TypeElement typeElement2;
                    TypeElement typeElement3 = (TypeElement)processingEnv.getTypeUtils().asElement(element.asType());
                    fieldElementsId = new HashSet();
                    do {
                        void var36_66;
                        for (Element element2 : var36_66.getEnclosedElements()) {
                            if (!ElementKind.FIELD.equals((Object)element2.getKind()) || fieldElementsId.contains(element2) || element2.getAnnotation(Column.class) == null) continue;
                            fieldElementsId.add(element2);
                            mapBaseConditions.add("        map.put(" + element2.getSimpleName().toString() + ", \" and " + fieldEntity + ".id." + element2.getSimpleName().toString() + " in (:" + element2.getSimpleName().toString() + ") \");");
                            mapBaseConditions.add("        map.put(" + element2.getSimpleName().toString() + "Not, \" and " + fieldEntity + ".id." + element2.getSimpleName().toString() + " not in (:" + element2.getSimpleName().toString() + "Not) \");");
                            mapJpaOrders.add("        map.put(\"" + fieldEntity + ".id." + element2.getSimpleName().toString() + "\",\"" + fieldEntity + ".id." + element2.getSimpleName().toString() + "\");");
                            keyConditions.add(element2.getSimpleName().toString());
                            keyConditions.add(element2.getSimpleName().toString() + "Not");
                        }
                        TypeMirror superClassIdTypeMirror = var36_66.getSuperclass();
                        typeElement2 = (TypeElement)processingEnv.getTypeUtils().asElement(superClassIdTypeMirror);
                    } while (!Object.class.getName().equals(typeElement2.getQualifiedName().toString()));
                } else {
                    mapBaseConditions.add("        map.put(" + element.getSimpleName().toString() + ", \" and " + fieldEntity + "." + element.getSimpleName().toString() + " in (:" + element.getSimpleName().toString() + ") \");");
                    mapJpaOrders.add("        map.put(\"" + fieldEntity + "." + element.getSimpleName().toString() + "\",\"" + fieldEntity + "." + element.getSimpleName().toString() + "\");");
                    keyConditions.add(element.getSimpleName().toString());
                }
                mapBaseConditions.add("        map.put(id, \" and " + fieldEntity + "." + element.getSimpleName().toString() + " in (:id) \");");
                keyConditions.add("id");
                selectIdByFilter = ((String)selectIdByFilter).replace(ID, fieldEntity + "." + element.getSimpleName().toString());
                continue;
            }
            if (element.getAnnotation(Column.class) != null) {
                void var36_70;
                Class<?> clazz = PrimitiveType.getClass(element.asType().toString());
                if (clazz == null) {
                    Class<?> clazz2 = Class.forName(element.asType().toString());
                }
                if (Calendar.class.isAssignableFrom((Class<?>)var36_70) || Date.class.isAssignableFrom((Class<?>)var36_70) || Timestamp.class.isAssignableFrom((Class<?>)var36_70)) {
                    mapBaseConditions.add("        map.put(" + fieldName + "From, \" and :" + fieldName + "From<=" + fieldEntity + "." + fieldName + " \");");
                    mapBaseConditions.add("        map.put(" + fieldName + "To, \" and " + fieldEntity + "." + fieldName + "<=:" + fieldName + "To \");");
                    mapBaseConditions.add("        map.put(" + fieldName + ", \" and " + fieldEntity + "." + fieldName + "=:" + fieldName + " \");");
                    keyConditions.add(fieldName + "From");
                    keyConditions.add(fieldName + "To");
                } else if (String.class.isAssignableFrom((Class<?>)var36_70)) {
                    mapBaseConditions.add("        map.put(" + fieldName + ", \" and upper(" + fieldEntity + "." + fieldName + ") like :" + fieldName + " \");");
                } else if (Boolean.class.isAssignableFrom((Class<?>)var36_70)) {
                    mapBaseConditions.add("        map.put(" + fieldName + ", \" and " + fieldEntity + "." + fieldName + "= :" + fieldName + " \");");
                } else {
                    mapBaseConditions.add("        map.put(" + fieldName + ", \" and " + fieldEntity + "." + fieldName + " in (:" + fieldName + ") \");");
                }
                mapJpaOrders.add("        map.put(\"" + fieldEntity + "." + fieldName + "\",\"" + fieldEntity + "." + fieldName + "\");");
                keyConditions.add(fieldName);
                continue;
            }
            if (element.getAnnotation(ManyToOne.class) != null) {
                JoinColumns joinColumns = element.getAnnotation(JoinColumns.class);
                if (joinColumns != null) {
                    void var39_93;
                    fieldElementsId = joinColumns.value();
                    int superClassIdTypeMirror = fieldElementsId.length;
                    boolean bl = false;
                    while (var39_93 < superClassIdTypeMirror) {
                        JoinColumn joinColumn = fieldElementsId[var39_93];
                        fromByFilter = ClassBuilding.manyToOneJoinColumn(fieldEntity, mapConditions, mapDeleteConditions, mapJpaOrders, mapAlias, aliases, (String)fromByFilter, manyProps, keyConditions, element, classField, fieldName, joinColumn);
                        ++var39_93;
                    }
                    continue;
                }
                JoinColumn joinColumn = element.getAnnotation(JoinColumn.class);
                fromByFilter = ClassBuilding.manyToOneJoinColumn(fieldEntity, mapConditions, mapDeleteConditions, mapJpaOrders, mapAlias, aliases, (String)fromByFilter, manyProps, keyConditions, element, classField, fieldName, joinColumn);
                continue;
            }
            if (element.getAnnotation(OneToOne.class) != null) {
                fromByFilter = ClassBuilding.fromManyAndOneToOne(fieldEntity, mapAlias, aliases, (String)fromByFilter, classField, fieldName, ClassBuilding.nullableOneToOne(element));
                continue;
            }
            if (element.getAnnotation(OneToMany.class) == null && element.getAnnotation(ManyToMany.class) == null) continue;
            DeclaredType declaredType = (DeclaredType)element.asType();
            ClassField classFieldRefernce = mapClassField.get(declaredType.getTypeArguments().get(0).toString());
            Map<String, Element> mapField = classFieldRefernce.getMapElement();
            Object var39_94 = null;
            Set<Element> listReferenceField = classFieldRefernce.getElements();
            if (element.getAnnotation(OneToMany.class) != null) {
                OneToMany oneToMany = element.getAnnotation(OneToMany.class);
                Element element3 = mapField.get(oneToMany.mappedBy());
                for (Element fieldOneToMany : listReferenceField) {
                    if (fieldOneToMany.getAnnotation(Id.class) == null || element3.getAnnotation(JoinColumn.class) == null) continue;
                    JoinColumn joinColumn = element3.getAnnotation(JoinColumn.class);
                    Object keyProps = fieldOneToMany.getSimpleName().toString();
                    if (manyProps.contains(keyProps)) {
                        keyProps = fieldName + Character.toUpperCase(fieldOneToMany.getSimpleName().toString().charAt(0)) + fieldOneToMany.getSimpleName().toString().substring(1);
                    }
                    manyProps.add((String)keyProps);
                    mapOneToMany.add("        addJoinOneToMany(" + (String)keyProps + ", \" left join fetch " + fieldEntity + "." + fieldName + " " + fieldName + " \");");
                    mapConditions.add("        map.put(" + (String)keyProps + ", \" and " + fieldName + "." + fieldOneToMany.getSimpleName().toString() + " in (:" + (String)keyProps + ") \");");
                    mapJpaOrders.add("        map.put(\"" + fieldName + "." + fieldOneToMany.getSimpleName().toString() + "\",\"" + fieldName + "." + fieldOneToMany.getSimpleName().toString() + "\");");
                    keyConditions.add((String)keyProps);
                    QueryDetail queryDetail = new QueryDetail(fieldName, fieldName, joinColumn.nullable(), true, classFieldRefernce);
                    mapAlias.put(fieldEntity + "." + fieldName, queryDetail);
                    aliases.add(fieldName);
                }
                continue;
            }
            for (Element fieldManyToMany : listReferenceField) {
                if (fieldManyToMany.getAnnotation(Id.class) == null) continue;
                String keyProps = fieldName + Character.toUpperCase(fieldManyToMany.getSimpleName().toString().charAt(0)) + fieldManyToMany.getSimpleName().toString().substring(1);
                manyProps.add(keyProps);
                mapOneToMany.add("        addJoinOneToMany(" + keyProps + ", \" left join fetch " + fieldEntity + "." + fieldName + " " + fieldName + " \");");
                mapConditions.add("        map.put(" + keyProps + ", \" and " + fieldName + "." + fieldManyToMany.getSimpleName().toString() + " in (:" + keyProps + ") \");");
                mapJpaOrders.add("        map.put(\"" + fieldName + "." + fieldManyToMany.getSimpleName().toString() + "\",\"" + fieldName + "." + fieldManyToMany.getSimpleName().toString() + "\");");
                keyConditions.add(keyProps);
                QueryDetail queryDetail = new QueryDetail(fieldName, fieldName, false, true, classFieldRefernce);
                mapAlias.put(fieldEntity + "." + fieldName, queryDetail);
                aliases.add(fieldName);
            }
        }
        for (String string : queryBuilder.joins()) {
            LinkedHashSet<String> manies2 = new LinkedHashSet<String>();
            fromByFilter = ClassBuilding.buildJoin(type, processingEnv, mapConditions, mapOneToMany, mapAlias, aliases, (String)fromByFilter, manyProps, string, null, typeService, annotationMirror, JOINS, manies2, keyConditions);
        }
        for (ConditionBuilder conditionBuilder : queryBuilder.conditions()) {
            joinPath = conditionBuilder.field().substring(0, conditionBuilder.field().lastIndexOf("."));
            String string = conditionBuilder.field().substring(conditionBuilder.field().lastIndexOf(".") + 1);
            manies = new LinkedHashSet<String>();
            fromByFilter = ClassBuilding.buildJoin(type, processingEnv, mapConditions, mapOneToMany, mapAlias, aliases, (String)fromByFilter, manyProps, joinPath, conditionBuilder.parameter(), typeService, annotationMirror, CONDITIONS, manies, keyConditions);
            QueryDetail queryDetail = (QueryDetail)mapAlias.get(joinPath);
            if (queryDetail == null) {
                String string2 = "The field path \"" + conditionBuilder.field() + "\" is not valid";
                annotationValue = ClassBuilding.getAnnotationValue(annotationMirror, CONDITIONS);
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string2, typeService, annotationMirror, annotationValue);
                throw new ProcessorJpaServiceException(string2);
            }
            ClassField classField = queryDetail.getClassField();
            Element fieldElement = classField.getMapElement().get(string);
            if (fieldElement == null) {
                AnnotationValue annotationValue2 = ClassBuilding.getAnnotationValue(annotationMirror, CONDITIONS);
                String errorMessage = "The \"" + string + "\" field does not exist";
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, errorMessage, typeService, annotationMirror, annotationValue2);
                throw new ProcessorJpaServiceException(errorMessage);
            }
            Class<?> classFieldElement = PrimitiveType.getClass(fieldElement.asType().toString());
            if (classFieldElement == null) {
                classFieldElement = Class.forName(fieldElement.asType().toString());
            }
            if (String.class.isAssignableFrom(classFieldElement)) {
                mapConditions.add("        map.put(" + conditionBuilder.parameter() + ", \" and (" + conditionBuilder.upperLower().getFunction() + "(" + queryDetail.getAlias() + "." + string + ") " + conditionBuilder.operation().getValue().replace("<PROPERTY>", ":" + conditionBuilder.parameter()) + (String)(conditionBuilder.nullable() ? " or " + queryDetail.getAlias() + "." + string + " is null " : "") + ")\");");
                mapDeleteConditions.add("        map.put(" + conditionBuilder.parameter() + ", \" and (" + conditionBuilder.upperLower().getFunction() + "(" + conditionBuilder.field() + ") " + conditionBuilder.operation().getValue().replace("<PROPERTY>", ":" + conditionBuilder.parameter()) + (String)(conditionBuilder.nullable() ? " or " + conditionBuilder.field() + " is null " : "") + ") \");");
            } else {
                mapConditions.add("        map.put(" + conditionBuilder.parameter() + ", \" and (" + queryDetail.getAlias() + "." + string + " " + conditionBuilder.operation().getValue().replace("<PROPERTY>", ":" + conditionBuilder.parameter()) + (String)(conditionBuilder.nullable() ? " or " + queryDetail.getAlias() + "." + string + " is null " : "") + ")\");");
                mapDeleteConditions.add("        map.put(" + conditionBuilder.parameter() + ", \" and (" + conditionBuilder.field() + " " + conditionBuilder.operation().getValue().replace("<PROPERTY>", ":" + conditionBuilder.parameter()) + (String)(conditionBuilder.nullable() ? " or " + conditionBuilder.field() + " is null " : "") + ")\");");
            }
            mapJpaOrders.add("        map.put(\"" + queryDetail.getAlias() + "." + string + "\",\"" + queryDetail.getAlias() + "." + string + "\");");
            keyConditions.add(conditionBuilder.parameter());
            if (!queryDetail.isMany()) continue;
            mapOneToMany.add("        addJoinOneToMany(" + conditionBuilder.parameter() + ", " + ClassBuilding.printManies((LinkedHashSet<String>)manies) + ");");
        }
        for (CustomConditionBuilder customConditionBuilder : queryBuilder.customConditions()) {
            ClassBuilding.writeCustomCondition(mapConditions, mapDeleteConditions, customConditionBuilder, keyConditions);
        }
        for (CustomConditionBuilder customConditionBuilder : queryBuilder.customNativeConditions()) {
            ClassBuilding.nativeCondition(customConditionBuilder, classQueryJpql);
            keyConditions.add(customConditionBuilder.parameter());
        }
        for (Map.Entry entry : mapListConditions.entrySet()) {
            String method = "get" + Character.toUpperCase(((String)entry.getKey()).charAt(0)) + ((String)entry.getKey()).substring(1);
            ModelMethod modelMethod = ClassBuilding.getMapConditions(method, (Collection)entry.getValue());
            classQueryJpql.getMethods().add(modelMethod);
            mapNativeConditions.add("        map.put(\"" + (String)entry.getKey() + "\"," + method + "());");
        }
        for (JpqlOrderBuilder jpqlOrderBuilder : queryBuilder.jpaOrder()) {
            if (ArrayUtils.isNotEmpty(jpqlOrderBuilder.alias())) {
                HashMap<String, CallSite> mapping = new HashMap<String, CallSite>();
                for (OrderAlias orderAlias : jpqlOrderBuilder.alias()) {
                    String joinPath3 = orderAlias.field().substring(0, orderAlias.field().lastIndexOf("."));
                    String field2 = orderAlias.field().substring(orderAlias.field().lastIndexOf(".") + 1);
                    LinkedHashSet<String> manies3 = new LinkedHashSet<String>();
                    fromByFilter = ClassBuilding.buildJoin(type, processingEnv, mapConditions, mapOneToMany, mapAlias, aliases, (String)fromByFilter, manyProps, joinPath3, jpqlOrderBuilder.key(), typeService, annotationMirror, CONDITIONS, manies3, keyConditions);
                    QueryDetail queryDetail = (QueryDetail)mapAlias.get(joinPath3);
                    if (queryDetail == null) {
                        String errorMessage = "The field path \"" + jpqlOrderBuilder.order() + "\" is not valid";
                        AnnotationValue annotationValue3 = ClassBuilding.getAnnotationValue(annotationMirror, CONDITIONS);
                        processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, errorMessage, typeService, annotationMirror, annotationValue3);
                        throw new ProcessorJpaServiceException(errorMessage);
                    }
                    mapping.put(orderAlias.alias(), (CallSite)((Object)(queryDetail.getAlias() + "." + field2)));
                }
                StringSubstitutor stringSubstitutor = new StringSubstitutor(mapping);
                String order = stringSubstitutor.replace(jpqlOrderBuilder.order()).trim();
                mapJpaOrders.add("        map.put(ord_" + jpqlOrderBuilder.key().replace(".", "_") + ", \" " + order + " \");");
            } else {
                joinPath = jpqlOrderBuilder.order().substring(0, jpqlOrderBuilder.order().lastIndexOf("."));
                String string = jpqlOrderBuilder.order().substring(jpqlOrderBuilder.order().lastIndexOf(".") + 1);
                manies = new LinkedHashSet();
                fromByFilter = ClassBuilding.buildJoin(type, processingEnv, mapConditions, mapOneToMany, mapAlias, aliases, (String)fromByFilter, manyProps, joinPath, jpqlOrderBuilder.key(), typeService, annotationMirror, CONDITIONS, manies, keyConditions);
                QueryDetail queryDetail = (QueryDetail)mapAlias.get(joinPath);
                if (queryDetail == null) {
                    String string3 = "The field path \"" + jpqlOrderBuilder.order() + "\" is not valid";
                    annotationValue = ClassBuilding.getAnnotationValue(annotationMirror, CONDITIONS);
                    processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string3, typeService, annotationMirror, annotationValue);
                    throw new ProcessorJpaServiceException(string3);
                }
                mapJpaOrders.add("        map.put(ord_" + jpqlOrderBuilder.key().replace(".", "_") + ", \" " + queryDetail.getAlias() + "." + string + " \");");
            }
            keyConditions.add(ORD + jpqlOrderBuilder.key().replace(".", "_"));
            mapOrder.put((CallSite)((Object)(ORD + jpqlOrderBuilder.key().replace(".", "_"))), jpqlOrderBuilder.key());
        }
        for (NativeOrderBuilder nativeOrderBuilder : queryBuilder.nativeOrder()) {
            mapNativeOrders.add("        map.put(ord_" + nativeOrderBuilder.key().replace(".", "_") + ", \" " + nativeOrderBuilder.order().trim() + " \");");
            keyConditions.add(ORD + nativeOrderBuilder.key().replace(".", "_"));
            mapOrder.put((CallSite)((Object)(ORD + nativeOrderBuilder.key().replace(".", "_"))), nativeOrderBuilder.key());
        }
        TypeMirror superClassTypeMirror = typeElement.getSuperclass();
        typeElement = (TypeElement)processingEnv.getTypeUtils().asElement(superClassTypeMirror);
        fromByFilter = ((String)fromByFilter).substring(0, ((String)fromByFilter).length() - 1);
        ModelField modelField = ClassBuilding.finalStaticField(FROM_BY_FILTER, STRING, fromByFilter, true);
        ModelField countByFilterField = ClassBuilding.finalStaticField(COUNT_BY_FILTER, STRING, countByFilter + "+FROM_BY_FILTER", false);
        ModelField modelField2 = ClassBuilding.finalStaticField(SELECT_BY_FILTER, STRING, selectByFilter + "+FROM_BY_FILTER", false);
        ModelField selectIdByFilterField = ClassBuilding.finalStaticField(SELECT_ID_BY_FILTER, STRING, (String)selectIdByFilter + "+FROM_BY_FILTER", false);
        ModelField modelField3 = ClassBuilding.finalStaticField(DELETE_BY_FILTER, STRING, deleteByFilter, false);
        for (String keyCondition : keyConditions) {
            interfaceQueryJpql.addFields(ClassBuilding.finalStaticField(keyCondition, STRING, mapOrder.containsKey(keyCondition) ? mapOrder.get(keyCondition) : keyCondition, true, LevelType.PUBLIC));
        }
        classQueryJpql.addExtendsClass(ClassBuilding.getSuperClassQueryJpql(classEntity));
        classQueryJpql.addInterface(ClassBuilding.getInterfaceQueryJpql(classEntity));
        classQueryJpql.getFields().add(MAP_CONDITIONS_FIELD);
        classQueryJpql.getFields().add(MAP_DELETE_CONDITIONS_FIELD);
        classQueryJpql.getFields().add(MAP_NATIVE_CONDITIONS_FIELD);
        classQueryJpql.getFields().add(MAP_NATIVE_ORDERS_FIELD);
        classQueryJpql.getFields().add(MAP_JPA_ORDERS_FIELD);
        classQueryJpql.getFields().add(modelField);
        classQueryJpql.getFields().add(countByFilterField);
        classQueryJpql.getFields().add(modelField2);
        classQueryJpql.getFields().add(selectIdByFilterField);
        classQueryJpql.getFields().add(modelField3);
        classQueryJpql.getMethods().add(SELECT_BY_FILTER_METHOD);
        classQueryJpql.getMethods().add(SELECT_ID_BY_FILTER_METHOD);
        classQueryJpql.getMethods().add(COUNT_BY_FILTER_METHOD);
        classQueryJpql.getMethods().add(DELETE_BY_FILTER_METHOD);
        mapConditions.add("        return map;");
        mapBaseConditions.add("        return map;");
        mapDeleteConditions.add("        return map;");
        mapNativeConditions.add("        return map;");
        mapJpaOrders.add("        return map;");
        mapNativeOrders.add("        return map;");
        ModelMethod staticMapConditions = ClassBuilding.getMapConditions("getMapConditions", mapConditions);
        ModelMethod staticMapBaseConditions = ClassBuilding.getMapConditions("getMapBaseConditions", mapBaseConditions);
        ModelMethod modelMethod = ClassBuilding.getMapConditions("getMapDeleteConditions", mapDeleteConditions);
        ModelMethod staticMapNativeConditions = ClassBuilding.getMapNativeConditions("getMapNativeConditions", mapNativeConditions);
        ModelMethod staticMapNativeOrders = ClassBuilding.getMapConditions("getMapNativeOrders", mapNativeOrders);
        ModelMethod staticMapJpaOrders = ClassBuilding.getMapConditions("getMapJpaOrders", mapJpaOrders);
        classQueryJpql.getMethods().add(staticMapConditions);
        classQueryJpql.getMethods().add(staticMapBaseConditions);
        classQueryJpql.getMethods().add(modelMethod);
        classQueryJpql.getMethods().add(staticMapNativeConditions);
        classQueryJpql.getMethods().add(staticMapNativeOrders);
        classQueryJpql.getMethods().add(staticMapJpaOrders);
        ModelMethod mapConditionsMethod = MAP_CONDITIONS_METHOD;
        ModelMethod mapDeleteConditionsMethod = MAP_DELETE_CONDITIONS_METHOD;
        ModelMethod mapNativeConditionsMethod = MAP_NATIVE_CONDITIONS_METHOD;
        ModelMethod mapNativeOrdersMethod = MAP_NATIVE_ORDERS_METHOD;
        ModelMethod mapJpaOrdersMethod = MAP_JPA_ORDERS_METHOD;
        classQueryJpql.getMethods().add(mapConditionsMethod);
        classQueryJpql.getMethods().add(mapDeleteConditionsMethod);
        classQueryJpql.getMethods().add(mapNativeConditionsMethod);
        classQueryJpql.getMethods().add(mapNativeOrdersMethod);
        classQueryJpql.getMethods().add(mapJpaOrdersMethod);
        ModelMethod mapOneToManyMethod = new ModelMethod("mapOneToMany", "void");
        mapOneToManyMethod.setLevelType(LevelType.PUBLIC);
        mapOneToManyMethod.getAnnotations().add(ANNOTATION_OVERRIDE);
        mapOneToManyMethod.setCommands(mapOneToMany);
        classQueryJpql.getMethods().add(mapOneToManyMethod);
        modelClasses.getClasses().add(interfaceQueryJpql);
        modelClasses.getClasses().add(classQueryJpql);
    }

    private static String manyToOneJoinColumn(String fieldEntity, List<String> mapConditions, Set<String> mapDeleteConditions, Set<String> mapJpaOrders, Map<String, QueryDetail> mapAlias, Set<String> aliases, String fromByFilter, Set<String> manyProps, Set<String> keyConditions, Element element, ClassField classField, String fieldName, JoinColumn joinColumn) {
        boolean nullable = element.getAnnotation(NotNull.class) == null && joinColumn.nullable();
        fromByFilter = ClassBuilding.fromManyAndOneToOne(fieldEntity, mapAlias, aliases, fromByFilter, classField, fieldName, nullable);
        Set<Element> listFieldReference = classField.getElements();
        for (Element fieldReference : listFieldReference) {
            if (fieldReference.getAnnotation(Id.class) == null && fieldReference.getAnnotation(EmbeddedId.class) == null) continue;
            mapConditions.add("        map.put(" + fieldReference.getSimpleName().toString() + ", \" and " + fieldName + "." + fieldReference.getSimpleName().toString() + " in (:" + fieldReference.getSimpleName().toString() + ") \");");
            mapDeleteConditions.add("        map.put(" + fieldReference.getSimpleName().toString() + ", \" and " + fieldEntity + "." + fieldName + "." + fieldReference.getSimpleName().toString() + " in (:" + fieldReference.getSimpleName().toString() + ") \");");
            mapJpaOrders.add("        map.put(\"" + fieldName + "." + fieldReference.getSimpleName().toString() + "\",\"" + fieldName + "." + fieldReference.getSimpleName().toString() + "\");");
            manyProps.add(fieldReference.getSimpleName().toString());
            keyConditions.add(fieldReference.getSimpleName().toString());
            break;
        }
        return fromByFilter;
    }

    private static void nativeCondition(CustomConditionBuilder customCondition, ModelClass classQueryJpql) throws JsonProcessingException {
        for (String key : customCondition.keys()) {
            List<Object> mapNativeConditions = null;
            if (!mapListConditions.containsKey(key)) {
                mapNativeConditions = new ArrayList<String>();
                mapNativeConditions.add("        Map<String,String> map=new HashMap<>();");
                mapNativeConditions.add("        return map;");
                mapListConditions.put(key, mapNativeConditions);
            }
            mapNativeConditions = mapListConditions.get(key);
            mapNativeConditions.add(1, "        map.put(" + customCondition.parameter() + ", \" " + customCondition.condition().trim() + " \");");
        }
    }

    private static String fromManyAndOneToOne(String fieldEntity, Map<String, QueryDetail> mapAlias, Set<String> aliases, String fromByFilter, ClassField classField, String fieldName, boolean nullable) {
        String alias = ClassBuilding.getAlias(aliases, fieldName);
        fromByFilter = (String)fromByFilter + "\n        +\"" + (nullable ? " left" : "") + " join fetch " + fieldEntity + "." + fieldName + " " + alias + " \"";
        QueryDetail queryDetail = new QueryDetail(alias, fieldName, nullable, classField);
        mapAlias.put(fieldEntity + "." + fieldName, queryDetail);
        return fromByFilter;
    }

    private static AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String element) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entryAnnotation : annotationMirror.getElementValues().entrySet()) {
            if (!entryAnnotation.getKey().getSimpleName().toString().equals(element)) continue;
            return entryAnnotation.getValue();
        }
        return null;
    }

    private static void writeCustomCondition(List<String> conditions, Set<String> deleteConditions, CustomConditionBuilder customCondition, Set<String> keyConditions) {
        String condition = "        map.put(" + customCondition.parameter() + ", \" " + customCondition.condition().trim() + " \");";
        keyConditions.add(customCondition.parameter());
        if (ConditionType.SELECT.equals((Object)customCondition.type())) {
            conditions.add(condition);
        } else {
            deleteConditions.add(condition);
        }
    }

    private static String buildJoin(TypeElement type, ProcessingEnvironment processingEnv, List<String> mapConditions, LinkedHashSet<String> mapOneToMany, Map<String, QueryDetail> mapAlias, Set<String> aliases, String fromByFilter, Set<String> manyProps, String joinPath, String parameter, TypeElement typeService, AnnotationMirror annotationMirror, String elementAnnotation, LinkedHashSet<String> manies, Set<String> keyConditions) {
        ArrayList<String> joins = new ArrayList<String>(Arrays.asList(joinPath.split("\\.")));
        QueryDetail queryDetail = null;
        String alias = null;
        Object key = (String)joins.get(0);
        String classJoin = null;
        if (type.getAnnotation(OneToMany.class) != null || type.getAnnotation(ManyToMany.class) != null) {
            DeclaredType dclt = (DeclaredType)type.asType();
            classJoin = dclt.getTypeArguments().get(0).toString();
        } else {
            classJoin = type.getQualifiedName().toString();
        }
        if (CollectionUtils.isNotEmpty(joins)) {
            joins.remove(0);
        }
        for (String join : joins) {
            Set<Element> listFieldReference;
            ClassField classField;
            ClassField classFieldRefernce;
            DeclaredType dclt;
            ClassField classFieldJoin = mapClassField.get(classJoin);
            Element elementJoin = classFieldJoin.getMapElement().get(join);
            if (elementJoin == null) {
                String errorMessage = "Not exist element with name \"" + (String)key + "." + join + "\"";
                AnnotationValue annotationValue = ClassBuilding.getAnnotationValue(annotationMirror, elementAnnotation);
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, errorMessage, typeService, annotationMirror, annotationValue);
                throw new ProcessorJpaServiceException(errorMessage);
            }
            classJoin = elementJoin.asType().toString();
            boolean nullable = queryDetail != null ? queryDetail.isNullable() : false;
            boolean many = queryDetail != null ? queryDetail.isMany() : false;
            if (mapAlias.containsKey(key = (String)key + "." + join)) {
                QueryDetail appQueryDetail = mapAlias.get(key);
                if (appQueryDetail != null && appQueryDetail.isMany()) {
                    Object className = queryDetail != null ? queryDetail.getAlias() : key;
                    manies.add("\" left join fetch " + (String)className + " " + appQueryDetail.getAlias() + " \"");
                }
                queryDetail = appQueryDetail;
                continue;
            }
            alias = ClassBuilding.getAlias(aliases, join);
            if (elementJoin.getAnnotation(OneToMany.class) != null) {
                dclt = (DeclaredType)elementJoin.asType();
                classJoin = dclt.getTypeArguments().get(0).toString();
                classFieldRefernce = mapClassField.get(classJoin);
                Map<String, Element> mapField = classFieldRefernce.getMapElement();
                Object var29_32 = null;
                Set<Element> listReferenceField = classFieldRefernce.getElements();
                OneToMany oneToMany = elementJoin.getAnnotation(OneToMany.class);
                Element element = mapField.get(oneToMany.mappedBy());
                for (Element fieldOneToMany : listReferenceField) {
                    if (fieldOneToMany.getAnnotation(Id.class) == null || element.getAnnotation(JoinColumn.class) == null) continue;
                    JoinColumn joinColumn = element.getAnnotation(JoinColumn.class);
                    Object keyProps = fieldOneToMany.getSimpleName().toString();
                    if (manyProps.contains(keyProps)) {
                        keyProps = alias + Character.toUpperCase(fieldOneToMany.getSimpleName().toString().charAt(0)) + fieldOneToMany.getSimpleName().toString().substring(1);
                    }
                    manies.add(" left join fetch " + queryDetail.getAlias() + "." + join + " " + alias + " \"");
                    mapOneToMany.add("        addJoinOneToMany(" + (String)keyProps + ", " + ClassBuilding.printManies(manies) + ");");
                    mapConditions.add("        map.put(" + (String)keyProps + ", \" and " + alias + "." + fieldOneToMany.getSimpleName().toString() + " in (:" + (String)keyProps + ") \");");
                    keyConditions.add((String)keyProps);
                    queryDetail = new QueryDetail(alias, (String)key, joinColumn.nullable() || nullable, true, classFieldRefernce);
                    mapAlias.put((String)key, queryDetail);
                }
                continue;
            }
            if (elementJoin.getAnnotation(ManyToMany.class) != null) {
                dclt = (DeclaredType)elementJoin.asType();
                classJoin = dclt.getTypeArguments().get(0).toString();
                classFieldRefernce = mapClassField.get(classJoin);
                Set<Element> listReferenceField = classFieldRefernce.getElements();
                for (Element fieldManyToMany : listReferenceField) {
                    if (fieldManyToMany.getAnnotation(Id.class) == null) continue;
                    Object keyProps = fieldManyToMany.getSimpleName().toString();
                    if (manyProps.contains(keyProps)) {
                        keyProps = alias + Character.toUpperCase(fieldManyToMany.getSimpleName().toString().charAt(0)) + fieldManyToMany.getSimpleName().toString().substring(1);
                    }
                    manyProps.add((String)keyProps);
                    manies.add(" left join fetch " + queryDetail.getAlias() + "." + join + " " + alias + " \"");
                    mapOneToMany.add("        addJoinOneToMany(" + (String)keyProps + ", " + ClassBuilding.printManies(manies) + ");");
                    mapConditions.add("        map.put(" + (String)keyProps + ", \" and " + alias + "." + fieldManyToMany.getSimpleName().toString() + " in (:" + (String)keyProps + ") \");");
                    keyConditions.add((String)keyProps);
                    queryDetail = new QueryDetail(alias, (String)key, nullable, true, classFieldRefernce);
                    mapAlias.put((String)key, queryDetail);
                }
                continue;
            }
            if (elementJoin.getAnnotation(ManyToOne.class) != null) {
                boolean bl = nullable = nullable || elementJoin.getAnnotation(JoinColumn.class).nullable();
                if (!many) {
                    fromByFilter = (String)fromByFilter + "\n        +\"" + (nullable ? " left" : "") + " join fetch " + queryDetail.getAlias() + "." + join + " " + alias + " \"";
                } else {
                    classField = mapClassField.get(elementJoin.asType().toString());
                    listFieldReference = classField.getElements();
                    for (Element element : listFieldReference) {
                        if (element.getAnnotation(Id.class) == null && element.getAnnotation(EmbeddedId.class) == null) continue;
                        mapConditions.add("        map.put(" + element.getSimpleName().toString() + ", \" and " + alias + "." + element.getSimpleName().toString() + " in (:" + element.getSimpleName().toString() + ") \");");
                        manies.add("\" left join fetch " + queryDetail.getAlias() + "." + join + " " + alias + " \"");
                        mapOneToMany.add("        addJoinOneToMany(" + element.getSimpleName().toString() + ", " + ClassBuilding.printManies(manies) + ");");
                        manyProps.add(element.getSimpleName().toString());
                        keyConditions.add(element.getSimpleName().toString());
                        break;
                    }
                }
                queryDetail = new QueryDetail(alias, (String)key, nullable, many, mapClassField.get(elementJoin.asType().toString()));
                mapAlias.put((String)key, queryDetail);
                continue;
            }
            if (elementJoin.getAnnotation(OneToOne.class) == null) continue;
            boolean bl = nullable = nullable || ClassBuilding.nullableOneToOne(elementJoin);
            if (!many) {
                fromByFilter = (String)fromByFilter + "\n        +\"" + (nullable ? " left" : "") + " join fetch " + queryDetail.getAlias() + "." + join + " " + alias + " \"";
            } else {
                classField = mapClassField.get(elementJoin.asType().toString());
                listFieldReference = classField.getElements();
                for (Element element : listFieldReference) {
                    if (element.getAnnotation(Id.class) == null && element.getAnnotation(EmbeddedId.class) == null) continue;
                    mapConditions.add("        map.put(" + element.getSimpleName().toString() + ", \" and " + alias + "." + element.getSimpleName().toString() + " in (:" + element.getSimpleName().toString() + ") \");");
                    manies.add("\"" + (nullable ? " left" : "") + " join fetch " + queryDetail.getAlias() + "." + join + " " + alias + " \"");
                    mapOneToMany.add("        addJoinOneToMany(" + element.getSimpleName().toString() + ", " + ClassBuilding.printManies(manies) + ");");
                    manyProps.add(element.getSimpleName().toString());
                    keyConditions.add(element.getSimpleName().toString());
                    break;
                }
            }
            queryDetail = new QueryDetail(alias, (String)key, nullable, many, mapClassField.get(elementJoin.asType().toString()));
            mapAlias.put((String)key, queryDetail);
        }
        if (CollectionUtils.isNotEmpty(manies) && StringUtils.isNotEmpty(parameter)) {
            mapOneToMany.add("        addJoinOneToMany(" + parameter + ", " + ClassBuilding.printManies(manies) + ");");
            keyConditions.add(parameter);
        }
        return fromByFilter;
    }

    private static String getAlias(Set<String> aliases, String join) {
        Object alias = join;
        int i = 0;
        do {
            if (!aliases.contains(alias)) continue;
            alias = join + "_" + ++i;
        } while (aliases.contains(alias));
        aliases.add((String)alias);
        return alias;
    }

    private static boolean nullableOneToOne(Element element) {
        boolean nullable = true;
        if (element.getAnnotation(JoinColumn.class) != null) {
            JoinColumn joinColumn = element.getAnnotation(JoinColumn.class);
            nullable = joinColumn.nullable();
        } else if (element.getAnnotation(NotNull.class) != null) {
            nullable = false;
        }
        return nullable;
    }

    private static String printManies(LinkedHashSet<String> manies) {
        Object joinMany = "";
        for (String many : manies) {
            joinMany = (String)joinMany + "," + many;
        }
        return ((String)joinMany).substring(1);
    }

    private static ModelSuperClass getInterfaceQueryJpql(String classEntity) {
        ModelSuperClass superClassQueryJpql = new ModelSuperClass();
        superClassQueryJpql.setName(classEntity + QUERY_JPQL);
        return superClassQueryJpql;
    }

    private static ModelSuperClass getSuperClassQueryJpql(String classEntity) {
        ModelGenericType genericTypeEntityClass = new ModelGenericType();
        genericTypeEntityClass.setName(classEntity);
        ModelSuperClass superClassQueryJpql = new ModelSuperClass();
        superClassQueryJpql.setName(QUERY_JPQL);
        superClassQueryJpql.addGenericTypes(genericTypeEntityClass);
        return superClassQueryJpql;
    }

    public static void generateJpaClass(ModelClasses modelClasses, TypeElement type) throws Exception {
        TypeElement typeElement = type;
        ClassField classField = new ClassField(type.getQualifiedName().toString());
        mapClassField.put(classField.getClassName(), classField);
        do {
            for (Element element : typeElement.getEnclosedElements()) {
                if (!ElementKind.FIELD.equals((Object)element.getKind()) || element.getModifiers().contains((Object)Modifier.FINAL) || element.getModifiers().contains((Object)Modifier.STATIC) || classField.getElements().contains(element) || element.getAnnotation(Transient.class) != null) continue;
                classField.getElements().add(element);
                classField.getMapElement().put(element.getSimpleName().toString(), element);
                if (element.getAnnotation(EmbeddedId.class) == null && element.getAnnotation(Id.class) == null) continue;
                Class<?> classTypeField = null;
                if (element.getAnnotation(EmbeddedId.class) != null || !ReflectionCommons.mapPrimitiveToObject.containsKey(classTypeField = Class.forName(element.asType().toString()))) continue;
                classTypeField = ReflectionCommons.mapPrimitiveToObject.get(classTypeField);
            }
            TypeMirror superClassTypeMirror = typeElement.getSuperclass();
            typeElement = (TypeElement)((DeclaredType)superClassTypeMirror).asElement();
        } while (!Object.class.getName().equals(typeElement.getQualifiedName().toString()));
    }

    private static ModelMethod getConditions(String name, String command) {
        ModelMethod mapConditionsMethod = new ModelMethod();
        mapConditionsMethod.setName(name);
        mapConditionsMethod.setType("Map");
        mapConditionsMethod.getGenericTypes().add(new ModelGenericType(STRING));
        mapConditionsMethod.getGenericTypes().add(new ModelGenericType(STRING));
        mapConditionsMethod.setLevelType(LevelType.PUBLIC);
        mapConditionsMethod.getAnnotations().add(ANNOTATION_OVERRIDE);
        mapConditionsMethod.getCommands().add(SPACE + command);
        return mapConditionsMethod;
    }

    private static ModelMethod getNativeConditions(String name, String command) {
        ModelMethod mapConditionsMethod = new ModelMethod();
        mapConditionsMethod.setName(name);
        mapConditionsMethod.setType("Map");
        mapConditionsMethod.getGenericTypes().add(new ModelGenericType(STRING));
        mapConditionsMethod.getGenericTypes().add(new ModelGenericType("Map<String,String>"));
        mapConditionsMethod.setLevelType(LevelType.PUBLIC);
        mapConditionsMethod.getAnnotations().add(ANNOTATION_OVERRIDE);
        mapConditionsMethod.getCommands().add(SPACE + command);
        return mapConditionsMethod;
    }

    private static ModelAnnotation getModelAnnotation(String annotationName) {
        ModelAnnotation modelAnnotation = new ModelAnnotation();
        modelAnnotation.setName(annotationName);
        return modelAnnotation;
    }

    private static ModelMethod returnMethodService(String name, String type, String command, LevelType levelType) {
        ModelMethod modelMethod = new ModelMethod(name, type);
        modelMethod.getAnnotations().add(ANNOTATION_OVERRIDE);
        modelMethod.setLevelType(levelType);
        modelMethod.getCommands().add(command);
        return modelMethod;
    }

    private static ModelField finalStaticField(String name, String type, Object value, boolean showQuotes) {
        ModelField modelField = new ModelField();
        modelField.setType(type);
        modelField.setFieldStatic(true);
        modelField.setFieldFinal(true);
        modelField.setName(name);
        modelField.setValue(value);
        modelField.setGetterSetter(false);
        modelField.setShowQuotes(showQuotes);
        return modelField;
    }

    private static ModelField finalStaticField(String name, String type, Object value, boolean showQuotes, LevelType levelType) {
        ModelField modelField = ClassBuilding.finalStaticField(name, type, value, showQuotes);
        modelField.setLevelType(levelType);
        return modelField;
    }

    private static ModelField getFieldMapConditions(String name, String value) {
        ModelField mapConditions = ClassBuilding.finalStaticField(name, "Map", value, false);
        mapConditions.getGenericTypes().add(new ModelGenericType(STRING));
        mapConditions.getGenericTypes().add(new ModelGenericType(STRING));
        return mapConditions;
    }

    private static ModelField getFieldMapNativeConditions(String name, String value) {
        ModelField mapConditions = ClassBuilding.finalStaticField(name, "Map", value, false);
        mapConditions.getGenericTypes().add(new ModelGenericType(STRING));
        mapConditions.getGenericTypes().add(new ModelGenericType("Map<String,String>"));
        return mapConditions;
    }

    private static ModelMethod getMapConditions(String name, Collection<String> commands) {
        ModelMethod mapConditions = new ModelMethod(name, "Map");
        mapConditions.getGenericTypes().add(new ModelGenericType(STRING));
        mapConditions.getGenericTypes().add(new ModelGenericType(STRING));
        mapConditions.setStaticMethod(true);
        mapConditions.setLevelType(LevelType.PRIVATE);
        mapConditions.setCommands(commands);
        return mapConditions;
    }

    private static ModelMethod getMapNativeConditions(String name, Collection<String> commands) {
        ModelMethod mapConditions = new ModelMethod(name, "Map");
        mapConditions.getGenericTypes().add(new ModelGenericType(STRING));
        mapConditions.getGenericTypes().add(new ModelGenericType("Map<String,String>"));
        mapConditions.setStaticMethod(true);
        mapConditions.setLevelType(LevelType.PRIVATE);
        mapConditions.setCommands(commands);
        return mapConditions;
    }
}

