/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AssociationOverrides;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Basic;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.Convert;
import jakarta.persistence.Converts;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.EntityResult;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.ExcludeDefaultListeners;
import jakarta.persistence.ExcludeSuperclassListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.FieldResult;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Index;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.JoinTable;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKey;
import jakarta.persistence.MapKeyClass;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.MapKeyJoinColumn;
import jakarta.persistence.MapKeyJoinColumns;
import jakarta.persistence.MapKeyTemporal;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.MapsId;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedEntityGraphs;
import jakarta.persistence.NamedNativeQueries;
import jakarta.persistence.NamedNativeQuery;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.NamedStoredProcedureQueries;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.NamedSubgraph;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostRemove;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import jakarta.persistence.QueryHint;
import jakarta.persistence.SecondaryTable;
import jakarta.persistence.SecondaryTables;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.SqlResultSetMappings;
import jakarta.persistence.StoredProcedureParameter;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import jakarta.persistence.Version;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Subselect;
import org.hibernate.annotations.TenantId;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UuidGenerator;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.Filter;
import org.hibernate.annotations.common.reflection.ReflectionUtil;
import org.hibernate.boot.jaxb.mapping.AssociationAttribute;
import org.hibernate.boot.jaxb.mapping.AttributesContainer;
import org.hibernate.boot.jaxb.mapping.EntityOrMappedSuperclass;
import org.hibernate.boot.jaxb.mapping.JaxbAssociationOverride;
import org.hibernate.boot.jaxb.mapping.JaxbAttributeOverride;
import org.hibernate.boot.jaxb.mapping.JaxbAttributes;
import org.hibernate.boot.jaxb.mapping.JaxbBasic;
import org.hibernate.boot.jaxb.mapping.JaxbCaching;
import org.hibernate.boot.jaxb.mapping.JaxbCascadeType;
import org.hibernate.boot.jaxb.mapping.JaxbCollectionTable;
import org.hibernate.boot.jaxb.mapping.JaxbColumn;
import org.hibernate.boot.jaxb.mapping.JaxbColumnResult;
import org.hibernate.boot.jaxb.mapping.JaxbColumnType;
import org.hibernate.boot.jaxb.mapping.JaxbConfigurationParameter;
import org.hibernate.boot.jaxb.mapping.JaxbConstructorResult;
import org.hibernate.boot.jaxb.mapping.JaxbConvert;
import org.hibernate.boot.jaxb.mapping.JaxbDiscriminatorColumn;
import org.hibernate.boot.jaxb.mapping.JaxbElementCollection;
import org.hibernate.boot.jaxb.mapping.JaxbEmbeddable;
import org.hibernate.boot.jaxb.mapping.JaxbEmbedded;
import org.hibernate.boot.jaxb.mapping.JaxbEmbeddedId;
import org.hibernate.boot.jaxb.mapping.JaxbEmptyType;
import org.hibernate.boot.jaxb.mapping.JaxbEntity;
import org.hibernate.boot.jaxb.mapping.JaxbEntityListener;
import org.hibernate.boot.jaxb.mapping.JaxbEntityListeners;
import org.hibernate.boot.jaxb.mapping.JaxbEntityResult;
import org.hibernate.boot.jaxb.mapping.JaxbFieldResult;
import org.hibernate.boot.jaxb.mapping.JaxbGeneratedValue;
import org.hibernate.boot.jaxb.mapping.JaxbId;
import org.hibernate.boot.jaxb.mapping.JaxbIdClass;
import org.hibernate.boot.jaxb.mapping.JaxbIndex;
import org.hibernate.boot.jaxb.mapping.JaxbInheritance;
import org.hibernate.boot.jaxb.mapping.JaxbJoinColumn;
import org.hibernate.boot.jaxb.mapping.JaxbJoinTable;
import org.hibernate.boot.jaxb.mapping.JaxbLob;
import org.hibernate.boot.jaxb.mapping.JaxbManyToMany;
import org.hibernate.boot.jaxb.mapping.JaxbManyToOne;
import org.hibernate.boot.jaxb.mapping.JaxbMapKey;
import org.hibernate.boot.jaxb.mapping.JaxbMapKeyClass;
import org.hibernate.boot.jaxb.mapping.JaxbMapKeyColumn;
import org.hibernate.boot.jaxb.mapping.JaxbMapKeyJoinColumn;
import org.hibernate.boot.jaxb.mapping.JaxbMappedSuperclass;
import org.hibernate.boot.jaxb.mapping.JaxbNamedAttributeNode;
import org.hibernate.boot.jaxb.mapping.JaxbNamedEntityGraph;
import org.hibernate.boot.jaxb.mapping.JaxbNamedNativeQuery;
import org.hibernate.boot.jaxb.mapping.JaxbNamedQuery;
import org.hibernate.boot.jaxb.mapping.JaxbNamedStoredProcedureQuery;
import org.hibernate.boot.jaxb.mapping.JaxbNamedSubgraph;
import org.hibernate.boot.jaxb.mapping.JaxbOneToMany;
import org.hibernate.boot.jaxb.mapping.JaxbOneToOne;
import org.hibernate.boot.jaxb.mapping.JaxbOrderColumn;
import org.hibernate.boot.jaxb.mapping.JaxbPrimaryKeyJoinColumn;
import org.hibernate.boot.jaxb.mapping.JaxbQueryHint;
import org.hibernate.boot.jaxb.mapping.JaxbSecondaryTable;
import org.hibernate.boot.jaxb.mapping.JaxbSequenceGenerator;
import org.hibernate.boot.jaxb.mapping.JaxbSqlResultSetMapping;
import org.hibernate.boot.jaxb.mapping.JaxbStoredProcedureParameter;
import org.hibernate.boot.jaxb.mapping.JaxbSynchronizedTable;
import org.hibernate.boot.jaxb.mapping.JaxbTable;
import org.hibernate.boot.jaxb.mapping.JaxbTableGenerator;
import org.hibernate.boot.jaxb.mapping.JaxbTenantId;
import org.hibernate.boot.jaxb.mapping.JaxbUniqueConstraint;
import org.hibernate.boot.jaxb.mapping.JaxbUuidGenerator;
import org.hibernate.boot.jaxb.mapping.JaxbVersion;
import org.hibernate.boot.jaxb.mapping.LifecycleCallbackContainer;
import org.hibernate.boot.jaxb.mapping.ManagedType;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.boot.model.internal.PersistentAttributeFilter;
import org.hibernate.boot.model.internal.PropertyMappingElementCollector;
import org.hibernate.boot.model.internal.XMLContext;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.ClassLoaderAccess;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;

public class JPAXMLOverriddenAnnotationReader
implements AnnotationReader {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(JPAXMLOverriddenAnnotationReader.class);
    private static final String SCHEMA_VALIDATION = "Activate schema validation for more information";
    private static final String WORD_SEPARATOR = "-";
    private static final Map<Class<? extends Annotation>, String> annotationToXml = new HashMap<Class<? extends Annotation>, String>();
    private final XMLContext xmlContext;
    private final ClassLoaderAccess classLoaderAccess;
    private final AnnotatedElement element;
    private final String className;
    private final String propertyName;
    private final PropertyType propertyType;
    private transient Annotation[] annotations;
    private transient Map<Class, Annotation> annotationsMap;
    private transient PropertyMappingElementCollector elementsForProperty;
    private AccessibleObject mirroredAttribute;

    JPAXMLOverriddenAnnotationReader(AnnotatedElement el, XMLContext xmlContext, ClassLoaderAccess classLoaderAccess) {
        this.element = el;
        this.xmlContext = xmlContext;
        this.classLoaderAccess = classLoaderAccess;
        if (el instanceof Class) {
            Class clazz = (Class)el;
            this.className = clazz.getName();
            this.propertyName = null;
            this.propertyType = null;
        } else if (el instanceof Field) {
            Field field = (Field)el;
            this.className = field.getDeclaringClass().getName();
            this.propertyName = field.getName();
            this.propertyType = PropertyType.FIELD;
            String expectedGetter = "get" + Character.toUpperCase(this.propertyName.charAt(0)) + this.propertyName.substring(1);
            try {
                this.mirroredAttribute = field.getDeclaringClass().getDeclaredMethod(expectedGetter, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else if (el instanceof Method) {
            Method method = (Method)el;
            this.className = method.getDeclaringClass().getName();
            String methodName = method.getName();
            if (ReflectionUtil.isProperty((Method)method, null, (Filter)PersistentAttributeFilter.INSTANCE)) {
                if (methodName.startsWith("get")) {
                    this.propertyName = Introspector.decapitalize(methodName.substring("get".length()));
                } else if (methodName.startsWith("is")) {
                    this.propertyName = Introspector.decapitalize(methodName.substring("is".length()));
                } else {
                    throw new RuntimeException("Method " + methodName + " is not a property getter");
                }
                this.propertyType = PropertyType.PROPERTY;
                try {
                    this.mirroredAttribute = method.getDeclaringClass().getDeclaredField(this.propertyName);
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            } else {
                this.propertyName = methodName;
                this.propertyType = PropertyType.METHOD;
            }
        } else {
            this.className = null;
            this.propertyName = null;
            this.propertyType = null;
        }
    }

    public JPAXMLOverriddenAnnotationReader(AnnotatedElement el, XMLContext xmlContext, BootstrapContext bootstrapContext) {
        this(el, xmlContext, bootstrapContext.getClassLoaderAccess());
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        this.initAnnotations();
        return (T)this.annotationsMap.get(annotationType);
    }

    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationType) {
        this.initAnnotations();
        return this.annotationsMap.containsKey(annotationType);
    }

    public Annotation[] getAnnotations() {
        this.initAnnotations();
        return this.annotations;
    }

    private void initAnnotations() {
        block12: {
            if (this.annotations != null) break block12;
            XMLContext.Default defaults = this.xmlContext.getDefaultWithoutGlobalCatalogAndSchema(this.className);
            if (this.className != null && this.propertyName == null) {
                ManagedType managedTypeOverride = this.xmlContext.getManagedTypeOverride(this.className);
                Annotation[] annotations = this.getPhysicalAnnotations();
                ArrayList<Annotation> annotationList = new ArrayList<Annotation>(annotations.length + 5);
                this.annotationsMap = new HashMap<Class, Annotation>(annotations.length + 5);
                for (Annotation annotation : annotations) {
                    if (annotationToXml.containsKey(annotation.annotationType())) continue;
                    annotationList.add(annotation);
                }
                this.addIfNotNull(annotationList, this.getEntity(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getMappedSuperclass(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getEmbeddable(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getTable(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getSecondaryTables(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getPrimaryKeyJoinColumns(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getIdClass(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getCacheable(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getCaching(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getInheritance(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getDiscriminatorValue(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getDiscriminatorColumn(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getSequenceGenerator(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getTableGenerator(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getNamedQueries(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getNamedNativeQueries(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getNamedStoredProcedureQueries(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getNamedEntityGraphs(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getSqlResultSetMappings(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getExcludeDefaultListeners(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getExcludeSuperclassListeners(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getAccessType(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getAttributeOverrides(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getAssociationOverrides(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getEntityListeners(managedTypeOverride, defaults));
                this.addIfNotNull(annotationList, this.getConverts(managedTypeOverride, defaults));
                this.annotations = annotationList.toArray(new Annotation[0]);
                for (Annotation ann : this.annotations) {
                    this.annotationsMap.put(ann.annotationType(), ann);
                }
                this.checkForOrphanProperties(managedTypeOverride);
            } else if (this.className != null) {
                ManagedType managedTypeOverride = this.xmlContext.getManagedTypeOverride(this.className);
                JaxbEntityListener entityListenerOverride = this.xmlContext.getEntityListenerOverride(this.className);
                Annotation[] annotations = this.getPhysicalAnnotations();
                ArrayList<Annotation> annotationList = new ArrayList<Annotation>(annotations.length + 5);
                this.annotationsMap = new HashMap<Class, Annotation>(annotations.length + 5);
                for (Annotation annotation : annotations) {
                    if (annotationToXml.containsKey(annotation.annotationType())) continue;
                    annotationList.add(annotation);
                }
                this.preCalculateElementsForProperty(managedTypeOverride, entityListenerOverride);
                Transient transientAnn = this.getTransient(defaults);
                if (transientAnn != null) {
                    annotationList.add(transientAnn);
                } else {
                    if (defaults.canUseJavaAnnotations()) {
                        Access annotation = this.getPhysicalAnnotation(Access.class);
                        this.addIfNotNull(annotationList, annotation);
                    }
                    this.getId(annotationList, defaults);
                    this.getEmbeddedId(annotationList, defaults);
                    this.getEmbedded(annotationList, defaults);
                    this.getBasic(annotationList, defaults);
                    this.getVersion(annotationList, defaults);
                    this.getManyToOne(annotationList, defaults);
                    this.getOneToOne(annotationList, defaults);
                    this.getOneToMany(annotationList, defaults);
                    this.getManyToMany(annotationList, defaults);
                    this.getAny(annotationList, defaults);
                    this.getManyToAny(annotationList, defaults);
                    this.getElementCollection(annotationList, defaults);
                    this.addIfNotNull(annotationList, this.getSequenceGenerator(this.elementsForProperty, defaults));
                    this.addIfNotNull(annotationList, this.getTableGenerator(this.elementsForProperty, defaults));
                    this.addIfNotNull(annotationList, this.getConvertsForAttribute(this.elementsForProperty, defaults));
                }
                this.processEventAnnotations(annotationList, defaults);
                for (Annotation ann : this.annotations = annotationList.toArray(new Annotation[0])) {
                    this.annotationsMap.put(ann.annotationType(), ann);
                }
            } else {
                this.annotations = this.getPhysicalAnnotations();
                this.annotationsMap = new HashMap<Class, Annotation>(this.annotations.length + 5);
                for (Annotation ann : this.annotations) {
                    this.annotationsMap.put(ann.annotationType(), ann);
                }
            }
        }
    }

    private Annotation getConvertsForAttribute(PropertyMappingElementCollector elementsForProperty, XMLContext.Default defaults) {
        HashMap<String, Convert> convertAnnotationsMap = new HashMap<String, Convert>();
        for (JaxbBasic jaxbBasic : elementsForProperty.getBasic()) {
            JaxbConvert convert = jaxbBasic.getConvert();
            if (convert == null) continue;
            this.applyXmlDefinedConverts(Collections.singletonList(convert), defaults, null, convertAnnotationsMap);
        }
        for (JaxbEmbedded jaxbEmbedded : elementsForProperty.getEmbedded()) {
            this.applyXmlDefinedConverts(jaxbEmbedded.getConvert(), defaults, this.propertyName, convertAnnotationsMap);
        }
        for (JaxbElementCollection jaxbElementCollection : elementsForProperty.getElementCollection()) {
            this.applyXmlDefinedConverts(jaxbElementCollection.getConvert(), defaults, this.propertyName, convertAnnotationsMap);
        }
        if (defaults.canUseJavaAnnotations()) {
            this.applyPhysicalConvertAnnotations(this.propertyName, convertAnnotationsMap);
        }
        if (!convertAnnotationsMap.isEmpty()) {
            AnnotationDescriptor groupingDescriptor = new AnnotationDescriptor(Converts.class);
            groupingDescriptor.setValue("value", (Object)convertAnnotationsMap.values().toArray(new Convert[0]));
            return AnnotationFactory.create((AnnotationDescriptor)groupingDescriptor);
        }
        return null;
    }

    private Converts getConverts(ManagedType root, XMLContext.Default defaults) {
        HashMap<String, Convert> convertAnnotationsMap = new HashMap<String, Convert>();
        if (root instanceof JaxbEntity) {
            this.applyXmlDefinedConverts(((JaxbEntity)root).getConvert(), defaults, null, convertAnnotationsMap);
        }
        if (defaults.canUseJavaAnnotations()) {
            this.applyPhysicalConvertAnnotations(null, convertAnnotationsMap);
        }
        if (!convertAnnotationsMap.isEmpty()) {
            AnnotationDescriptor groupingDescriptor = new AnnotationDescriptor(Converts.class);
            groupingDescriptor.setValue("value", (Object)convertAnnotationsMap.values().toArray(new Convert[0]));
            return (Converts)AnnotationFactory.create((AnnotationDescriptor)groupingDescriptor);
        }
        return null;
    }

    private void applyXmlDefinedConverts(List<JaxbConvert> elements, XMLContext.Default defaults, String attributeNamePrefix, Map<String, Convert> convertAnnotationsMap) {
        for (JaxbConvert convertElement : elements) {
            AnnotationDescriptor convertAnnotationDescriptor = new AnnotationDescriptor(Convert.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(convertAnnotationDescriptor, "attribute-name", convertElement.getAttributeName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(convertAnnotationDescriptor, "disable-conversion", convertElement.isDisableConversion(), false);
            String converter = convertElement.getConverter();
            if (converter != null) {
                String converterClassName = XMLContext.buildSafeClassName(converter, defaults);
                try {
                    Class converterClass = this.classLoaderAccess.classForName(converterClassName);
                    convertAnnotationDescriptor.setValue("converter", converterClass);
                }
                catch (ClassLoadingException e) {
                    throw new AnnotationException("Unable to find specified converter class id-class: " + converterClassName, e);
                }
            }
            Convert convertAnnotation = (Convert)AnnotationFactory.create((AnnotationDescriptor)convertAnnotationDescriptor);
            String qualifiedAttributeName = this.qualifyConverterAttributeName(attributeNamePrefix, convertAnnotation.attributeName());
            convertAnnotationsMap.put(qualifiedAttributeName, convertAnnotation);
        }
    }

    private String qualifyConverterAttributeName(String attributeNamePrefix, String specifiedAttributeName) {
        Object qualifiedAttributeName = StringHelper.isNotEmpty(specifiedAttributeName) ? (StringHelper.isNotEmpty(attributeNamePrefix) ? attributeNamePrefix + "." + specifiedAttributeName : specifiedAttributeName) : "";
        return qualifiedAttributeName;
    }

    private void applyPhysicalConvertAnnotations(String attributeNamePrefix, Map<String, Convert> convertAnnotationsMap) {
        Converts physicalGroupingAnnotation;
        String qualifiedAttributeName;
        Convert physicalAnnotation = this.getPhysicalAnnotation(Convert.class);
        if (physicalAnnotation != null && !convertAnnotationsMap.containsKey(qualifiedAttributeName = this.qualifyConverterAttributeName(attributeNamePrefix, physicalAnnotation.attributeName()))) {
            convertAnnotationsMap.put(qualifiedAttributeName, physicalAnnotation);
        }
        if ((physicalGroupingAnnotation = this.getPhysicalAnnotation(Converts.class)) != null) {
            for (Convert convertAnnotation : physicalGroupingAnnotation.value()) {
                String qualifiedAttributeName2 = this.qualifyConverterAttributeName(attributeNamePrefix, convertAnnotation.attributeName());
                if (convertAnnotationsMap.containsKey(qualifiedAttributeName2)) continue;
                convertAnnotationsMap.put(qualifiedAttributeName2, convertAnnotation);
            }
        }
    }

    private void checkForOrphanProperties(ManagedType root) {
        AttributesContainer container;
        Class clazz;
        try {
            clazz = this.classLoaderAccess.classForName(this.className);
        }
        catch (ClassLoadingException e) {
            return;
        }
        AttributesContainer attributesContainer = container = root != null ? root.getAttributes() : null;
        if (container != null) {
            HashSet<String> properties = new HashSet<String>();
            for (Field field : clazz.getFields()) {
                properties.add(field.getName());
            }
            for (AccessibleObject accessibleObject : clazz.getMethods()) {
                String name = ((Method)accessibleObject).getName();
                if (name.startsWith("get")) {
                    properties.add(Introspector.decapitalize(name.substring("get".length())));
                    continue;
                }
                if (!name.startsWith("is")) continue;
                properties.add(Introspector.decapitalize(name.substring("is".length())));
            }
            if (container instanceof JaxbAttributes) {
                JaxbAttributes jaxbAttributes = (JaxbAttributes)container;
                this.checkForOrphanProperties((Object)jaxbAttributes.getId(), (Set<String>)properties, (Function)PropertyMappingElementCollector.PERSISTENT_ATTRIBUTE_NAME);
                this.checkForOrphanProperties(jaxbAttributes.getEmbeddedId(), properties, PropertyMappingElementCollector.PERSISTENT_ATTRIBUTE_NAME);
                this.checkForOrphanProperties((Object)jaxbAttributes.getVersion(), (Set<String>)properties, (Function)PropertyMappingElementCollector.PERSISTENT_ATTRIBUTE_NAME);
            }
            this.checkForOrphanProperties((Object)container.getBasicAttributes(), (Set<String>)properties, (Function)PropertyMappingElementCollector.PERSISTENT_ATTRIBUTE_NAME);
            this.checkForOrphanProperties((Object)container.getManyToOneAttributes(), (Set<String>)properties, (Function)PropertyMappingElementCollector.PERSISTENT_ATTRIBUTE_NAME);
            this.checkForOrphanProperties((Object)container.getOneToManyAttributes(), (Set<String>)properties, (Function)PropertyMappingElementCollector.PERSISTENT_ATTRIBUTE_NAME);
            this.checkForOrphanProperties((Object)container.getOneToOneAttributes(), (Set<String>)properties, (Function)PropertyMappingElementCollector.PERSISTENT_ATTRIBUTE_NAME);
            this.checkForOrphanProperties((Object)container.getManyToManyAttributes(), (Set<String>)properties, (Function)PropertyMappingElementCollector.PERSISTENT_ATTRIBUTE_NAME);
            this.checkForOrphanProperties((Object)container.getElementCollectionAttributes(), (Set<String>)properties, (Function)PropertyMappingElementCollector.PERSISTENT_ATTRIBUTE_NAME);
            this.checkForOrphanProperties((Object)container.getEmbeddedAttributes(), (Set<String>)properties, (Function)PropertyMappingElementCollector.PERSISTENT_ATTRIBUTE_NAME);
            this.checkForOrphanProperties((Object)container.getTransients(), (Set<String>)properties, (Function)PropertyMappingElementCollector.JAXB_TRANSIENT_NAME);
        }
    }

    private <T> void checkForOrphanProperties(List<T> elements, Set<String> properties, Function<? super T, String> nameGetter) {
        for (T element : elements) {
            this.checkForOrphanProperties(element, properties, nameGetter);
        }
    }

    private <T> void checkForOrphanProperties(T element, Set<String> properties, Function<? super T, String> nameGetter) {
        if (element == null) {
            return;
        }
        String propertyName = nameGetter.apply(element);
        if (!properties.contains(propertyName)) {
            LOG.propertyNotFound(StringHelper.qualify(this.className, propertyName));
        }
    }

    private void addIfNotNull(List<Annotation> annotationList, Annotation annotation) {
        if (annotation != null) {
            annotationList.add(annotation);
        }
    }

    private Annotation getTableGenerator(PropertyMappingElementCollector elementsForProperty, XMLContext.Default defaults) {
        for (JaxbId element : elementsForProperty.getId()) {
            JaxbTableGenerator subelement = element.getTableGenerator();
            if (subelement == null) continue;
            return JPAXMLOverriddenAnnotationReader.buildTableGeneratorAnnotation(subelement, defaults);
        }
        if (elementsForProperty.isEmpty() && defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(TableGenerator.class);
        }
        return null;
    }

    private Annotation getSequenceGenerator(PropertyMappingElementCollector elementsForProperty, XMLContext.Default defaults) {
        for (JaxbId element : elementsForProperty.getId()) {
            JaxbSequenceGenerator subelement = element.getSequenceGenerator();
            if (subelement == null) continue;
            return JPAXMLOverriddenAnnotationReader.buildSequenceGeneratorAnnotation(subelement);
        }
        if (elementsForProperty.isEmpty() && defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(SequenceGenerator.class);
        }
        return null;
    }

    private void processEventAnnotations(List<Annotation> annotationList, XMLContext.Default defaults) {
        AnnotationDescriptor ad;
        boolean eventElement = false;
        if (!this.elementsForProperty.getPrePersist().isEmpty()) {
            ad = new AnnotationDescriptor(PrePersist.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            eventElement = true;
        } else if (!this.elementsForProperty.getPreRemove().isEmpty()) {
            ad = new AnnotationDescriptor(PreRemove.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            eventElement = true;
        } else if (!this.elementsForProperty.getPreUpdate().isEmpty()) {
            ad = new AnnotationDescriptor(PreUpdate.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            eventElement = true;
        } else if (!this.elementsForProperty.getPostPersist().isEmpty()) {
            ad = new AnnotationDescriptor(PostPersist.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            eventElement = true;
        } else if (!this.elementsForProperty.getPostRemove().isEmpty()) {
            ad = new AnnotationDescriptor(PostRemove.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            eventElement = true;
        } else if (!this.elementsForProperty.getPostUpdate().isEmpty()) {
            ad = new AnnotationDescriptor(PostUpdate.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            eventElement = true;
        } else if (!this.elementsForProperty.getPostLoad().isEmpty()) {
            ad = new AnnotationDescriptor(PostLoad.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            eventElement = true;
        }
        if (!eventElement && defaults.canUseJavaAnnotations()) {
            Annotation ann = this.getPhysicalAnnotation(PrePersist.class);
            this.addIfNotNull(annotationList, ann);
            ann = this.getPhysicalAnnotation(PreRemove.class);
            this.addIfNotNull(annotationList, ann);
            ann = this.getPhysicalAnnotation(PreUpdate.class);
            this.addIfNotNull(annotationList, ann);
            ann = this.getPhysicalAnnotation(PostPersist.class);
            this.addIfNotNull(annotationList, ann);
            ann = this.getPhysicalAnnotation(PostRemove.class);
            this.addIfNotNull(annotationList, ann);
            ann = this.getPhysicalAnnotation(PostUpdate.class);
            this.addIfNotNull(annotationList, ann);
            ann = this.getPhysicalAnnotation(PostLoad.class);
            this.addIfNotNull(annotationList, ann);
        }
    }

    private EntityListeners getEntityListeners(ManagedType root, XMLContext.Default defaults) {
        JaxbEntityListeners element;
        JaxbEntityListeners jaxbEntityListeners = element = root instanceof EntityOrMappedSuperclass ? ((EntityOrMappedSuperclass)root).getEntityListeners() : null;
        if (element != null) {
            ArrayList entityListenerClasses = new ArrayList();
            for (JaxbEntityListener subelement : element.getEntityListener()) {
                String className = subelement.getClazz();
                try {
                    entityListenerClasses.add(this.classLoaderAccess.classForName(XMLContext.buildSafeClassName(className, defaults)));
                }
                catch (ClassLoadingException e) {
                    throw new AnnotationException("Unable to find class: " + className, e);
                }
            }
            AnnotationDescriptor ad = new AnnotationDescriptor(EntityListeners.class);
            ad.setValue("value", (Object)entityListenerClasses.toArray(new Class[0]));
            return (EntityListeners)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(EntityListeners.class);
        }
        return null;
    }

    private JoinTable overridesDefaultsInJoinTable(Annotation annotation, XMLContext.Default defaults) {
        boolean defaultToJoinTable = !this.isPhysicalAnnotationPresent(JoinColumn.class) && !this.isPhysicalAnnotationPresent(JoinColumns.class);
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        defaultToJoinTable = defaultToJoinTable && (annotationClass == ManyToMany.class && StringHelper.isEmpty(((ManyToMany)annotation).mappedBy()) || annotationClass == OneToMany.class && StringHelper.isEmpty(((OneToMany)annotation).mappedBy()) || annotationClass == ElementCollection.class);
        Class<JoinTable> annotationType = JoinTable.class;
        if (defaultToJoinTable && (StringHelper.isNotEmpty(defaults.getCatalog()) || StringHelper.isNotEmpty(defaults.getSchema()))) {
            JoinTable table;
            AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
            if (defaults.canUseJavaAnnotations() && (table = this.getPhysicalAnnotation(annotationType)) != null) {
                ad.setValue("name", (Object)table.name());
                ad.setValue("schema", (Object)table.schema());
                ad.setValue("catalog", (Object)table.catalog());
                ad.setValue("uniqueConstraints", (Object)table.uniqueConstraints());
                ad.setValue("joinColumns", (Object)table.joinColumns());
                ad.setValue("inverseJoinColumns", (Object)table.inverseJoinColumns());
            }
            if (StringHelper.isEmpty((String)ad.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
                ad.setValue("schema", (Object)defaults.getSchema());
            }
            if (StringHelper.isEmpty((String)ad.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
                ad.setValue("catalog", (Object)defaults.getCatalog());
            }
            return (JoinTable)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(annotationType);
        }
        return null;
    }

    private Annotation overridesDefaultCascadePersist(Annotation annotation, XMLContext.Default defaults) {
        if (Boolean.TRUE.equals(defaults.getCascadePersist())) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType == ManyToOne.class) {
                ManyToOne manyToOne = (ManyToOne)annotation;
                ArrayList<CascadeType> cascades = new ArrayList<CascadeType>(Arrays.asList(manyToOne.cascade()));
                if (cascades.contains((Object)CascadeType.ALL) || cascades.contains((Object)CascadeType.PERSIST)) {
                    return annotation;
                }
                cascades.add(CascadeType.PERSIST);
                AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
                ad.setValue("cascade", (Object)cascades.toArray(new CascadeType[0]));
                ad.setValue("targetEntity", (Object)manyToOne.targetEntity());
                ad.setValue("fetch", (Object)manyToOne.fetch());
                ad.setValue("optional", (Object)manyToOne.optional());
                return AnnotationFactory.create((AnnotationDescriptor)ad);
            }
            if (annotationType == OneToOne.class) {
                OneToOne oneToOne = (OneToOne)annotation;
                ArrayList<CascadeType> cascades = new ArrayList<CascadeType>(Arrays.asList(oneToOne.cascade()));
                if (cascades.contains((Object)CascadeType.ALL) || cascades.contains((Object)CascadeType.PERSIST)) {
                    return annotation;
                }
                cascades.add(CascadeType.PERSIST);
                AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
                ad.setValue("cascade", (Object)cascades.toArray(new CascadeType[0]));
                ad.setValue("targetEntity", (Object)oneToOne.targetEntity());
                ad.setValue("fetch", (Object)oneToOne.fetch());
                ad.setValue("optional", (Object)oneToOne.optional());
                ad.setValue("mappedBy", (Object)oneToOne.mappedBy());
                ad.setValue("orphanRemoval", (Object)oneToOne.orphanRemoval());
                return AnnotationFactory.create((AnnotationDescriptor)ad);
            }
        }
        return annotation;
    }

    private void getJoinTable(List<Annotation> annotationList, AssociationAttribute associationAttribute, XMLContext.Default defaults) {
        this.addIfNotNull(annotationList, this.buildJoinTable(associationAttribute.getJoinTable(), defaults));
    }

    private JoinTable buildJoinTable(JaxbJoinTable subelement, XMLContext.Default defaults) {
        Class<JoinTable> annotationType = JoinTable.class;
        if (subelement == null) {
            return null;
        }
        AnnotationDescriptor annotation = new AnnotationDescriptor(annotationType);
        JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, "name", subelement.getName(), false);
        JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, "catalog", subelement.getCatalog(), false);
        if (StringHelper.isNotEmpty(defaults.getCatalog()) && StringHelper.isEmpty((String)annotation.valueOf("catalog"))) {
            annotation.setValue("catalog", (Object)defaults.getCatalog());
        }
        JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, "schema", subelement.getSchema(), false);
        if (StringHelper.isNotEmpty(defaults.getSchema()) && StringHelper.isEmpty((String)annotation.valueOf("schema"))) {
            annotation.setValue("schema", (Object)defaults.getSchema());
        }
        JPAXMLOverriddenAnnotationReader.buildUniqueConstraints(annotation, subelement.getUniqueConstraint());
        JPAXMLOverriddenAnnotationReader.buildIndex(annotation, subelement.getIndex());
        annotation.setValue("joinColumns", (Object)this.getJoinColumns(subelement.getJoinColumn(), false));
        annotation.setValue("inverseJoinColumns", (Object)this.getJoinColumns(subelement.getInverseJoinColumn(), true));
        return (JoinTable)AnnotationFactory.create((AnnotationDescriptor)annotation);
    }

    private void getOneToMany(List<Annotation> annotationList, XMLContext.Default defaults) {
        Class<OneToMany> annotationType = OneToMany.class;
        List<JaxbOneToMany> elements = this.elementsForProperty.getOneToMany();
        for (JaxbOneToMany element : elements) {
            AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
            this.addTargetClass(element.getTargetEntity(), ad, "target-entity", defaults);
            this.getFetchType(ad, element.getFetch());
            this.getCascades(ad, element.getCascade(), defaults);
            this.getJoinTable(annotationList, element, defaults);
            this.buildJoinColumns(annotationList, element.getJoinColumn());
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "orphan-removal", element.isOrphanRemoval(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "mapped-by", element.getMappedBy(), false);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            this.getOrderBy(annotationList, element.getOrderBy());
            this.getMapKey(annotationList, element.getMapKey());
            this.getMapKeyClass(annotationList, element.getMapKeyClass(), defaults);
            this.getMapKeyColumn(annotationList, element.getMapKeyColumn());
            this.getOrderColumn(annotationList, element.getOrderColumn());
            this.getMapKeyTemporal(annotationList, element.getMapKeyTemporal());
            this.getMapKeyEnumerated(annotationList, element.getMapKeyEnumerated());
            AttributeOverrides annotation = this.getMapKeyAttributeOverrides(element.getMapKeyAttributeOverride(), defaults);
            this.addIfNotNull(annotationList, annotation);
            this.getMapKeyJoinColumns(annotationList, element.getMapKeyJoinColumn());
            this.getAccessType(annotationList, element.getAccess());
        }
        this.afterGetAssociation(annotationType, annotationList, defaults);
    }

    private void getOneToOne(List<Annotation> annotationList, XMLContext.Default defaults) {
        Class<OneToOne> annotationType = OneToOne.class;
        List<JaxbOneToOne> elements = this.elementsForProperty.getOneToOne();
        for (JaxbOneToOne element : elements) {
            AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
            this.addTargetClass(element.getTargetEntity(), ad, "target-entity", defaults);
            this.getFetchType(ad, element.getFetch());
            this.getCascades(ad, element.getCascade(), defaults);
            this.getJoinTable(annotationList, element, defaults);
            this.buildJoinColumns(annotationList, element.getJoinColumn());
            PrimaryKeyJoinColumns annotation = this.getPrimaryKeyJoinColumns(element.getPrimaryKeyJoinColumn(), defaults, false);
            this.addIfNotNull(annotationList, annotation);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "optional", element.isOptional(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "orphan-removal", element.isOrphanRemoval(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "mapped-by", element.getMappedBy(), false);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            this.getAssociationId(annotationList, element.isId());
            this.getMapsId(annotationList, element.getMapsId());
            this.getAccessType(annotationList, element.getAccess());
        }
        this.afterGetAssociation(annotationType, annotationList, defaults);
    }

    private void getManyToOne(List<Annotation> annotationList, XMLContext.Default defaults) {
        Class<ManyToOne> annotationType = ManyToOne.class;
        List<JaxbManyToOne> elements = this.elementsForProperty.getManyToOne();
        for (JaxbManyToOne element : elements) {
            AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
            this.addTargetClass(element.getTargetEntity(), ad, "target-entity", defaults);
            this.getFetchType(ad, element.getFetch());
            this.getCascades(ad, element.getCascade(), defaults);
            this.getJoinTable(annotationList, element, defaults);
            this.buildJoinColumns(annotationList, element.getJoinColumn());
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "optional", element.isOptional(), false);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            this.getAssociationId(annotationList, element.isId());
            this.getMapsId(annotationList, element.getMapsId());
            this.getAccessType(annotationList, element.getAccess());
        }
        this.afterGetAssociation(annotationType, annotationList, defaults);
    }

    private void getManyToMany(List<Annotation> annotationList, XMLContext.Default defaults) {
        Class<ManyToMany> annotationType = ManyToMany.class;
        List<JaxbManyToMany> elements = this.elementsForProperty.getManyToMany();
        for (JaxbManyToMany element : elements) {
            AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
            this.addTargetClass(element.getTargetEntity(), ad, "target-entity", defaults);
            this.getFetchType(ad, element.getFetch());
            this.getCascades(ad, element.getCascade(), defaults);
            this.getJoinTable(annotationList, element, defaults);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "mapped-by", element.getMappedBy(), false);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            this.getOrderBy(annotationList, element.getOrderBy());
            this.getMapKey(annotationList, element.getMapKey());
            this.getMapKeyClass(annotationList, element.getMapKeyClass(), defaults);
            this.getMapKeyColumn(annotationList, element.getMapKeyColumn());
            this.getOrderColumn(annotationList, element.getOrderColumn());
            this.getMapKeyTemporal(annotationList, element.getMapKeyTemporal());
            this.getMapKeyEnumerated(annotationList, element.getMapKeyEnumerated());
            AttributeOverrides annotation = this.getMapKeyAttributeOverrides(element.getMapKeyAttributeOverride(), defaults);
            this.addIfNotNull(annotationList, annotation);
            this.getMapKeyJoinColumns(annotationList, element.getMapKeyJoinColumn());
            this.getAccessType(annotationList, element.getAccess());
        }
        this.afterGetAssociation(annotationType, annotationList, defaults);
    }

    private void getAny(List<Annotation> annotationList, XMLContext.Default defaults) {
        this.afterGetAssociation(Any.class, annotationList, defaults);
    }

    private void getManyToAny(List<Annotation> annotationList, XMLContext.Default defaults) {
        this.afterGetAssociation(ManyToAny.class, annotationList, defaults);
    }

    private void afterGetAssociation(Class<? extends Annotation> annotationType, List<Annotation> annotationList, XMLContext.Default defaults) {
        if (this.elementsForProperty.isEmpty() && defaults.canUseJavaAnnotations()) {
            Annotation annotation = this.getPhysicalAnnotation(annotationType);
            if (annotation != null) {
                annotation = this.overridesDefaultCascadePersist(annotation, defaults);
                annotationList.add(annotation);
                annotation = this.overridesDefaultsInJoinTable(annotation, defaults);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(JoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(JoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(PrimaryKeyJoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(PrimaryKeyJoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKey.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(OrderBy.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AttributeOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AttributeOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AssociationOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AssociationOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Lob.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Enumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Temporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Column.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Columns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyClass.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyTemporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyEnumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyJoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyJoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(OrderColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Cascade.class);
                this.addIfNotNull(annotationList, annotation);
            } else if (this.isPhysicalAnnotationPresent(ElementCollection.class)) {
                annotation = this.overridesDefaultsInJoinTable(this.getPhysicalAnnotation(ElementCollection.class), defaults);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKey.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(OrderBy.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AttributeOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AttributeOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AssociationOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AssociationOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Lob.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Enumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Temporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Column.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(OrderColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyClass.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyTemporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyEnumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyJoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyJoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(CollectionTable.class);
                this.addIfNotNull(annotationList, annotation);
            }
        }
    }

    private void getMapKeyJoinColumns(List<Annotation> annotationList, List<JaxbMapKeyJoinColumn> elements) {
        MapKeyJoinColumn[] joinColumns = this.buildMapKeyJoinColumns(elements);
        if (joinColumns.length > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyJoinColumns.class);
            ad.setValue("value", (Object)joinColumns);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private MapKeyJoinColumn[] buildMapKeyJoinColumns(List<JaxbMapKeyJoinColumn> elements) {
        ArrayList<MapKeyJoinColumn> joinColumns = new ArrayList<MapKeyJoinColumn>();
        if (elements != null) {
            for (JaxbMapKeyJoinColumn element : elements) {
                AnnotationDescriptor column = new AnnotationDescriptor(MapKeyJoinColumn.class);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "name", element.getName(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "referenced-column-name", element.getReferencedColumnName(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "unique", element.isUnique(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "nullable", element.isNullable(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "insertable", element.isInsertable(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "updatable", element.isUpdatable(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "column-definition", element.getColumnDefinition(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "table", element.getTable(), false);
                joinColumns.add((MapKeyJoinColumn)AnnotationFactory.create((AnnotationDescriptor)column));
            }
        }
        return joinColumns.toArray(new MapKeyJoinColumn[0]);
    }

    private AttributeOverrides getMapKeyAttributeOverrides(List<JaxbAttributeOverride> elements, XMLContext.Default defaults) {
        List<AttributeOverride> attributes = this.buildAttributeOverrides(elements, "map-key-attribute-override");
        return this.mergeAttributeOverrides(defaults, attributes, false);
    }

    private Cache getCaching(ManagedType root, XMLContext.Default defaults) {
        JaxbCaching caching;
        if (root instanceof JaxbEntity && (caching = ((JaxbEntity)root).getCaching()) != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Cache.class);
            ad.setValue("usage", (Object)CacheConcurrencyStrategy.fromAccessType(caching.getAccess()));
            ad.setValue("region", (Object)caching.getRegion());
            ad.setValue("include", (Object)caching.getInclude().value());
            return (Cache)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(Cache.class);
        }
        return null;
    }

    private Cacheable getCacheable(ManagedType root, XMLContext.Default defaults) {
        Boolean attValue;
        if (root instanceof JaxbEntity && (attValue = ((JaxbEntity)root).isCacheable()) != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Cacheable.class);
            ad.setValue("value", (Object)attValue);
            return (Cacheable)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(Cacheable.class);
        }
        return null;
    }

    private void getMapKeyEnumerated(List<Annotation> annotationList, EnumType enumType) {
        if (enumType != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyEnumerated.class);
            ad.setValue("value", (Object)enumType);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapKeyTemporal(List<Annotation> annotationList, TemporalType temporalType) {
        if (temporalType != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyTemporal.class);
            ad.setValue("value", (Object)temporalType);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getOrderColumn(List<Annotation> annotationList, JaxbOrderColumn element) {
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(OrderColumn.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "name", element.getName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "nullable", element.isNullable(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "insertable", element.isInsertable(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "updatable", element.isUpdatable(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "column-definition", element.getColumnDefinition(), false);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapsId(List<Annotation> annotationList, String mapsId) {
        if (mapsId != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapsId.class);
            ad.setValue("value", (Object)mapsId);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getAssociationId(List<Annotation> annotationList, Boolean isId) {
        if (Boolean.TRUE.equals(isId)) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Id.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void addTargetClass(String className, AnnotationDescriptor ad, String nodeName, XMLContext.Default defaults) {
        if (className != null) {
            Class clazz;
            try {
                clazz = this.classLoaderAccess.classForName(XMLContext.buildSafeClassName(className, defaults));
            }
            catch (ClassLoadingException e) {
                throw new AnnotationException("Unable to find " + nodeName + ": " + className, e);
            }
            ad.setValue(JPAXMLOverriddenAnnotationReader.getJavaAttributeNameFromXMLOne(nodeName), clazz);
        }
    }

    private void getElementCollection(List<Annotation> annotationList, XMLContext.Default defaults) {
        for (JaxbElementCollection element : this.elementsForProperty.getElementCollection()) {
            AnnotationDescriptor ad = new AnnotationDescriptor(ElementCollection.class);
            this.addTargetClass(element.getTargetClass(), ad, "target-class", defaults);
            this.getFetchType(ad, element.getFetch());
            this.getOrderBy(annotationList, element.getOrderBy());
            this.getOrderColumn(annotationList, element.getOrderColumn());
            this.getMapKey(annotationList, element.getMapKey());
            this.getMapKeyClass(annotationList, element.getMapKeyClass(), defaults);
            this.getMapKeyTemporal(annotationList, element.getMapKeyTemporal());
            this.getMapKeyEnumerated(annotationList, element.getMapKeyEnumerated());
            this.getMapKeyColumn(annotationList, element.getMapKeyColumn());
            this.getMapKeyJoinColumns(annotationList, element.getMapKeyJoinColumn());
            Annotation annotation = this.getColumn(element.getColumn(), false, "element-collection");
            this.addIfNotNull(annotationList, annotation);
            this.getTemporal(annotationList, element.getTemporal());
            this.getEnumerated(annotationList, element.getEnumerated());
            this.getLob(annotationList, element.getLob());
            ArrayList<AttributeOverride> attributes = new ArrayList<AttributeOverride>();
            attributes.addAll(this.buildAttributeOverrides(element.getMapKeyAttributeOverride(), "map-key-attribute-override"));
            attributes.addAll(this.buildAttributeOverrides(element.getAttributeOverride(), "attribute-override"));
            annotation = this.mergeAttributeOverrides(defaults, attributes, false);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getAssociationOverrides(element.getAssociationOverride(), defaults, false);
            this.addIfNotNull(annotationList, annotation);
            this.getCollectionTable(annotationList, element.getCollectionTable(), defaults);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            this.getAccessType(annotationList, element.getAccess());
        }
    }

    private void getOrderBy(List<Annotation> annotationList, String orderBy) {
        if (orderBy != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(OrderBy.class);
            ad.setValue("value", (Object)orderBy);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapKey(List<Annotation> annotationList, JaxbMapKey element) {
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKey.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "name", element.getName(), false);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapKeyColumn(List<Annotation> annotationList, JaxbMapKeyColumn element) {
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyColumn.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "name", element.getName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "unique", element.isUnique(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "nullable", element.isNullable(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "insertable", element.isInsertable(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "updatable", element.isUpdatable(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "column-definition", element.getColumnDefinition(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "table", element.getTable(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "length", element.getLength(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "precision", element.getPrecision(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "scale", element.getScale(), false);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapKeyClass(List<Annotation> annotationList, JaxbMapKeyClass element, XMLContext.Default defaults) {
        String nodeName = "map-key-class";
        if (element != null) {
            String mapKeyClassName = element.getClazz();
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyClass.class);
            if (StringHelper.isNotEmpty(mapKeyClassName)) {
                Class clazz;
                try {
                    clazz = this.classLoaderAccess.classForName(XMLContext.buildSafeClassName(mapKeyClassName, defaults));
                }
                catch (ClassLoadingException e) {
                    throw new AnnotationException("Unable to find " + nodeName + ": " + mapKeyClassName, e);
                }
                ad.setValue("value", clazz);
            }
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getCollectionTable(List<Annotation> annotationList, JaxbCollectionTable element, XMLContext.Default defaults) {
        if (element != null) {
            JoinColumn[] joinColumns;
            AnnotationDescriptor annotation = new AnnotationDescriptor(CollectionTable.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, "name", element.getName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, "catalog", element.getCatalog(), false);
            if (StringHelper.isNotEmpty(defaults.getCatalog()) && StringHelper.isEmpty((String)annotation.valueOf("catalog"))) {
                annotation.setValue("catalog", (Object)defaults.getCatalog());
            }
            JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, "schema", element.getSchema(), false);
            if (StringHelper.isNotEmpty(defaults.getSchema()) && StringHelper.isEmpty((String)annotation.valueOf("schema"))) {
                annotation.setValue("schema", (Object)defaults.getSchema());
            }
            if ((joinColumns = this.getJoinColumns(element.getJoinColumn(), false)).length > 0) {
                annotation.setValue("joinColumns", (Object)joinColumns);
            }
            JPAXMLOverriddenAnnotationReader.buildUniqueConstraints(annotation, element.getUniqueConstraint());
            JPAXMLOverriddenAnnotationReader.buildIndex(annotation, element.getIndex());
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)annotation));
        }
    }

    private void buildJoinColumns(List<Annotation> annotationList, List<JaxbJoinColumn> elements) {
        JoinColumn[] joinColumns = this.getJoinColumns(elements, false);
        if (joinColumns.length > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(JoinColumns.class);
            ad.setValue("value", (Object)joinColumns);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getCascades(AnnotationDescriptor ad, JaxbCascadeType element, XMLContext.Default defaults) {
        ArrayList<CascadeType> cascades = new ArrayList<CascadeType>();
        if (element != null) {
            if (element.getCascadeAll() != null) {
                cascades.add(CascadeType.ALL);
            }
            if (element.getCascadePersist() != null) {
                cascades.add(CascadeType.PERSIST);
            }
            if (element.getCascadeMerge() != null) {
                cascades.add(CascadeType.MERGE);
            }
            if (element.getCascadeRemove() != null) {
                cascades.add(CascadeType.REMOVE);
            }
            if (element.getCascadeRefresh() != null) {
                cascades.add(CascadeType.REFRESH);
            }
            if (element.getCascadeDetach() != null) {
                cascades.add(CascadeType.DETACH);
            }
        }
        if (Boolean.TRUE.equals(defaults.getCascadePersist()) && !cascades.contains((Object)CascadeType.ALL) && !cascades.contains((Object)CascadeType.PERSIST)) {
            cascades.add(CascadeType.PERSIST);
        }
        if (cascades.size() > 0) {
            ad.setValue("cascade", (Object)cascades.toArray(new CascadeType[0]));
        }
    }

    private void getEmbedded(List<Annotation> annotationList, XMLContext.Default defaults) {
        Annotation annotation;
        for (JaxbEmbedded element : this.elementsForProperty.getEmbedded()) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Embedded.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            Annotation annotation2 = this.getAttributeOverrides(element.getAttributeOverride(), defaults, false);
            this.addIfNotNull(annotationList, annotation2);
            annotation2 = this.getAssociationOverrides(element.getAssociationOverride(), defaults, false);
            this.addIfNotNull(annotationList, annotation2);
            this.getAccessType(annotationList, element.getAccess());
        }
        if (this.elementsForProperty.isEmpty() && defaults.canUseJavaAnnotations() && (annotation = this.getPhysicalAnnotation(Embedded.class)) != null) {
            annotationList.add(annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverride.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverrides.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverride.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverrides.class);
            this.addIfNotNull(annotationList, annotation);
        }
    }

    private Transient getTransient(XMLContext.Default defaults) {
        if (!this.elementsForProperty.getTransient().isEmpty()) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Transient.class);
            return (Transient)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (this.elementsForProperty.isEmpty() && defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(Transient.class);
        }
        return null;
    }

    private void getVersion(List<Annotation> annotationList, XMLContext.Default defaults) {
        Annotation annotation;
        for (JaxbVersion element : this.elementsForProperty.getVersion()) {
            Columns annotation2 = this.buildColumns(element.getColumn(), "version");
            this.addIfNotNull(annotationList, annotation2);
            this.getTemporal(annotationList, element.getTemporal());
            AnnotationDescriptor basic = new AnnotationDescriptor(Version.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)basic));
            this.getAccessType(annotationList, element.getAccess());
        }
        if (this.elementsForProperty.isEmpty() && defaults.canUseJavaAnnotations() && (annotation = this.getPhysicalAnnotation(Version.class)) != null) {
            annotationList.add(annotation);
            annotation = this.getPhysicalAnnotation(Column.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(Columns.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(Temporal.class);
            this.addIfNotNull(annotationList, annotation);
        }
    }

    private void getBasic(List<Annotation> annotationList, XMLContext.Default defaults) {
        for (JaxbBasic element : this.elementsForProperty.getBasic()) {
            Columns annotation = this.buildColumns(element.getColumn(), "basic");
            this.addIfNotNull(annotationList, annotation);
            this.getAccessType(annotationList, element.getAccess());
            this.getTemporal(annotationList, element.getTemporal());
            this.getLob(annotationList, element.getLob());
            this.getEnumerated(annotationList, element.getEnumerated());
            AnnotationDescriptor basic = new AnnotationDescriptor(Basic.class);
            this.getFetchType(basic, element.getFetch());
            JPAXMLOverriddenAnnotationReader.copyAttribute(basic, "optional", element.isOptional(), false);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)basic));
            this.getType(annotationList, element.getType());
            this.getJdbcTypeCode(annotationList, element.getJdbcTypeCode());
            this.getTenantId(annotationList, element);
        }
        if (this.elementsForProperty.isEmpty() && defaults.canUseJavaAnnotations()) {
            Annotation annotation = this.getPhysicalAnnotation(Basic.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(Lob.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(Enumerated.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(Temporal.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(Column.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(Columns.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverride.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverrides.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverride.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverrides.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(Type.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(JdbcTypeCode.class);
            this.addIfNotNull(annotationList, annotation);
        }
    }

    private void getTenantId(List<Annotation> annotationList, JaxbBasic element) {
        if (element instanceof JaxbTenantId) {
            AnnotationDescriptor ad = new AnnotationDescriptor(TenantId.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getType(List<Annotation> annotationList, JaxbColumnType type) {
        if (type != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Type.class);
            ad.setValue("value", this.classLoaderAccess.classForName(type.getValue()));
            Parameter[] parameters = new Parameter[type.getParameters().size()];
            for (int i = 0; i < parameters.length; ++i) {
                JaxbConfigurationParameter parameter = type.getParameters().get(i);
                AnnotationDescriptor param = new AnnotationDescriptor(Parameter.class);
                param.setValue("name", (Object)parameter.getName());
                param.setValue("value", (Object)parameter.getValue());
                parameters[i] = (Parameter)AnnotationFactory.create((AnnotationDescriptor)param);
            }
            ad.setValue("parameters", (Object)parameters);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getUuidGenerator(List<Annotation> annotationList, JaxbUuidGenerator uuidGenerator) {
        if (uuidGenerator != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(UuidGenerator.class);
            ad.setValue("style", (Object)uuidGenerator.getStyle());
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getJdbcTypeCode(List<Annotation> annotationList, Integer jdbcTypeCode) {
        if (jdbcTypeCode != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(JdbcTypeCode.class);
            ad.setValue("value", (Object)jdbcTypeCode);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getEnumerated(List<Annotation> annotationList, EnumType enumType) {
        if (enumType != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Enumerated.class);
            ad.setValue("value", (Object)enumType);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getLob(List<Annotation> annotationList, JaxbLob element) {
        if (element != null) {
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)new AnnotationDescriptor(Lob.class)));
        }
    }

    private void getFetchType(AnnotationDescriptor descriptor, FetchType type) {
        if (type != null) {
            descriptor.setValue("fetch", (Object)type);
        }
    }

    private void getEmbeddedId(List<Annotation> annotationList, XMLContext.Default defaults) {
        Annotation annotation;
        for (JaxbEmbeddedId element : this.elementsForProperty.getEmbeddedId()) {
            if (!this.isProcessingId(defaults)) continue;
            AttributeOverrides annotation2 = this.getAttributeOverrides(element.getAttributeOverride(), defaults, false);
            this.addIfNotNull(annotationList, annotation2);
            AnnotationDescriptor ad = new AnnotationDescriptor(EmbeddedId.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            this.getAccessType(annotationList, element.getAccess());
        }
        if (this.elementsForProperty.isEmpty() && defaults.canUseJavaAnnotations() && (annotation = this.getPhysicalAnnotation(EmbeddedId.class)) != null) {
            annotationList.add(annotation);
            annotation = this.getPhysicalAnnotation(Column.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(Columns.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(GeneratedValue.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(Temporal.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(TableGenerator.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(SequenceGenerator.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverride.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverrides.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverride.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverrides.class);
            this.addIfNotNull(annotationList, annotation);
        }
    }

    private void preCalculateElementsForProperty(ManagedType managedType, JaxbEntityListener entityListener) {
        AttributesContainer attributes;
        this.elementsForProperty = new PropertyMappingElementCollector(this.propertyName);
        AttributesContainer attributesContainer = attributes = managedType == null ? null : managedType.getAttributes();
        if (attributes != null) {
            this.elementsForProperty.collectPersistentAttributesIfMatching(attributes);
        }
        if (managedType instanceof LifecycleCallbackContainer) {
            this.elementsForProperty.collectLifecycleCallbacksIfMatching((LifecycleCallbackContainer)((Object)managedType));
        }
        if (entityListener != null) {
            this.elementsForProperty.collectLifecycleCallbacksIfMatching(entityListener);
        }
        this.elementsForProperty.collectTenantIdIfMatching(managedType);
    }

    private void getId(List<Annotation> annotationList, XMLContext.Default defaults) {
        Annotation annotation;
        for (JaxbId element : this.elementsForProperty.getId()) {
            boolean processId = this.isProcessingId(defaults);
            if (!processId) continue;
            Annotation annotation2 = this.buildColumns(element.getColumn(), "id");
            this.addIfNotNull(annotationList, annotation2);
            annotation2 = this.buildGeneratedValue(element.getGeneratedValue());
            this.addIfNotNull(annotationList, annotation2);
            this.getTemporal(annotationList, element.getTemporal());
            annotation2 = this.getTableGenerator(element.getTableGenerator(), defaults);
            this.addIfNotNull(annotationList, annotation2);
            annotation2 = this.getSequenceGenerator(element.getSequenceGenerator(), defaults);
            this.addIfNotNull(annotationList, annotation2);
            AnnotationDescriptor id = new AnnotationDescriptor(Id.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)id));
            this.getAccessType(annotationList, element.getAccess());
            this.getType(annotationList, element.getType());
            this.getJdbcTypeCode(annotationList, element.getJdbcTypeCode());
            this.getUuidGenerator(annotationList, element.getUuidGenerator());
        }
        if (this.elementsForProperty.isEmpty() && defaults.canUseJavaAnnotations() && (annotation = this.getPhysicalAnnotation(Id.class)) != null) {
            annotationList.add(annotation);
            annotation = this.getPhysicalAnnotation(Column.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(Columns.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(GeneratedValue.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(Temporal.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(TableGenerator.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(SequenceGenerator.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverride.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverrides.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverride.class);
            this.addIfNotNull(annotationList, annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverrides.class);
            this.addIfNotNull(annotationList, annotation);
        }
    }

    private boolean isProcessingId(XMLContext.Default defaults) {
        boolean isExplicit = defaults.getAccess() != null;
        boolean correctAccess = PropertyType.PROPERTY.equals((Object)this.propertyType) && AccessType.PROPERTY.equals((Object)defaults.getAccess()) || PropertyType.FIELD.equals((Object)this.propertyType) && AccessType.FIELD.equals((Object)defaults.getAccess());
        boolean hasId = defaults.canUseJavaAnnotations() && (this.isPhysicalAnnotationPresent(Id.class) || this.isPhysicalAnnotationPresent(EmbeddedId.class));
        boolean mirrorAttributeIsId = defaults.canUseJavaAnnotations() && HCANNHelper.hasAnnotation(this.mirroredAttribute, Id.class, EmbeddedId.class);
        boolean propertyIsDefault = PropertyType.PROPERTY.equals((Object)this.propertyType) && !mirrorAttributeIsId;
        return correctAccess || !isExplicit && hasId || !isExplicit && propertyIsDefault;
    }

    private Columns buildColumns(JaxbColumn element, String nodeName) {
        if (element == null) {
            return null;
        }
        ArrayList<Column> columns = new ArrayList<Column>(1);
        columns.add(this.getColumn(element, false, nodeName));
        AnnotationDescriptor columnsDescr = new AnnotationDescriptor(Columns.class);
        columnsDescr.setValue("columns", (Object)columns.toArray(new Column[0]));
        return (Columns)AnnotationFactory.create((AnnotationDescriptor)columnsDescr);
    }

    private Columns buildColumns(List<JaxbColumn> elements, String nodeName) {
        ArrayList<Column> columns = new ArrayList<Column>(elements.size());
        for (JaxbColumn element : elements) {
            columns.add(this.getColumn(element, false, nodeName));
        }
        if (columns.size() > 0) {
            AnnotationDescriptor columnsDescr = new AnnotationDescriptor(Columns.class);
            columnsDescr.setValue("columns", (Object)columns.toArray(new Column[columns.size()]));
            return (Columns)AnnotationFactory.create((AnnotationDescriptor)columnsDescr);
        }
        return null;
    }

    private GeneratedValue buildGeneratedValue(JaxbGeneratedValue element) {
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(GeneratedValue.class);
            GenerationType strategy = element.getStrategy();
            if (strategy != null) {
                ad.setValue("strategy", (Object)strategy);
            }
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "generator", element.getGenerator(), false);
            return (GeneratedValue)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void getTemporal(List<Annotation> annotationList, TemporalType type) {
        if (type != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Temporal.class);
            ad.setValue("value", (Object)type);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getAccessType(List<Annotation> annotationList, AccessType type) {
        if (this.element == null) {
            return;
        }
        if (type != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Access.class);
            if (AccessType.PROPERTY.equals((Object)type) && this.element instanceof Method || AccessType.FIELD.equals((Object)type) && this.element instanceof Field) {
                return;
            }
            ad.setValue("value", (Object)type);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private AssociationOverrides getAssociationOverrides(ManagedType root, XMLContext.Default defaults) {
        return this.getAssociationOverrides(root instanceof JaxbEntity ? ((JaxbEntity)root).getAssociationOverride() : Collections.emptyList(), defaults, true);
    }

    private AssociationOverrides getAssociationOverrides(List<JaxbAssociationOverride> elements, XMLContext.Default defaults, boolean mergeWithAnnotations) {
        List<AssociationOverride> attributes = this.buildAssociationOverrides(elements, defaults);
        if (mergeWithAnnotations && defaults.canUseJavaAnnotations()) {
            AssociationOverride annotation = this.getPhysicalAnnotation(AssociationOverride.class);
            this.addAssociationOverrideIfNeeded(annotation, attributes);
            AssociationOverrides annotations = this.getPhysicalAnnotation(AssociationOverrides.class);
            if (annotations != null) {
                for (AssociationOverride current : annotations.value()) {
                    this.addAssociationOverrideIfNeeded(current, attributes);
                }
            }
        }
        if (attributes.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(AssociationOverrides.class);
            ad.setValue("value", (Object)attributes.toArray(new AssociationOverride[0]));
            return (AssociationOverrides)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private List<AssociationOverride> buildAssociationOverrides(List<JaxbAssociationOverride> elements, XMLContext.Default defaults) {
        ArrayList<AssociationOverride> overrides = new ArrayList<AssociationOverride>();
        if (elements != null && elements.size() > 0) {
            for (JaxbAssociationOverride current : elements) {
                AnnotationDescriptor override = new AnnotationDescriptor(AssociationOverride.class);
                JPAXMLOverriddenAnnotationReader.copyAttribute(override, "name", current.getName(), true);
                override.setValue("joinColumns", (Object)this.getJoinColumns(current.getJoinColumn(), false));
                JoinTable joinTable = this.buildJoinTable(current.getJoinTable(), defaults);
                if (joinTable != null) {
                    override.setValue("joinTable", (Object)joinTable);
                }
                overrides.add((AssociationOverride)AnnotationFactory.create((AnnotationDescriptor)override));
            }
        }
        return overrides;
    }

    private JoinColumn[] getJoinColumns(List<JaxbJoinColumn> subelements, boolean isInverse) {
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>();
        if (subelements != null) {
            for (JaxbJoinColumn subelement : subelements) {
                AnnotationDescriptor column = new AnnotationDescriptor(JoinColumn.class);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "name", subelement.getName(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "referenced-column-name", subelement.getReferencedColumnName(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "unique", subelement.isUnique(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "nullable", subelement.isNullable(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "insertable", subelement.isInsertable(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "updatable", subelement.isUpdatable(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "column-definition", subelement.getColumnDefinition(), false);
                JPAXMLOverriddenAnnotationReader.copyAttribute(column, "table", subelement.getTable(), false);
                joinColumns.add((JoinColumn)AnnotationFactory.create((AnnotationDescriptor)column));
            }
        }
        return joinColumns.toArray(new JoinColumn[0]);
    }

    private void addAssociationOverrideIfNeeded(AssociationOverride annotation, List<AssociationOverride> overrides) {
        if (annotation != null) {
            String overrideName = annotation.name();
            boolean present = false;
            for (AssociationOverride current : overrides) {
                if (!current.name().equals(overrideName)) continue;
                present = true;
                break;
            }
            if (!present) {
                overrides.add(annotation);
            }
        }
    }

    private AttributeOverrides getAttributeOverrides(ManagedType root, XMLContext.Default defaults) {
        return this.getAttributeOverrides(root instanceof JaxbEntity ? ((JaxbEntity)root).getAttributeOverride() : Collections.emptyList(), defaults, true);
    }

    private AttributeOverrides getAttributeOverrides(List<JaxbAttributeOverride> elements, XMLContext.Default defaults, boolean mergeWithAnnotations) {
        List<AttributeOverride> attributes = this.buildAttributeOverrides(elements, "attribute-override");
        return this.mergeAttributeOverrides(defaults, attributes, mergeWithAnnotations);
    }

    private AttributeOverrides mergeAttributeOverrides(XMLContext.Default defaults, List<AttributeOverride> attributes, boolean mergeWithAnnotations) {
        if (mergeWithAnnotations && defaults.canUseJavaAnnotations()) {
            AttributeOverride annotation = this.getPhysicalAnnotation(AttributeOverride.class);
            this.addAttributeOverrideIfNeeded(annotation, attributes);
            AttributeOverrides annotations = this.getPhysicalAnnotation(AttributeOverrides.class);
            if (annotations != null) {
                for (AttributeOverride current : annotations.value()) {
                    this.addAttributeOverrideIfNeeded(current, attributes);
                }
            }
        }
        if (attributes.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(AttributeOverrides.class);
            ad.setValue("value", (Object)attributes.toArray(new AttributeOverride[attributes.size()]));
            return (AttributeOverrides)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private List<AttributeOverride> buildAttributeOverrides(List<JaxbAttributeOverride> subelements, String nodeName) {
        ArrayList<AttributeOverride> overrides = new ArrayList<AttributeOverride>();
        if (subelements != null && subelements.size() > 0) {
            for (JaxbAttributeOverride current : subelements) {
                AnnotationDescriptor override = new AnnotationDescriptor(AttributeOverride.class);
                JPAXMLOverriddenAnnotationReader.copyAttribute(override, "name", current.getName(), true);
                JaxbColumn column = current.getColumn();
                override.setValue("column", (Object)this.getColumn(column, true, nodeName));
                overrides.add((AttributeOverride)AnnotationFactory.create((AnnotationDescriptor)override));
            }
        }
        return overrides;
    }

    private Column getColumn(JaxbColumn element, boolean isMandatory, String nodeName) {
        if (element != null) {
            AnnotationDescriptor column = new AnnotationDescriptor(Column.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(column, "name", element.getName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(column, "unique", element.isUnique(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(column, "nullable", element.isNullable(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(column, "insertable", element.isInsertable(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(column, "updatable", element.isUpdatable(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(column, "column-definition", element.getColumnDefinition(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(column, "table", element.getTable(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(column, "length", element.getLength(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(column, "precision", element.getPrecision(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(column, "scale", element.getScale(), false);
            return (Column)AnnotationFactory.create((AnnotationDescriptor)column);
        }
        if (isMandatory) {
            throw new AnnotationException(nodeName + ".column is mandatory. Activate schema validation for more information");
        }
        return null;
    }

    private void addAttributeOverrideIfNeeded(AttributeOverride annotation, List<AttributeOverride> overrides) {
        if (annotation != null) {
            String overrideName = annotation.name();
            boolean present = false;
            for (AttributeOverride current : overrides) {
                if (!current.name().equals(overrideName)) continue;
                present = true;
                break;
            }
            if (!present) {
                overrides.add(annotation);
            }
        }
    }

    private Access getAccessType(ManagedType root, XMLContext.Default defaults) {
        AccessType access;
        AccessType accessType = access = root == null ? null : root.getAccess();
        if (access != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Access.class);
            ad.setValue("value", (Object)access);
            return (Access)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations() && this.isPhysicalAnnotationPresent(Access.class)) {
            return this.getPhysicalAnnotation(Access.class);
        }
        if (defaults.getAccess() != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Access.class);
            ad.setValue("value", (Object)defaults.getAccess());
            return (Access)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private ExcludeSuperclassListeners getExcludeSuperclassListeners(ManagedType root, XMLContext.Default defaults) {
        return (ExcludeSuperclassListeners)this.getMarkerAnnotation(ExcludeSuperclassListeners.class, root instanceof EntityOrMappedSuperclass ? ((EntityOrMappedSuperclass)root).getExcludeSuperclassListeners() : null, defaults);
    }

    private ExcludeDefaultListeners getExcludeDefaultListeners(ManagedType root, XMLContext.Default defaults) {
        return (ExcludeDefaultListeners)this.getMarkerAnnotation(ExcludeDefaultListeners.class, root instanceof EntityOrMappedSuperclass ? ((EntityOrMappedSuperclass)root).getExcludeDefaultListeners() : null, defaults);
    }

    private Annotation getMarkerAnnotation(Class<? extends Annotation> clazz, JaxbEmptyType element, XMLContext.Default defaults) {
        if (element != null) {
            return AnnotationFactory.create((AnnotationDescriptor)new AnnotationDescriptor(clazz));
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(clazz);
        }
        return null;
    }

    private SqlResultSetMappings getSqlResultSetMappings(ManagedType root, XMLContext.Default defaults) {
        ArrayList<SqlResultSetMapping> results;
        List<SqlResultSetMapping> list = results = root instanceof JaxbEntity ? JPAXMLOverriddenAnnotationReader.buildSqlResultSetMappings(((JaxbEntity)root).getSqlResultSetMapping(), defaults, this.classLoaderAccess) : new ArrayList<SqlResultSetMapping>();
        if (defaults.canUseJavaAnnotations()) {
            SqlResultSetMapping annotation = this.getPhysicalAnnotation(SqlResultSetMapping.class);
            this.addSqlResultsetMappingIfNeeded(annotation, results);
            SqlResultSetMappings annotations = this.getPhysicalAnnotation(SqlResultSetMappings.class);
            if (annotations != null) {
                for (SqlResultSetMapping current : annotations.value()) {
                    this.addSqlResultsetMappingIfNeeded(current, results);
                }
            }
        }
        if (results.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(SqlResultSetMappings.class);
            ad.setValue("value", (Object)results.toArray(new SqlResultSetMapping[results.size()]));
            return (SqlResultSetMappings)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    public static List<NamedEntityGraph> buildNamedEntityGraph(List<JaxbNamedEntityGraph> elements, XMLContext.Default defaults, ClassLoaderAccess classLoaderAccess) {
        ArrayList<NamedEntityGraph> namedEntityGraphList = new ArrayList<NamedEntityGraph>();
        for (JaxbNamedEntityGraph element : elements) {
            AnnotationDescriptor ann = new AnnotationDescriptor(NamedEntityGraph.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ann, "name", element.getName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ann, "include-all-attributes", element.isIncludeAllAttributes(), false);
            JPAXMLOverriddenAnnotationReader.bindNamedAttributeNodes(element.getNamedAttributeNode(), ann);
            JPAXMLOverriddenAnnotationReader.bindNamedSubgraph(defaults, ann, "subgraphs", element.getSubgraph(), classLoaderAccess);
            JPAXMLOverriddenAnnotationReader.bindNamedSubgraph(defaults, ann, "subclassSubgraphs", element.getSubclassSubgraph(), classLoaderAccess);
            namedEntityGraphList.add((NamedEntityGraph)AnnotationFactory.create((AnnotationDescriptor)ann));
        }
        return namedEntityGraphList;
    }

    private static void bindNamedSubgraph(XMLContext.Default defaults, AnnotationDescriptor ann, String annotationAttributeName, List<JaxbNamedSubgraph> subgraphNodes, ClassLoaderAccess classLoaderAccess) {
        ArrayList<NamedSubgraph> annSubgraphNodes = new ArrayList<NamedSubgraph>();
        for (JaxbNamedSubgraph subgraphNode : subgraphNodes) {
            Class clazz;
            AnnotationDescriptor annSubgraphNode = new AnnotationDescriptor(NamedSubgraph.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(annSubgraphNode, "name", subgraphNode.getName(), true);
            String clazzName = subgraphNode.getClazz();
            try {
                clazz = classLoaderAccess.classForName(XMLContext.buildSafeClassName(clazzName, defaults));
            }
            catch (ClassLoadingException e) {
                throw new AnnotationException("Unable to find entity-class: " + clazzName, e);
            }
            annSubgraphNode.setValue("type", clazz);
            JPAXMLOverriddenAnnotationReader.bindNamedAttributeNodes(subgraphNode.getNamedAttributeNode(), annSubgraphNode);
            annSubgraphNodes.add((NamedSubgraph)AnnotationFactory.create((AnnotationDescriptor)annSubgraphNode));
        }
        ann.setValue(annotationAttributeName, (Object)annSubgraphNodes.toArray(new NamedSubgraph[annSubgraphNodes.size()]));
    }

    private static void bindNamedAttributeNodes(List<JaxbNamedAttributeNode> elements, AnnotationDescriptor ann) {
        ArrayList<NamedAttributeNode> annNamedAttributeNodes = new ArrayList<NamedAttributeNode>();
        for (JaxbNamedAttributeNode element : elements) {
            AnnotationDescriptor annNamedAttributeNode = new AnnotationDescriptor(NamedAttributeNode.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(annNamedAttributeNode, "value", "name", element.getName(), true);
            JPAXMLOverriddenAnnotationReader.copyAttribute(annNamedAttributeNode, "subgraph", element.getSubgraph(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(annNamedAttributeNode, "key-subgraph", element.getKeySubgraph(), false);
            annNamedAttributeNodes.add((NamedAttributeNode)AnnotationFactory.create((AnnotationDescriptor)annNamedAttributeNode));
        }
        ann.setValue("attributeNodes", (Object)annNamedAttributeNodes.toArray(new NamedAttributeNode[0]));
    }

    public static List<NamedStoredProcedureQuery> buildNamedStoreProcedureQueries(List<JaxbNamedStoredProcedureQuery> elements, XMLContext.Default defaults, ClassLoaderAccess classLoaderAccess) {
        ArrayList<NamedStoredProcedureQuery> namedStoredProcedureQueries = new ArrayList<NamedStoredProcedureQuery>();
        for (JaxbNamedStoredProcedureQuery element : elements) {
            AnnotationDescriptor ann = new AnnotationDescriptor(NamedStoredProcedureQuery.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ann, "name", element.getName(), true);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ann, "procedure-name", element.getProcedureName(), true);
            ArrayList<StoredProcedureParameter> storedProcedureParameters = new ArrayList<StoredProcedureParameter>();
            for (JaxbStoredProcedureParameter parameterElement : element.getParameter()) {
                Class clazz;
                AnnotationDescriptor parameterDescriptor = new AnnotationDescriptor(StoredProcedureParameter.class);
                JPAXMLOverriddenAnnotationReader.copyAttribute(parameterDescriptor, "name", parameterElement.getName(), false);
                ParameterMode modeValue = parameterElement.getMode();
                if (modeValue == null) {
                    parameterDescriptor.setValue("mode", (Object)ParameterMode.IN);
                } else {
                    parameterDescriptor.setValue("mode", (Object)modeValue);
                }
                String clazzName = parameterElement.getClazz();
                try {
                    clazz = classLoaderAccess.classForName(XMLContext.buildSafeClassName(clazzName, defaults));
                }
                catch (ClassLoadingException e) {
                    throw new AnnotationException("Unable to find entity-class: " + clazzName, e);
                }
                parameterDescriptor.setValue("type", clazz);
                storedProcedureParameters.add((StoredProcedureParameter)AnnotationFactory.create((AnnotationDescriptor)parameterDescriptor));
            }
            ann.setValue("parameters", (Object)storedProcedureParameters.toArray(new StoredProcedureParameter[0]));
            ArrayList returnClasses = new ArrayList();
            for (String clazzName : element.getResultClass()) {
                Class clazz;
                try {
                    clazz = classLoaderAccess.classForName(XMLContext.buildSafeClassName(clazzName, defaults));
                }
                catch (ClassLoadingException e) {
                    throw new AnnotationException("Unable to find entity-class: " + clazzName, e);
                }
                returnClasses.add(clazz);
            }
            ann.setValue("resultClasses", (Object)returnClasses.toArray(new Class[0]));
            ann.setValue("resultSetMappings", (Object)element.getResultSetMapping().toArray(new String[0]));
            JPAXMLOverriddenAnnotationReader.buildQueryHints(element.getHint(), ann, Collections.emptyMap());
            namedStoredProcedureQueries.add((NamedStoredProcedureQuery)AnnotationFactory.create((AnnotationDescriptor)ann));
        }
        return namedStoredProcedureQueries;
    }

    public static List<SqlResultSetMapping> buildSqlResultSetMappings(List<JaxbSqlResultSetMapping> elements, XMLContext.Default defaults, ClassLoaderAccess classLoaderAccess) {
        ArrayList<SqlResultSetMapping> builtResultSetMappings = new ArrayList<SqlResultSetMapping>();
        for (JaxbSqlResultSetMapping resultSetMappingElement : elements) {
            AnnotationDescriptor resultSetMappingAnnotation = new AnnotationDescriptor(SqlResultSetMapping.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(resultSetMappingAnnotation, "name", resultSetMappingElement.getName(), true);
            ArrayList<EntityResult> entityResultAnnotations = null;
            ArrayList<ColumnResult> columnResultAnnotations = null;
            ArrayList<ConstructorResult> constructorResultAnnotations = null;
            for (JaxbEntityResult jaxbEntityResult : resultSetMappingElement.getEntityResult()) {
                if (entityResultAnnotations == null) {
                    entityResultAnnotations = new ArrayList<EntityResult>();
                }
                entityResultAnnotations.add(JPAXMLOverriddenAnnotationReader.buildEntityResult(jaxbEntityResult, defaults, classLoaderAccess));
            }
            for (JaxbColumnResult jaxbColumnResult : resultSetMappingElement.getColumnResult()) {
                if (columnResultAnnotations == null) {
                    columnResultAnnotations = new ArrayList<ColumnResult>();
                }
                columnResultAnnotations.add(JPAXMLOverriddenAnnotationReader.buildColumnResult(jaxbColumnResult, defaults, classLoaderAccess));
            }
            for (JaxbConstructorResult jaxbConstructorResult : resultSetMappingElement.getConstructorResult()) {
                if (constructorResultAnnotations == null) {
                    constructorResultAnnotations = new ArrayList<ConstructorResult>();
                }
                constructorResultAnnotations.add(JPAXMLOverriddenAnnotationReader.buildConstructorResult(jaxbConstructorResult, defaults, classLoaderAccess));
            }
            if (entityResultAnnotations != null && !entityResultAnnotations.isEmpty()) {
                resultSetMappingAnnotation.setValue("entities", (Object)entityResultAnnotations.toArray(new EntityResult[entityResultAnnotations.size()]));
            }
            if (columnResultAnnotations != null && !columnResultAnnotations.isEmpty()) {
                resultSetMappingAnnotation.setValue("columns", (Object)columnResultAnnotations.toArray(new ColumnResult[columnResultAnnotations.size()]));
            }
            if (constructorResultAnnotations != null && !constructorResultAnnotations.isEmpty()) {
                resultSetMappingAnnotation.setValue("classes", (Object)constructorResultAnnotations.toArray(new ConstructorResult[constructorResultAnnotations.size()]));
            }
            builtResultSetMappings.add((SqlResultSetMapping)AnnotationFactory.create((AnnotationDescriptor)resultSetMappingAnnotation));
        }
        return builtResultSetMappings;
    }

    private static EntityResult buildEntityResult(JaxbEntityResult entityResultElement, XMLContext.Default defaults, ClassLoaderAccess classLoaderAccess) {
        AnnotationDescriptor entityResultDescriptor = new AnnotationDescriptor(EntityResult.class);
        Class<?> entityClass = JPAXMLOverriddenAnnotationReader.resolveClassReference(entityResultElement.getEntityClass(), defaults, classLoaderAccess);
        entityResultDescriptor.setValue("entityClass", entityClass);
        JPAXMLOverriddenAnnotationReader.copyAttribute(entityResultDescriptor, "discriminator-column", entityResultElement.getDiscriminatorColumn(), false);
        ArrayList<FieldResult> fieldResultAnnotations = new ArrayList<FieldResult>();
        for (JaxbFieldResult fieldResult : entityResultElement.getFieldResult()) {
            AnnotationDescriptor fieldResultDescriptor = new AnnotationDescriptor(FieldResult.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(fieldResultDescriptor, "name", fieldResult.getName(), true);
            JPAXMLOverriddenAnnotationReader.copyAttribute(fieldResultDescriptor, "column", fieldResult.getColumn(), true);
            fieldResultAnnotations.add((FieldResult)AnnotationFactory.create((AnnotationDescriptor)fieldResultDescriptor));
        }
        entityResultDescriptor.setValue("fields", (Object)fieldResultAnnotations.toArray(new FieldResult[fieldResultAnnotations.size()]));
        return (EntityResult)AnnotationFactory.create((AnnotationDescriptor)entityResultDescriptor);
    }

    private static Class<?> resolveClassReference(String className, XMLContext.Default defaults, ClassLoaderAccess classLoaderAccess) {
        if (className == null) {
            throw new AnnotationException("<entity-result> without entity-class. Activate schema validation for more information");
        }
        try {
            return classLoaderAccess.classForName(XMLContext.buildSafeClassName(className, defaults));
        }
        catch (ClassLoadingException e) {
            throw new AnnotationException("Unable to find specified class: " + className, e);
        }
    }

    private static ColumnResult buildColumnResult(JaxbColumnResult columnResultElement, XMLContext.Default defaults, ClassLoaderAccess classLoaderAccess) {
        AnnotationDescriptor columnResultDescriptor = new AnnotationDescriptor(ColumnResult.class);
        JPAXMLOverriddenAnnotationReader.copyAttribute(columnResultDescriptor, "name", columnResultElement.getName(), true);
        String columnTypeName = columnResultElement.getClazz();
        if (StringHelper.isNotEmpty(columnTypeName)) {
            columnResultDescriptor.setValue("type", JPAXMLOverriddenAnnotationReader.resolveClassReference(columnTypeName, defaults, classLoaderAccess));
        }
        return (ColumnResult)AnnotationFactory.create((AnnotationDescriptor)columnResultDescriptor);
    }

    private static ConstructorResult buildConstructorResult(JaxbConstructorResult constructorResultElement, XMLContext.Default defaults, ClassLoaderAccess classLoaderAccess) {
        AnnotationDescriptor constructorResultDescriptor = new AnnotationDescriptor(ConstructorResult.class);
        Class<?> entityClass = JPAXMLOverriddenAnnotationReader.resolveClassReference(constructorResultElement.getTargetClass(), defaults, classLoaderAccess);
        constructorResultDescriptor.setValue("targetClass", entityClass);
        ArrayList<ColumnResult> columnResultAnnotations = new ArrayList<ColumnResult>();
        for (JaxbColumnResult columnResultElement : constructorResultElement.getColumn()) {
            columnResultAnnotations.add(JPAXMLOverriddenAnnotationReader.buildColumnResult(columnResultElement, defaults, classLoaderAccess));
        }
        constructorResultDescriptor.setValue("columns", (Object)columnResultAnnotations.toArray(new ColumnResult[columnResultAnnotations.size()]));
        return (ConstructorResult)AnnotationFactory.create((AnnotationDescriptor)constructorResultDescriptor);
    }

    private void addSqlResultsetMappingIfNeeded(SqlResultSetMapping annotation, List<SqlResultSetMapping> resultsets) {
        if (annotation != null) {
            String resultsetName = annotation.name();
            boolean present = false;
            for (SqlResultSetMapping current : resultsets) {
                if (!current.name().equals(resultsetName)) continue;
                present = true;
                break;
            }
            if (!present) {
                resultsets.add(annotation);
            }
        }
    }

    private NamedQueries getNamedQueries(ManagedType root, XMLContext.Default defaults) {
        ArrayList<NamedQuery> queries;
        List<NamedQuery> list = queries = root instanceof JaxbEntity ? JPAXMLOverriddenAnnotationReader.buildNamedQueries(((JaxbEntity)root).getNamedQuery(), defaults, this.classLoaderAccess) : new ArrayList<NamedQuery>();
        if (defaults.canUseJavaAnnotations()) {
            NamedQuery annotation = this.getPhysicalAnnotation(NamedQuery.class);
            this.addNamedQueryIfNeeded(annotation, queries);
            NamedQueries annotations = this.getPhysicalAnnotation(NamedQueries.class);
            if (annotations != null) {
                for (NamedQuery current : annotations.value()) {
                    this.addNamedQueryIfNeeded(current, queries);
                }
            }
        }
        if (queries.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(NamedQueries.class);
            ad.setValue("value", (Object)queries.toArray(new NamedQuery[queries.size()]));
            return (NamedQueries)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void addNamedQueryIfNeeded(NamedQuery annotation, List<NamedQuery> queries) {
        if (annotation != null) {
            String queryName = annotation.name();
            boolean present = false;
            for (NamedQuery current : queries) {
                if (!current.name().equals(queryName)) continue;
                present = true;
                break;
            }
            if (!present) {
                queries.add(annotation);
            }
        }
    }

    private NamedEntityGraphs getNamedEntityGraphs(ManagedType root, XMLContext.Default defaults) {
        ArrayList<NamedEntityGraph> queries;
        List<NamedEntityGraph> list = queries = root instanceof JaxbEntity ? JPAXMLOverriddenAnnotationReader.buildNamedEntityGraph(((JaxbEntity)root).getNamedEntityGraph(), defaults, this.classLoaderAccess) : new ArrayList<NamedEntityGraph>();
        if (defaults.canUseJavaAnnotations()) {
            NamedEntityGraph annotation = this.getPhysicalAnnotation(NamedEntityGraph.class);
            this.addNamedEntityGraphIfNeeded(annotation, queries);
            NamedEntityGraphs annotations = this.getPhysicalAnnotation(NamedEntityGraphs.class);
            if (annotations != null) {
                for (NamedEntityGraph current : annotations.value()) {
                    this.addNamedEntityGraphIfNeeded(current, queries);
                }
            }
        }
        if (queries.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(NamedEntityGraphs.class);
            ad.setValue("value", (Object)queries.toArray(new NamedEntityGraph[queries.size()]));
            return (NamedEntityGraphs)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void addNamedEntityGraphIfNeeded(NamedEntityGraph annotation, List<NamedEntityGraph> queries) {
        if (annotation != null) {
            String queryName = annotation.name();
            boolean present = false;
            for (NamedEntityGraph current : queries) {
                if (!current.name().equals(queryName)) continue;
                present = true;
                break;
            }
            if (!present) {
                queries.add(annotation);
            }
        }
    }

    private NamedStoredProcedureQueries getNamedStoredProcedureQueries(ManagedType root, XMLContext.Default defaults) {
        ArrayList<NamedStoredProcedureQuery> queries;
        List<NamedStoredProcedureQuery> list = queries = root instanceof JaxbEntity ? JPAXMLOverriddenAnnotationReader.buildNamedStoreProcedureQueries(((JaxbEntity)root).getNamedStoredProcedureQuery(), defaults, this.classLoaderAccess) : new ArrayList<NamedStoredProcedureQuery>();
        if (defaults.canUseJavaAnnotations()) {
            NamedStoredProcedureQuery annotation = this.getPhysicalAnnotation(NamedStoredProcedureQuery.class);
            this.addNamedStoredProcedureQueryIfNeeded(annotation, queries);
            NamedStoredProcedureQueries annotations = this.getPhysicalAnnotation(NamedStoredProcedureQueries.class);
            if (annotations != null) {
                for (NamedStoredProcedureQuery current : annotations.value()) {
                    this.addNamedStoredProcedureQueryIfNeeded(current, queries);
                }
            }
        }
        if (queries.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(NamedStoredProcedureQueries.class);
            ad.setValue("value", (Object)queries.toArray(new NamedStoredProcedureQuery[queries.size()]));
            return (NamedStoredProcedureQueries)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void addNamedStoredProcedureQueryIfNeeded(NamedStoredProcedureQuery annotation, List<NamedStoredProcedureQuery> queries) {
        if (annotation != null) {
            String queryName = annotation.name();
            boolean present = false;
            for (NamedStoredProcedureQuery current : queries) {
                if (!current.name().equals(queryName)) continue;
                present = true;
                break;
            }
            if (!present) {
                queries.add(annotation);
            }
        }
    }

    private NamedNativeQueries getNamedNativeQueries(ManagedType root, XMLContext.Default defaults) {
        ArrayList<NamedNativeQuery> queries;
        List<NamedNativeQuery> list = queries = root instanceof JaxbEntity ? JPAXMLOverriddenAnnotationReader.buildNamedNativeQueries(((JaxbEntity)root).getNamedNativeQuery(), defaults, this.classLoaderAccess) : new ArrayList<NamedNativeQuery>();
        if (defaults.canUseJavaAnnotations()) {
            NamedNativeQuery annotation = this.getPhysicalAnnotation(NamedNativeQuery.class);
            this.addNamedNativeQueryIfNeeded(annotation, queries);
            NamedNativeQueries annotations = this.getPhysicalAnnotation(NamedNativeQueries.class);
            if (annotations != null) {
                for (NamedNativeQuery current : annotations.value()) {
                    this.addNamedNativeQueryIfNeeded(current, queries);
                }
            }
        }
        if (queries.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(NamedNativeQueries.class);
            ad.setValue("value", (Object)queries.toArray(new NamedNativeQuery[queries.size()]));
            return (NamedNativeQueries)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void addNamedNativeQueryIfNeeded(NamedNativeQuery annotation, List<NamedNativeQuery> queries) {
        if (annotation != null) {
            String queryName = annotation.name();
            boolean present = false;
            for (NamedNativeQuery current : queries) {
                if (!current.name().equals(queryName)) continue;
                present = true;
                break;
            }
            if (!present) {
                queries.add(annotation);
            }
        }
    }

    private static void buildQueryHints(List<JaxbQueryHint> elements, AnnotationDescriptor ann, Map<String, String> additionalHints) {
        ArrayList<QueryHint> queryHints = new ArrayList<QueryHint>(elements.size() + additionalHints.size());
        for (Map.Entry<String, String> entry : additionalHints.entrySet()) {
            AnnotationDescriptor hintDescriptor = new AnnotationDescriptor(QueryHint.class);
            hintDescriptor.setValue("name", (Object)entry.getKey());
            hintDescriptor.setValue("value", (Object)entry.getValue());
            queryHints.add((QueryHint)AnnotationFactory.create((AnnotationDescriptor)hintDescriptor));
        }
        for (JaxbQueryHint hint : elements) {
            String value = hint.getName();
            if (value == null) {
                throw new AnnotationException("<hint> without name. Activate schema validation for more information");
            }
            if (additionalHints.containsKey(value)) continue;
            AnnotationDescriptor hintDescriptor = new AnnotationDescriptor(QueryHint.class);
            hintDescriptor.setValue("name", (Object)value);
            value = hint.getValue();
            if (value == null) {
                throw new AnnotationException("<hint> without value. Activate schema validation for more information");
            }
            hintDescriptor.setValue("value", (Object)value);
            queryHints.add((QueryHint)AnnotationFactory.create((AnnotationDescriptor)hintDescriptor));
        }
        ann.setValue("hints", (Object)queryHints.toArray(new QueryHint[queryHints.size()]));
    }

    public static List<NamedQuery> buildNamedQueries(List<JaxbNamedQuery> elements, XMLContext.Default defaults, ClassLoaderAccess classLoaderAccess) {
        ArrayList<NamedQuery> namedQueries = new ArrayList<NamedQuery>();
        for (JaxbNamedQuery element : elements) {
            AnnotationDescriptor ann = new AnnotationDescriptor(NamedQuery.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ann, "name", element.getName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ann, "query", element.getQuery(), true);
            HashMap<String, String> additionalHints = new HashMap<String, String>();
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.cacheable", element.isCacheable());
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.cacheMode", (Object)element.getCacheMode());
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.cacheRegion", element.getCacheRegion());
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.comment", element.getComment());
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.fetchSize", element.getFetchSize());
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.flushMode", (Object)element.getFlushMode());
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.timeout", element.getTimeout());
            JPAXMLOverriddenAnnotationReader.buildQueryHints(element.getHint(), ann, additionalHints);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ann, "lock-mode", (Object)element.getLockMode(), false);
            namedQueries.add((NamedQuery)AnnotationFactory.create((AnnotationDescriptor)ann));
        }
        return namedQueries;
    }

    public static List<NamedNativeQuery> buildNamedNativeQueries(List<JaxbNamedNativeQuery> elements, XMLContext.Default defaults, ClassLoaderAccess classLoaderAccess) {
        ArrayList<NamedNativeQuery> namedQueries = new ArrayList<NamedNativeQuery>();
        for (JaxbNamedNativeQuery element : elements) {
            AnnotationDescriptor ann = new AnnotationDescriptor(NamedNativeQuery.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ann, "name", element.getName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ann, "query", element.getQuery(), true);
            HashMap<String, String> additionalHints = new HashMap<String, String>();
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.cacheable", element.isCacheable());
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.cacheMode", (Object)element.getCacheMode());
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.cacheRegion", element.getCacheRegion());
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.comment", element.getComment());
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.fetchSize", element.getFetchSize());
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.flushMode", (Object)element.getFlushMode());
            JPAXMLOverriddenAnnotationReader.addHint(additionalHints, "org.hibernate.timeout", element.getTimeout());
            JPAXMLOverriddenAnnotationReader.addSynchronizationsHint(additionalHints, element.getSynchronizations());
            JPAXMLOverriddenAnnotationReader.buildQueryHints(element.getHint(), ann, additionalHints);
            String clazzName = element.getResultClass();
            if (StringHelper.isNotEmpty(clazzName)) {
                Class clazz;
                try {
                    clazz = classLoaderAccess.classForName(XMLContext.buildSafeClassName(clazzName, defaults));
                }
                catch (ClassLoadingException e) {
                    throw new AnnotationException("Unable to find entity-class: " + clazzName, e);
                }
                ann.setValue("resultClass", clazz);
            }
            JPAXMLOverriddenAnnotationReader.copyAttribute(ann, "result-set-mapping", element.getResultSetMapping(), false);
            namedQueries.add((NamedNativeQuery)AnnotationFactory.create((AnnotationDescriptor)ann));
        }
        return namedQueries;
    }

    private static void addHint(Map<String, String> hints, String hint, Object value) {
        if (value != null) {
            hints.put(hint, value.toString());
        }
    }

    private static void addSynchronizationsHint(Map<String, String> hints, List<JaxbSynchronizedTable> synchronizations) {
        if (synchronizations.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(synchronizations.get(0).getTable());
        for (int i = 1; i < synchronizations.size(); ++i) {
            sb.append(' ');
            sb.append(synchronizations.get(i).getTable());
        }
        hints.put("org.hibernate.query.native.spaces", sb.toString());
    }

    private TableGenerator getTableGenerator(ManagedType root, XMLContext.Default defaults) {
        return this.getTableGenerator(root instanceof JaxbEntity ? ((JaxbEntity)root).getTableGenerator() : null, defaults);
    }

    private TableGenerator getTableGenerator(JaxbTableGenerator element, XMLContext.Default defaults) {
        if (element != null) {
            return JPAXMLOverriddenAnnotationReader.buildTableGeneratorAnnotation(element, defaults);
        }
        if (defaults.canUseJavaAnnotations() && this.isPhysicalAnnotationPresent(TableGenerator.class)) {
            TableGenerator tableAnn = this.getPhysicalAnnotation(TableGenerator.class);
            if (StringHelper.isNotEmpty(defaults.getSchema()) || StringHelper.isNotEmpty(defaults.getCatalog())) {
                AnnotationDescriptor annotation = new AnnotationDescriptor(TableGenerator.class);
                annotation.setValue("name", (Object)tableAnn.name());
                annotation.setValue("table", (Object)tableAnn.table());
                annotation.setValue("catalog", (Object)tableAnn.table());
                if (StringHelper.isEmpty((String)annotation.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
                    annotation.setValue("catalog", (Object)defaults.getCatalog());
                }
                annotation.setValue("schema", (Object)tableAnn.table());
                if (StringHelper.isEmpty((String)annotation.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
                    annotation.setValue("catalog", (Object)defaults.getSchema());
                }
                annotation.setValue("pkColumnName", (Object)tableAnn.pkColumnName());
                annotation.setValue("valueColumnName", (Object)tableAnn.valueColumnName());
                annotation.setValue("pkColumnValue", (Object)tableAnn.pkColumnValue());
                annotation.setValue("initialValue", (Object)tableAnn.initialValue());
                annotation.setValue("allocationSize", (Object)tableAnn.allocationSize());
                annotation.setValue("uniqueConstraints", (Object)tableAnn.uniqueConstraints());
                return (TableGenerator)AnnotationFactory.create((AnnotationDescriptor)annotation);
            }
            return tableAnn;
        }
        return null;
    }

    public static TableGenerator buildTableGeneratorAnnotation(JaxbTableGenerator element, XMLContext.Default defaults) {
        AnnotationDescriptor ad = new AnnotationDescriptor(TableGenerator.class);
        JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "name", element.getName(), false);
        JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "table", element.getTable(), false);
        JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "catalog", element.getCatalog(), false);
        JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "schema", element.getSchema(), false);
        JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "pk-column-name", element.getPkColumnName(), false);
        JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "value-column-name", element.getValueColumnName(), false);
        JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "pk-column-value", element.getPkColumnValue(), false);
        JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "initial-value", element.getInitialValue(), false);
        JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "allocation-size", element.getAllocationSize(), false);
        JPAXMLOverriddenAnnotationReader.buildUniqueConstraints(ad, element.getUniqueConstraint());
        if (StringHelper.isEmpty((String)ad.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
            ad.setValue("schema", (Object)defaults.getSchema());
        }
        if (StringHelper.isEmpty((String)ad.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
            ad.setValue("catalog", (Object)defaults.getCatalog());
        }
        return (TableGenerator)AnnotationFactory.create((AnnotationDescriptor)ad);
    }

    private SequenceGenerator getSequenceGenerator(ManagedType root, XMLContext.Default defaults) {
        return this.getSequenceGenerator(root instanceof JaxbEntity ? ((JaxbEntity)root).getSequenceGenerator() : null, defaults);
    }

    private SequenceGenerator getSequenceGenerator(JaxbSequenceGenerator element, XMLContext.Default defaults) {
        if (element != null) {
            return JPAXMLOverriddenAnnotationReader.buildSequenceGeneratorAnnotation(element);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(SequenceGenerator.class);
        }
        return null;
    }

    public static SequenceGenerator buildSequenceGeneratorAnnotation(JaxbSequenceGenerator element) {
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(SequenceGenerator.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "name", element.getName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "sequence-name", element.getSequenceName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "initial-value", element.getInitialValue(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "allocation-size", element.getAllocationSize(), false);
            return (SequenceGenerator)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private DiscriminatorColumn getDiscriminatorColumn(ManagedType root, XMLContext.Default defaults) {
        JaxbDiscriminatorColumn element;
        JaxbDiscriminatorColumn jaxbDiscriminatorColumn = element = root instanceof JaxbEntity ? ((JaxbEntity)root).getDiscriminatorColumn() : null;
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(DiscriminatorColumn.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "name", element.getName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "column-definition", element.getColumnDefinition(), false);
            DiscriminatorType type = element.getDiscriminatorType();
            if (type != null) {
                ad.setValue("discriminatorType", (Object)type);
            }
            JPAXMLOverriddenAnnotationReader.copyAttribute(ad, "length", element.getLength(), false);
            return (DiscriminatorColumn)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(DiscriminatorColumn.class);
        }
        return null;
    }

    private DiscriminatorValue getDiscriminatorValue(ManagedType root, XMLContext.Default defaults) {
        String element;
        String string = element = root instanceof JaxbEntity ? ((JaxbEntity)root).getDiscriminatorValue() : null;
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(DiscriminatorValue.class);
            ad.setValue("value", (Object)element);
            return (DiscriminatorValue)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(DiscriminatorValue.class);
        }
        return null;
    }

    private Inheritance getInheritance(ManagedType root, XMLContext.Default defaults) {
        JaxbInheritance element;
        JaxbInheritance jaxbInheritance = element = root instanceof JaxbEntity ? ((JaxbEntity)root).getInheritance() : null;
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Inheritance.class);
            InheritanceType strategy = element.getStrategy();
            if (strategy != null) {
                ad.setValue("strategy", (Object)strategy);
            }
            return (Inheritance)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(Inheritance.class);
        }
        return null;
    }

    private IdClass getIdClass(ManagedType root, XMLContext.Default defaults) {
        JaxbIdClass element;
        JaxbIdClass jaxbIdClass = element = root instanceof EntityOrMappedSuperclass ? ((EntityOrMappedSuperclass)root).getIdClass() : null;
        if (element != null) {
            String className = element.getClazz();
            if (className != null) {
                Class clazz;
                AnnotationDescriptor ad = new AnnotationDescriptor(IdClass.class);
                try {
                    clazz = this.classLoaderAccess.classForName(XMLContext.buildSafeClassName(className, defaults));
                }
                catch (ClassLoadingException e) {
                    throw new AnnotationException("Unable to find id-class: " + className, e);
                }
                ad.setValue("value", clazz);
                return (IdClass)AnnotationFactory.create((AnnotationDescriptor)ad);
            }
            throw new AnnotationException("id-class without class. Activate schema validation for more information");
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(IdClass.class);
        }
        return null;
    }

    private PrimaryKeyJoinColumns getPrimaryKeyJoinColumns(ManagedType root, XMLContext.Default defaults) {
        return this.getPrimaryKeyJoinColumns(root instanceof JaxbEntity ? ((JaxbEntity)root).getPrimaryKeyJoinColumn() : Collections.emptyList(), defaults, true);
    }

    private PrimaryKeyJoinColumns getPrimaryKeyJoinColumns(List<JaxbPrimaryKeyJoinColumn> elements, XMLContext.Default defaults, boolean mergeWithAnnotations) {
        PrimaryKeyJoinColumn[] columns = this.buildPrimaryKeyJoinColumns(elements);
        if (mergeWithAnnotations && columns.length == 0 && defaults.canUseJavaAnnotations()) {
            PrimaryKeyJoinColumn annotation = this.getPhysicalAnnotation(PrimaryKeyJoinColumn.class);
            if (annotation != null) {
                columns = new PrimaryKeyJoinColumn[]{annotation};
            } else {
                PrimaryKeyJoinColumns annotations = this.getPhysicalAnnotation(PrimaryKeyJoinColumns.class);
                PrimaryKeyJoinColumn[] primaryKeyJoinColumnArray = columns = annotations != null ? annotations.value() : columns;
            }
        }
        if (columns.length > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(PrimaryKeyJoinColumns.class);
            ad.setValue("value", (Object)columns);
            return (PrimaryKeyJoinColumns)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private Entity getEntity(ManagedType element, XMLContext.Default defaults) {
        if (element == null) {
            return defaults.canUseJavaAnnotations() ? this.getPhysicalAnnotation(Entity.class) : null;
        }
        if (element instanceof JaxbEntity) {
            Entity javaAnn;
            JaxbEntity entityElement = (JaxbEntity)element;
            AnnotationDescriptor entity = new AnnotationDescriptor(Entity.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(entity, "name", entityElement.getName(), false);
            if (defaults.canUseJavaAnnotations() && StringHelper.isEmpty((String)entity.valueOf("name")) && (javaAnn = this.getPhysicalAnnotation(Entity.class)) != null) {
                entity.setValue("name", (Object)javaAnn.name());
            }
            return (Entity)AnnotationFactory.create((AnnotationDescriptor)entity);
        }
        return null;
    }

    private MappedSuperclass getMappedSuperclass(ManagedType element, XMLContext.Default defaults) {
        if (element == null) {
            return defaults.canUseJavaAnnotations() ? this.getPhysicalAnnotation(MappedSuperclass.class) : null;
        }
        if (element instanceof JaxbMappedSuperclass) {
            AnnotationDescriptor entity = new AnnotationDescriptor(MappedSuperclass.class);
            return (MappedSuperclass)AnnotationFactory.create((AnnotationDescriptor)entity);
        }
        return null;
    }

    private Embeddable getEmbeddable(ManagedType element, XMLContext.Default defaults) {
        if (element == null) {
            return defaults.canUseJavaAnnotations() ? this.getPhysicalAnnotation(Embeddable.class) : null;
        }
        if (element instanceof JaxbEmbeddable) {
            AnnotationDescriptor entity = new AnnotationDescriptor(Embeddable.class);
            return (Embeddable)AnnotationFactory.create((AnnotationDescriptor)entity);
        }
        return null;
    }

    private Subselect getTableExpression(JaxbEntity entity, XMLContext.Default defaults) {
        String tableExpression = entity.getTableExpression();
        if (StringHelper.isEmpty(tableExpression)) {
            return null;
        }
        AnnotationDescriptor annotation = new AnnotationDescriptor(Subselect.class);
        annotation.setValue("value", (Object)tableExpression);
        return (Subselect)AnnotationFactory.create((AnnotationDescriptor)annotation);
    }

    private Table getTable(ManagedType root, XMLContext.Default defaults) {
        JaxbTable element;
        JaxbTable jaxbTable = element = root instanceof JaxbEntity ? ((JaxbEntity)root).getTable() : null;
        if (element == null) {
            if (StringHelper.isNotEmpty(defaults.getCatalog()) || StringHelper.isNotEmpty(defaults.getSchema())) {
                Table table;
                AnnotationDescriptor annotation = new AnnotationDescriptor(Table.class);
                if (defaults.canUseJavaAnnotations() && (table = this.getPhysicalAnnotation(Table.class)) != null) {
                    annotation.setValue("name", (Object)table.name());
                    annotation.setValue("schema", (Object)table.schema());
                    annotation.setValue("catalog", (Object)table.catalog());
                    annotation.setValue("uniqueConstraints", (Object)table.uniqueConstraints());
                    annotation.setValue("indexes", (Object)table.indexes());
                }
                if (StringHelper.isEmpty((String)annotation.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
                    annotation.setValue("schema", (Object)defaults.getSchema());
                }
                if (StringHelper.isEmpty((String)annotation.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
                    annotation.setValue("catalog", (Object)defaults.getCatalog());
                }
                return (Table)AnnotationFactory.create((AnnotationDescriptor)annotation);
            }
            if (defaults.canUseJavaAnnotations()) {
                return this.getPhysicalAnnotation(Table.class);
            }
            return null;
        }
        AnnotationDescriptor annotation = new AnnotationDescriptor(Table.class);
        JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, "name", element.getName(), false);
        JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, "catalog", element.getCatalog(), false);
        if (StringHelper.isNotEmpty(defaults.getCatalog()) && StringHelper.isEmpty((String)annotation.valueOf("catalog"))) {
            annotation.setValue("catalog", (Object)defaults.getCatalog());
        }
        JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, "schema", element.getSchema(), false);
        if (StringHelper.isNotEmpty(defaults.getSchema()) && StringHelper.isEmpty((String)annotation.valueOf("schema"))) {
            annotation.setValue("schema", (Object)defaults.getSchema());
        }
        JPAXMLOverriddenAnnotationReader.buildUniqueConstraints(annotation, element.getUniqueConstraint());
        JPAXMLOverriddenAnnotationReader.buildIndex(annotation, element.getIndex());
        return (Table)AnnotationFactory.create((AnnotationDescriptor)annotation);
    }

    private SecondaryTables getSecondaryTables(ManagedType root, XMLContext.Default defaults) {
        List<JaxbSecondaryTable> elements = root instanceof JaxbEntity ? ((JaxbEntity)root).getSecondaryTable() : Collections.emptyList();
        ArrayList<SecondaryTable> secondaryTables = new ArrayList<SecondaryTable>(3);
        for (JaxbSecondaryTable element : elements) {
            AnnotationDescriptor annotation = new AnnotationDescriptor(SecondaryTable.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, "name", element.getName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, "catalog", element.getCatalog(), false);
            if (StringHelper.isNotEmpty(defaults.getCatalog()) && StringHelper.isEmpty((String)annotation.valueOf("catalog"))) {
                annotation.setValue("catalog", (Object)defaults.getCatalog());
            }
            JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, "schema", element.getSchema(), false);
            if (StringHelper.isNotEmpty(defaults.getSchema()) && StringHelper.isEmpty((String)annotation.valueOf("schema"))) {
                annotation.setValue("schema", (Object)defaults.getSchema());
            }
            JPAXMLOverriddenAnnotationReader.buildUniqueConstraints(annotation, element.getUniqueConstraint());
            JPAXMLOverriddenAnnotationReader.buildIndex(annotation, element.getIndex());
            annotation.setValue("pkJoinColumns", (Object)this.buildPrimaryKeyJoinColumns(element.getPrimaryKeyJoinColumn()));
            secondaryTables.add((SecondaryTable)AnnotationFactory.create((AnnotationDescriptor)annotation));
        }
        if (secondaryTables.size() == 0 && defaults.canUseJavaAnnotations()) {
            SecondaryTable secTableAnn = this.getPhysicalAnnotation(SecondaryTable.class);
            this.overridesDefaultInSecondaryTable(secTableAnn, defaults, secondaryTables);
            SecondaryTables secTablesAnn = this.getPhysicalAnnotation(SecondaryTables.class);
            if (secTablesAnn != null) {
                for (SecondaryTable table : secTablesAnn.value()) {
                    this.overridesDefaultInSecondaryTable(table, defaults, secondaryTables);
                }
            }
        }
        if (secondaryTables.size() > 0) {
            AnnotationDescriptor descriptor = new AnnotationDescriptor(SecondaryTables.class);
            descriptor.setValue("value", (Object)secondaryTables.toArray(new SecondaryTable[secondaryTables.size()]));
            return (SecondaryTables)AnnotationFactory.create((AnnotationDescriptor)descriptor);
        }
        return null;
    }

    private void overridesDefaultInSecondaryTable(SecondaryTable secTableAnn, XMLContext.Default defaults, List<SecondaryTable> secondaryTables) {
        if (secTableAnn != null) {
            if (StringHelper.isNotEmpty(defaults.getCatalog()) || StringHelper.isNotEmpty(defaults.getSchema())) {
                AnnotationDescriptor annotation = new AnnotationDescriptor(SecondaryTable.class);
                annotation.setValue("name", (Object)secTableAnn.name());
                annotation.setValue("schema", (Object)secTableAnn.schema());
                annotation.setValue("catalog", (Object)secTableAnn.catalog());
                annotation.setValue("uniqueConstraints", (Object)secTableAnn.uniqueConstraints());
                annotation.setValue("pkJoinColumns", (Object)secTableAnn.pkJoinColumns());
                if (StringHelper.isEmpty((String)annotation.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
                    annotation.setValue("schema", (Object)defaults.getSchema());
                }
                if (StringHelper.isEmpty((String)annotation.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
                    annotation.setValue("catalog", (Object)defaults.getCatalog());
                }
                secondaryTables.add((SecondaryTable)AnnotationFactory.create((AnnotationDescriptor)annotation));
            } else {
                secondaryTables.add(secTableAnn);
            }
        }
    }

    private static void buildIndex(AnnotationDescriptor annotation, List<JaxbIndex> elements) {
        Index[] indexes = new Index[elements.size()];
        int i = 0;
        for (JaxbIndex element : elements) {
            AnnotationDescriptor indexAnn = new AnnotationDescriptor(Index.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(indexAnn, "name", element.getName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(indexAnn, "column-list", element.getColumnList(), true);
            JPAXMLOverriddenAnnotationReader.copyAttribute(indexAnn, "unique", element.isUnique(), false);
            indexes[i++] = (Index)AnnotationFactory.create((AnnotationDescriptor)indexAnn);
        }
        annotation.setValue("indexes", (Object)indexes);
    }

    private static void buildUniqueConstraints(AnnotationDescriptor annotation, List<JaxbUniqueConstraint> elements) {
        UniqueConstraint[] uniqueConstraints = new UniqueConstraint[elements.size()];
        int i = 0;
        for (JaxbUniqueConstraint element : elements) {
            String[] columnNames = element.getColumnName().toArray(new String[0]);
            AnnotationDescriptor ucAnn = new AnnotationDescriptor(UniqueConstraint.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(ucAnn, "name", element.getName(), false);
            ucAnn.setValue("columnNames", (Object)columnNames);
            uniqueConstraints[i++] = (UniqueConstraint)AnnotationFactory.create((AnnotationDescriptor)ucAnn);
        }
        annotation.setValue("uniqueConstraints", (Object)uniqueConstraints);
    }

    private PrimaryKeyJoinColumn[] buildPrimaryKeyJoinColumns(List<JaxbPrimaryKeyJoinColumn> elements) {
        PrimaryKeyJoinColumn[] pkJoinColumns = new PrimaryKeyJoinColumn[elements.size()];
        int i = 0;
        for (JaxbPrimaryKeyJoinColumn element : elements) {
            AnnotationDescriptor pkAnn = new AnnotationDescriptor(PrimaryKeyJoinColumn.class);
            JPAXMLOverriddenAnnotationReader.copyAttribute(pkAnn, "name", element.getName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(pkAnn, "referenced-column-name", element.getReferencedColumnName(), false);
            JPAXMLOverriddenAnnotationReader.copyAttribute(pkAnn, "column-definition", element.getColumnDefinition(), false);
            pkJoinColumns[i++] = (PrimaryKeyJoinColumn)AnnotationFactory.create((AnnotationDescriptor)pkAnn);
        }
        return pkJoinColumns;
    }

    private static void copyAttribute(AnnotationDescriptor annotation, String attributeName, Object attributeValue, boolean mandatory) {
        JPAXMLOverriddenAnnotationReader.copyAttribute(annotation, JPAXMLOverriddenAnnotationReader.getJavaAttributeNameFromXMLOne(attributeName), attributeName, attributeValue, mandatory);
    }

    private static void copyAttribute(AnnotationDescriptor annotation, String annotationAttributeName, Object attributeName, Object attributeValue, boolean mandatory) {
        if (attributeValue != null) {
            annotation.setValue(annotationAttributeName, attributeValue);
        } else if (mandatory) {
            throw new AnnotationException(annotationToXml.getOrDefault(annotation.type(), annotation.type().getName()) + "." + attributeName + " is mandatory in XML overriding. Activate schema validation for more information");
        }
    }

    private static String getJavaAttributeNameFromXMLOne(String attributeName) {
        StringBuilder annotationAttributeName = new StringBuilder(attributeName);
        int index = annotationAttributeName.indexOf(WORD_SEPARATOR);
        while (index != -1) {
            annotationAttributeName.deleteCharAt(index);
            annotationAttributeName.setCharAt(index, Character.toUpperCase(annotationAttributeName.charAt(index)));
            index = annotationAttributeName.indexOf(WORD_SEPARATOR);
        }
        return annotationAttributeName.toString();
    }

    private <T extends Annotation> T getPhysicalAnnotation(Class<T> annotationType) {
        return this.element.getAnnotation(annotationType);
    }

    private <T extends Annotation> boolean isPhysicalAnnotationPresent(Class<T> annotationType) {
        return this.element.isAnnotationPresent(annotationType);
    }

    private Annotation[] getPhysicalAnnotations() {
        return this.element.getAnnotations();
    }

    static {
        annotationToXml.put(Entity.class, "entity");
        annotationToXml.put(MappedSuperclass.class, "mapped-superclass");
        annotationToXml.put(Embeddable.class, "embeddable");
        annotationToXml.put(Table.class, "table");
        annotationToXml.put(SecondaryTable.class, "secondary-table");
        annotationToXml.put(SecondaryTables.class, "secondary-table");
        annotationToXml.put(PrimaryKeyJoinColumn.class, "primary-key-join-column");
        annotationToXml.put(PrimaryKeyJoinColumns.class, "primary-key-join-column");
        annotationToXml.put(IdClass.class, "id-class");
        annotationToXml.put(Inheritance.class, "inheritance");
        annotationToXml.put(DiscriminatorValue.class, "discriminator-value");
        annotationToXml.put(DiscriminatorColumn.class, "discriminator-column");
        annotationToXml.put(SequenceGenerator.class, "sequence-generator");
        annotationToXml.put(TableGenerator.class, "table-generator");
        annotationToXml.put(NamedEntityGraph.class, "named-entity-graph");
        annotationToXml.put(NamedEntityGraphs.class, "named-entity-graph");
        annotationToXml.put(NamedQuery.class, "named-query");
        annotationToXml.put(NamedQueries.class, "named-query");
        annotationToXml.put(NamedNativeQuery.class, "named-native-query");
        annotationToXml.put(NamedNativeQueries.class, "named-native-query");
        annotationToXml.put(NamedStoredProcedureQuery.class, "named-stored-procedure-query");
        annotationToXml.put(NamedStoredProcedureQueries.class, "named-stored-procedure-query");
        annotationToXml.put(SqlResultSetMapping.class, "sql-result-set-mapping");
        annotationToXml.put(SqlResultSetMappings.class, "sql-result-set-mapping");
        annotationToXml.put(ExcludeDefaultListeners.class, "exclude-default-listeners");
        annotationToXml.put(ExcludeSuperclassListeners.class, "exclude-superclass-listeners");
        annotationToXml.put(AttributeOverride.class, "attribute-override");
        annotationToXml.put(AttributeOverrides.class, "attribute-override");
        annotationToXml.put(AttributeOverride.class, "association-override");
        annotationToXml.put(AttributeOverrides.class, "association-override");
        annotationToXml.put(AttributeOverride.class, "map-key-attribute-override");
        annotationToXml.put(AttributeOverrides.class, "map-key-attribute-override");
        annotationToXml.put(Id.class, "id");
        annotationToXml.put(EmbeddedId.class, "embedded-id");
        annotationToXml.put(GeneratedValue.class, "generated-value");
        annotationToXml.put(Column.class, "column");
        annotationToXml.put(Columns.class, "column");
        annotationToXml.put(Temporal.class, "temporal");
        annotationToXml.put(Lob.class, "lob");
        annotationToXml.put(Enumerated.class, "enumerated");
        annotationToXml.put(Version.class, "version");
        annotationToXml.put(Transient.class, "transient");
        annotationToXml.put(Basic.class, "basic");
        annotationToXml.put(Embedded.class, "embedded");
        annotationToXml.put(ManyToOne.class, "many-to-one");
        annotationToXml.put(OneToOne.class, "one-to-one");
        annotationToXml.put(OneToMany.class, "one-to-many");
        annotationToXml.put(ManyToMany.class, "many-to-many");
        annotationToXml.put(Any.class, "any");
        annotationToXml.put(ManyToAny.class, "many-to-any");
        annotationToXml.put(JoinTable.class, "join-table");
        annotationToXml.put(JoinColumn.class, "join-column");
        annotationToXml.put(JoinColumns.class, "join-column");
        annotationToXml.put(MapKey.class, "map-key");
        annotationToXml.put(OrderBy.class, "order-by");
        annotationToXml.put(EntityListeners.class, "entity-listeners");
        annotationToXml.put(PrePersist.class, "pre-persist");
        annotationToXml.put(PreRemove.class, "pre-remove");
        annotationToXml.put(PreUpdate.class, "pre-update");
        annotationToXml.put(PostPersist.class, "post-persist");
        annotationToXml.put(PostRemove.class, "post-remove");
        annotationToXml.put(PostUpdate.class, "post-update");
        annotationToXml.put(PostLoad.class, "post-load");
        annotationToXml.put(CollectionTable.class, "collection-table");
        annotationToXml.put(MapKeyClass.class, "map-key-class");
        annotationToXml.put(MapKeyTemporal.class, "map-key-temporal");
        annotationToXml.put(MapKeyEnumerated.class, "map-key-enumerated");
        annotationToXml.put(MapKeyColumn.class, "map-key-column");
        annotationToXml.put(MapKeyJoinColumn.class, "map-key-join-column");
        annotationToXml.put(MapKeyJoinColumns.class, "map-key-join-column");
        annotationToXml.put(OrderColumn.class, "order-column");
        annotationToXml.put(Cacheable.class, "cacheable");
        annotationToXml.put(Index.class, "index");
        annotationToXml.put(ForeignKey.class, "foreign-key");
        annotationToXml.put(Convert.class, "convert");
        annotationToXml.put(Converts.class, "convert");
        annotationToXml.put(ConstructorResult.class, "constructor-result");
        annotationToXml.put(Type.class, "type");
        annotationToXml.put(JdbcTypeCode.class, "jdbc-type-code");
        annotationToXml.put(UuidGenerator.class, "uuid-generator");
    }

    private static enum PropertyType {
        PROPERTY,
        FIELD,
        METHOD;

    }
}

