/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import jakarta.persistence.criteria.Expression;
import java.util.Arrays;
import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class InsertSubstringOverlayEmulation
extends AbstractSqmFunctionDescriptor {
    private final boolean strictSubstring;

    public InsertSubstringOverlayEmulation(TypeConfiguration typeConfiguration, boolean strictSubstring) {
        super("overlay", new ArgumentTypesValidator(StandardArgumentsValidators.between(3, 4), FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER));
        this.strictSubstring = strictSubstring;
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        TypeConfiguration typeConfiguration = queryEngine.getTypeConfiguration();
        BasicType<Integer> intType = typeConfiguration.getBasicTypeForJavaType(Integer.class);
        BasicType<String> stringType = typeConfiguration.getBasicTypeForJavaType(String.class);
        SqmTypedNode<?> string = arguments.get(0);
        SqmTypedNode<?> replacement = arguments.get(1);
        SqmTypedNode<?> start = arguments.get(2);
        SqmTypedNode<?> length = arguments.size() > 3 ? arguments.get(3) : queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("length").generateSqmExpression(replacement, intType, queryEngine);
        SqmFunctionDescriptor insert = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("insert");
        if (insert != null) {
            return insert.generateSqmExpression(Arrays.asList(string, start, length, replacement), impliedResultType, queryEngine);
        }
        SqmFunctionDescriptor lengthFunction = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("length");
        SqmFunctionDescriptor substring = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("substring");
        SqmFunctionDescriptor concat = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("concat");
        SqmLiteral<Integer> one = new SqmLiteral<Integer>(1, intType, queryEngine.getCriteriaBuilder());
        SqmBinaryArithmetic<Integer> startPlusLength = new SqmBinaryArithmetic<Integer>(BinaryArithmeticOperator.ADD, (SqmExpression)start, (SqmExpression)length, intType, queryEngine.getCriteriaBuilder());
        SqmBinaryArithmetic<Integer> startMinusOne = new SqmBinaryArithmetic<Integer>(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)start, one, intType, queryEngine.getCriteriaBuilder());
        JpaExpression<T> restString = substring.generateSqmExpression(Arrays.asList(string, startPlusLength), impliedResultType, queryEngine);
        if (this.strictSubstring) {
            restString = new SqmCaseSearched<String>((SqmExpressible<String>)stringType, start.nodeBuilder()).when(new SqmComparisonPredicate(startPlusLength, ComparisonOperator.GREATER_THAN, lengthFunction.generateSqmExpression(Arrays.asList(string), intType, queryEngine), string.nodeBuilder()), (SqmExpression<String>)new SqmLiteral<String>("", stringType, string.nodeBuilder())).otherwise((Expression)restString);
        }
        return concat.generateSqmExpression(Arrays.asList(substring.generateSqmExpression(Arrays.asList(string, one, startMinusOne), impliedResultType, queryEngine), replacement, restString), impliedResultType, queryEngine);
    }

    @Override
    public String getArgumentListSignature() {
        return "(STRING string placing STRING replacement from INTEGER start[ for INTEGER length])";
    }
}

