/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch;

import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.jdbc.batch", description="Logging related to JDBC batch execution")
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=100501, max=101000)
public interface JdbcBatchLogging
extends BasicLogger {
    public static final String NAME = "org.hibernate.orm.jdbc.batch";
    public static final Logger BATCH_LOGGER = Logger.getLogger("org.hibernate.orm.jdbc.batch");
    public static final JdbcBatchLogging BATCH_MESSAGE_LOGGER = Logger.getMessageLogger(JdbcBatchLogging.class, "org.hibernate.orm.jdbc.batch");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=100501, value="Exception executing batch [%s], SQL: %s")
    public void unableToExecuteBatch(Exception var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=100502, value="Unable to release batch statement...")
    public void unableToReleaseBatchStatement();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=100503, value="On release of batch it still contained JDBC statements")
    public void batchContainedStatementsOnRelease();
}

