/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.boot", description="Logging related to ")
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=10010001, max=10010050)
public interface LobCreationLogging
extends BasicLogger {
    public static final String NAME = "org.hibernate.orm.jdbc.lob";
    public static final Logger LOB_LOGGER = Logger.getLogger("org.hibernate.orm.jdbc.lob");
    public static final LobCreationLogging LOB_MESSAGE_LOGGER = Logger.getMessageLogger(LobCreationLogging.class, "org.hibernate.orm.jdbc.lob");

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Disabling contextual LOB creation as %s is true", id=10010001)
    public void disablingContextualLOBCreation(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Disabling contextual LOB creation as connection was null", id=10010002)
    public void disablingContextualLOBCreationSinceConnectionNull();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Disabling contextual LOB creation as JDBC driver reported JDBC version [%s] less than 4", id=10010003)
    public void nonContextualLobCreationJdbcVersion(int var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Disabling contextual LOB creation as Dialect reported it is not supported", id=10010004)
    public void nonContextualLobCreationDialect();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Disabling contextual LOB creation as createClob() method threw error : %s", id=10010005)
    public void contextualClobCreationFailed(Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Disabling contextual NCLOB creation as createNClob() method threw error : %s", id=10010006)
    public void contextualNClobCreationFailed(Throwable var1);
}

