/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Arrays;
import org.hibernate.AssertionFailure;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.HibernateException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.action.internal.EntityUpdateAction;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.DirtyCollectionSearchVisitor;
import org.hibernate.event.internal.FlushVisitor;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEntityEvent;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.event.spi.HibernateMonitoringEvent;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;

public class DefaultFlushEntityEventListener
implements FlushEntityEventListener,
CallbackRegistryConsumer {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultFlushEntityEventListener.class);
    private CallbackRegistry callbackRegistry;

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public void checkId(Object object, EntityPersister persister, Object id, SessionImplementor session) throws HibernateException {
        if (id instanceof DelayedPostInsertIdentifier) {
            return;
        }
        Object oid = persister.getIdentifier(object, session);
        if (id == null) {
            throw new AssertionFailure("null id in " + persister.getEntityName() + " entry (don't flush the Session after an exception occurs)");
        }
        if (id == oid) {
            return;
        }
        if (!persister.getIdentifierType().isEqual(id, oid, (SessionFactoryImplementor)session.getFactory())) {
            throw new HibernateException("identifier of an instance of " + persister.getEntityName() + " was altered from " + oid + " to " + id);
        }
    }

    private void checkNaturalId(EntityPersister persister, Object entity, EntityEntry entry, Object[] current, Object[] loaded, SessionImplementor session) {
        NaturalIdMapping naturalIdMapping;
        if (!DefaultFlushEntityEventListener.isUninitializedEnhanced(entity) && (naturalIdMapping = persister.getNaturalIdMapping()) != null && entry.getStatus() != Status.READ_ONLY) {
            naturalIdMapping.verifyFlushState(entry.getId(), current, loaded, session);
        }
    }

    private static boolean isUninitializedEnhanced(Object entity) {
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(entity)) {
            PersistentAttributeInterceptor interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(entity).$$_hibernate_getInterceptor();
            return interceptor instanceof EnhancementAsProxyLazinessInterceptor;
        }
        return false;
    }

    @Override
    public void onFlushEntity(FlushEntityEvent event) throws HibernateException {
        Object entity = event.getEntity();
        EntityEntry entry = event.getEntityEntry();
        EventSource session = event.getSession();
        boolean mightBeDirty = entry.requiresDirtyCheck(entity);
        Object[] values = this.getValues(entity, entry, mightBeDirty, session);
        event.setPropertyValues(values);
        boolean substitute = this.wrapCollections(event, values);
        if (this.isUpdateNecessary(event, mightBeDirty)) {
            boolean bl = substitute = this.scheduleUpdate(event) || substitute;
        }
        if (entry.getStatus() != Status.DELETED) {
            EntityPersister persister = entry.getPersister();
            if (substitute) {
                persister.setPropertyValues(entity, values);
            }
            if (persister.hasCollections()) {
                new FlushVisitor(session, entity).processEntityPropertyValues(values, persister.getPropertyTypes());
            }
        }
    }

    private Object[] getValues(Object entity, EntityEntry entry, boolean mightBeDirty, SessionImplementor session) {
        Object[] loadedState = entry.getLoadedState();
        if (entry.getStatus() == Status.DELETED) {
            return entry.getDeletedState();
        }
        if (!mightBeDirty && loadedState != null) {
            return loadedState;
        }
        EntityPersister persister = entry.getPersister();
        this.checkId(entity, persister, entry.getId(), session);
        Object[] values = persister.getValues(entity);
        this.checkNaturalId(persister, entity, entry, values, loadedState, session);
        return values;
    }

    private boolean wrapCollections(FlushEntityEvent event, Object[] values) {
        EntityEntry entry = event.getEntityEntry();
        EntityPersister persister = entry.getPersister();
        if (persister.hasCollections()) {
            WrapVisitor visitor = new WrapVisitor(event.getEntity(), entry.getId(), event.getSession());
            visitor.processEntityPropertyValues(values, persister.getPropertyTypes());
            return visitor.isSubstitutionRequired();
        }
        return false;
    }

    private boolean isUpdateNecessary(FlushEntityEvent event, boolean mightBeDirty) {
        EntityEntry entry = event.getEntityEntry();
        if (mightBeDirty || entry.getStatus() == Status.DELETED) {
            this.dirtyCheck(event);
            if (this.isUpdateNecessary(event)) {
                return true;
            }
            Object entity = event.getEntity();
            ManagedTypeHelper.processIfSelfDirtinessTracker(entity, SelfDirtinessTracker::$$_hibernate_clearDirtyAttributes);
            EventSource source = event.getSession();
            source.getFactory().getCustomEntityDirtinessStrategy().resetDirty(entity, entry.getPersister(), source);
            return false;
        }
        return this.hasDirtyCollections(event);
    }

    private boolean scheduleUpdate(FlushEntityEvent event) {
        EntityEntry entry = event.getEntityEntry();
        EventSource session = event.getSession();
        Object entity = event.getEntity();
        Status status = entry.getStatus();
        EntityPersister persister = entry.getPersister();
        Object[] values = event.getPropertyValues();
        DefaultFlushEntityEventListener.logScheduleUpdate(entry, session, status, persister);
        boolean intercepted = !entry.isBeingReplicated() && this.handleInterception(event);
        Object nextVersion = this.getNextVersion(event);
        int[] dirtyProperties = DefaultFlushEntityEventListener.getDirtyProperties(event, intercepted);
        new Nullability(session).checkNullability(values, persister, true);
        session.getActionQueue().addAction(new EntityUpdateAction(entry.getId(), values, dirtyProperties, event.hasDirtyCollection(), status == Status.DELETED && !entry.isModifiableEntity() ? persister.getValues(entity) : entry.getLoadedState(), entry.getVersion(), nextVersion, entity, entry.getRowId(), persister, session));
        return intercepted;
    }

    private static int[] getDirtyProperties(FlushEntityEvent event, boolean intercepted) {
        int[] dirtyProperties = event.getDirtyProperties();
        if (event.isDirtyCheckPossible() && dirtyProperties == null) {
            if (!intercepted && !event.hasDirtyCollection()) {
                throw new AssertionFailure("dirty, but no dirty properties");
            }
            return ArrayHelper.EMPTY_INT_ARRAY;
        }
        return dirtyProperties;
    }

    private static void logScheduleUpdate(EntityEntry entry, EventSource session, Status status, EntityPersister persister) {
        if (LOG.isTraceEnabled()) {
            if (status == Status.DELETED) {
                if (!persister.isMutable()) {
                    LOG.tracev("Updating immutable, deleted entity: {0}", (Object)MessageHelper.infoString(persister, entry.getId(), (SessionFactoryImplementor)session.getFactory()));
                } else if (!entry.isModifiableEntity()) {
                    LOG.tracev("Updating non-modifiable, deleted entity: {0}", (Object)MessageHelper.infoString(persister, entry.getId(), (SessionFactoryImplementor)session.getFactory()));
                } else {
                    LOG.tracev("Updating deleted entity: {0}", (Object)MessageHelper.infoString(persister, entry.getId(), (SessionFactoryImplementor)session.getFactory()));
                }
            } else {
                LOG.tracev("Updating entity: {0}", (Object)MessageHelper.infoString(persister, entry.getId(), (SessionFactoryImplementor)session.getFactory()));
            }
        }
    }

    protected boolean handleInterception(FlushEntityEvent event) {
        boolean intercepted = this.invokeInterceptor(event);
        if (intercepted && event.isDirtyCheckPossible()) {
            this.dirtyCheck(event);
        }
        return intercepted;
    }

    protected boolean invokeInterceptor(FlushEntityEvent event) {
        boolean stateModified;
        EntityEntry entry = event.getEntityEntry();
        Object entity = event.getEntity();
        Object id = entry.getId();
        Object[] values = event.getPropertyValues();
        EntityPersister persister = entry.getPersister();
        EventSource session = event.getSession();
        boolean isDirty = false;
        if (entry.getStatus() != Status.DELETED && this.callbackRegistry.preUpdate(entity)) {
            isDirty = this.copyState(entity, persister.getPropertyTypes(), values, (SessionFactoryImplementor)session.getFactory());
        }
        return (stateModified = session.getInterceptor().onFlushDirty(entity, id, values, entry.getLoadedState(), persister.getPropertyNames(), persister.getPropertyTypes())) || isDirty;
    }

    private boolean copyState(Object entity, Type[] types, Object[] state, SessionFactoryImplementor factory) {
        Object[] newState = DefaultFlushEntityEventListener.currentState(entity, factory);
        boolean isDirty = false;
        int size = newState.length;
        for (int index = 0; index < size; ++index) {
            if (!DefaultFlushEntityEventListener.isDirty(types[index], state[index], newState[index])) continue;
            isDirty = true;
            state[index] = newState[index];
        }
        return isDirty;
    }

    private static Object[] currentState(Object entity, SessionFactoryImplementor factory) {
        return factory.getRuntimeMetamodels().getEntityMappingType(entity.getClass()).getEntityPersister().getValues(entity);
    }

    private static boolean isDirty(Type types, Object state, Object newState) {
        return state == LazyPropertyInitializer.UNFETCHED_PROPERTY && newState != LazyPropertyInitializer.UNFETCHED_PROPERTY || state != newState && !types.isEqual(state, newState);
    }

    private Object getNextVersion(FlushEntityEvent event) throws HibernateException {
        EntityEntry entry = event.getEntityEntry();
        EntityPersister persister = entry.getPersister();
        if (persister.isVersioned()) {
            Object[] values = event.getPropertyValues();
            if (entry.isBeingReplicated()) {
                return Versioning.getVersion(values, persister);
            }
            Object nextVersion = DefaultFlushEntityEventListener.isVersionIncrementRequired(event, entry) ? Versioning.incrementVersion(event.getEntity(), entry.getVersion(), persister, event.getSession()) : entry.getVersion();
            Versioning.setVersion(values, nextVersion, persister);
            return nextVersion;
        }
        return null;
    }

    private static boolean isVersionIncrementRequired(FlushEntityEvent event, EntityEntry entry) {
        if (entry.getStatus() == Status.DELETED) {
            return false;
        }
        int[] dirtyProperties = event.getDirtyProperties();
        return dirtyProperties == null || Versioning.isVersionIncrementRequired(dirtyProperties, event.hasDirtyCollection(), event.getEntityEntry().getPersister().getPropertyVersionability());
    }

    protected final boolean isUpdateNecessary(FlushEntityEvent event) throws HibernateException {
        return !event.isDirtyCheckPossible() || event.hasDirtyProperties() || this.hasDirtyCollections(event);
    }

    private boolean hasDirtyCollections(FlushEntityEvent event) {
        EntityEntry entityEntry = event.getEntityEntry();
        EntityPersister persister = entityEntry.getPersister();
        if (this.isCollectionDirtyCheckNecessary(persister, entityEntry.getStatus())) {
            DirtyCollectionSearchVisitor visitor = new DirtyCollectionSearchVisitor(event.getEntity(), event.getSession(), persister.getPropertyVersionability());
            visitor.processEntityPropertyValues(event.getPropertyValues(), persister.getPropertyTypes());
            boolean hasDirtyCollections = visitor.wasDirtyCollectionFound();
            event.setHasDirtyCollection(hasDirtyCollections);
            return hasDirtyCollections;
        }
        return false;
    }

    private boolean isCollectionDirtyCheckNecessary(EntityPersister persister, Status status) {
        return (status == Status.MANAGED || status == Status.READ_ONLY) && persister.isVersioned() && persister.hasCollections();
    }

    protected void dirtyCheck(FlushEntityEvent event) throws HibernateException {
        int[] dirtyProperties = DefaultFlushEntityEventListener.getDirtyProperties(event);
        event.setDatabaseSnapshot(null);
        if (dirtyProperties == null) {
            dirtyProperties = DefaultFlushEntityEventListener.performDirtyCheck(event);
        } else {
            event.setDirtyProperties(dirtyProperties);
            event.setDirtyCheckHandledByInterceptor(true);
            event.setDirtyCheckPossible(true);
        }
        this.logDirtyProperties(event.getEntityEntry(), dirtyProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] performDirtyCheck(FlushEntityEvent event) {
        EventSource session = event.getSession();
        int[] dirtyProperties = null;
        EventManager eventManager = session.getEventManager();
        HibernateMonitoringEvent dirtyCalculationEvent = eventManager.beginDirtyCalculationEvent();
        EntityEntry entry = event.getEntityEntry();
        EntityPersister persister = entry.getPersister();
        try {
            boolean dirtyCheckPossible;
            session.getEventListenerManager().dirtyCalculationStart();
            Object[] values = event.getPropertyValues();
            Object[] loadedState = entry.getLoadedState();
            Object entity = event.getEntity();
            if (loadedState != null) {
                dirtyProperties = persister.findDirty(values, loadedState, entity, session);
                dirtyCheckPossible = true;
            } else if (entry.getStatus() == Status.DELETED && !entry.isModifiableEntity()) {
                if (values != entry.getDeletedState()) {
                    throw new IllegalStateException("Entity has status Status.DELETED but values != entry.getDeletedState");
                }
                Object[] currentState = persister.getValues(event.getEntity());
                dirtyProperties = persister.findDirty(entry.getDeletedState(), currentState, entity, session);
                dirtyCheckPossible = true;
            } else {
                Object[] databaseSnapshot = DefaultFlushEntityEventListener.getDatabaseSnapshot(persister, entry.getId(), session);
                if (databaseSnapshot != null) {
                    dirtyProperties = persister.findModified(databaseSnapshot, values, entity, session);
                    dirtyCheckPossible = true;
                    event.setDatabaseSnapshot(databaseSnapshot);
                } else {
                    dirtyCheckPossible = false;
                }
            }
            event.setDirtyProperties(dirtyProperties);
            event.setDirtyCheckHandledByInterceptor(false);
            event.setDirtyCheckPossible(dirtyCheckPossible);
            eventManager.completeDirtyCalculationEvent(dirtyCalculationEvent, session, persister, entry, dirtyProperties);
        }
        catch (Throwable throwable) {
            eventManager.completeDirtyCalculationEvent(dirtyCalculationEvent, session, persister, entry, dirtyProperties);
            session.getEventListenerManager().dirtyCalculationEnd(dirtyProperties != null);
            throw throwable;
        }
        session.getEventListenerManager().dirtyCalculationEnd(dirtyProperties != null);
        return dirtyProperties;
    }

    private static int[] getDirtyProperties(FlushEntityEvent event) {
        int[] dirtyProperties = DefaultFlushEntityEventListener.getDirtyPropertiesFromInterceptor(event);
        if (dirtyProperties != null) {
            return dirtyProperties;
        }
        Object entity = event.getEntity();
        return ManagedTypeHelper.isSelfDirtinessTracker(entity) ? DefaultFlushEntityEventListener.getDirtyPropertiesFromSelfDirtinessTracker(ManagedTypeHelper.asSelfDirtinessTracker(entity), event) : DefaultFlushEntityEventListener.getDirtyPropertiesFromCustomEntityDirtinessStrategy(event);
    }

    private static int[] getDirtyPropertiesFromInterceptor(FlushEntityEvent event) {
        EntityEntry entry = event.getEntityEntry();
        EntityPersister persister = entry.getPersister();
        return event.getSession().getInterceptor().findDirty(event.getEntity(), entry.getId(), event.getPropertyValues(), entry.getLoadedState(), persister.getPropertyNames(), persister.getPropertyTypes());
    }

    private static int[] getDirtyPropertiesFromCustomEntityDirtinessStrategy(FlushEntityEvent event) {
        EventSource session = event.getSession();
        class DirtyCheckContextImpl
        implements CustomEntityDirtinessStrategy.DirtyCheckContext {
            private int[] found;
            final /* synthetic */ FlushEntityEvent val$event;

            DirtyCheckContextImpl(FlushEntityEvent flushEntityEvent) {
                this.val$event = flushEntityEvent;
            }

            @Override
            public void doDirtyChecking(CustomEntityDirtinessStrategy.AttributeChecker attributeChecker) {
                this.found = new DirtyCheckAttributeInfoImpl(this.val$event).visitAttributes(attributeChecker);
                if (this.found.length == 0) {
                    this.found = null;
                }
            }
        }
        DirtyCheckContextImpl context = new DirtyCheckContextImpl(event);
        session.getFactory().getCustomEntityDirtinessStrategy().findDirty(event.getEntity(), event.getEntityEntry().getPersister(), session, context);
        return context.found;
    }

    private static int[] getDirtyPropertiesFromSelfDirtinessTracker(SelfDirtinessTracker tracker, FlushEntityEvent event) {
        EntityEntry entry = event.getEntityEntry();
        EntityPersister persister = entry.getPersister();
        if (tracker.$$_hibernate_hasDirtyAttributes() || persister.hasMutableProperties()) {
            return persister.resolveDirtyAttributeIndexes(event.getPropertyValues(), entry.getLoadedState(), tracker.$$_hibernate_getDirtyAttributes(), event.getSession());
        }
        return ArrayHelper.EMPTY_INT_ARRAY;
    }

    private void logDirtyProperties(EntityEntry entry, int[] dirtyProperties) {
        if (dirtyProperties != null && dirtyProperties.length > 0 && LOG.isTraceEnabled()) {
            EntityPersister persister = entry.getPersister();
            String[] allPropertyNames = persister.getPropertyNames();
            Object[] dirtyPropertyNames = new String[dirtyProperties.length];
            for (int i = 0; i < dirtyProperties.length; ++i) {
                dirtyPropertyNames[i] = allPropertyNames[dirtyProperties[i]];
            }
            LOG.tracev("Found dirty properties [{0}] : {1}", (Object)MessageHelper.infoString(persister.getEntityName(), entry.getId()), (Object)Arrays.toString(dirtyPropertyNames));
        }
    }

    private static Object[] getDatabaseSnapshot(EntityPersister persister, Object id, SessionImplementor session) {
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        if (persister.isSelectBeforeUpdateRequired()) {
            Object[] snapshot = persistenceContext.getDatabaseSnapshot(id, persister);
            if (snapshot == null) {
                StatisticsImplementor statistics = session.getFactory().getStatistics();
                if (statistics.isStatisticsEnabled()) {
                    statistics.optimisticFailure(persister.getEntityName());
                }
                throw new StaleObjectStateException(persister.getEntityName(), id);
            }
            return snapshot;
        }
        return persistenceContext.getCachedDatabaseSnapshot(session.generateEntityKey(id, persister));
    }

    private static class DirtyCheckAttributeInfoImpl
    implements CustomEntityDirtinessStrategy.AttributeInformation {
        private final FlushEntityEvent event;
        private final EntityPersister persister;
        private final int numberOfAttributes;
        private int index;
        Object[] databaseSnapshot;

        private DirtyCheckAttributeInfoImpl(FlushEntityEvent event) {
            this.event = event;
            this.persister = event.getEntityEntry().getPersister();
            this.numberOfAttributes = this.persister.getPropertyNames().length;
        }

        @Override
        public EntityPersister getContainingPersister() {
            return this.persister;
        }

        @Override
        public int getAttributeIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.persister.getPropertyNames()[this.index];
        }

        @Override
        public Type getType() {
            return this.persister.getPropertyTypes()[this.index];
        }

        @Override
        public Object getCurrentValue() {
            return this.event.getPropertyValues()[this.index];
        }

        @Override
        public Object getLoadedValue() {
            if (this.databaseSnapshot == null) {
                this.databaseSnapshot = DefaultFlushEntityEventListener.getDatabaseSnapshot(this.persister, this.event.getEntityEntry().getId(), this.event.getSession());
            }
            return this.databaseSnapshot[this.index];
        }

        public int[] visitAttributes(CustomEntityDirtinessStrategy.AttributeChecker attributeChecker) {
            this.databaseSnapshot = null;
            int[] indexes = new int[this.numberOfAttributes];
            int count = 0;
            this.index = 0;
            while (this.index < this.numberOfAttributes) {
                if (attributeChecker.isDirty(this)) {
                    indexes[count++] = this.index;
                }
                ++this.index;
            }
            return Arrays.copyOf(indexes, count);
        }
    }
}

