/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.factory.internal;

import jakarta.persistence.GenerationType;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.generator.Generator;
import org.hibernate.id.Assigned;
import org.hibernate.id.Configurable;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.IncrementGenerator;
import org.hibernate.id.SelectGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.id.factory.IdGenFactoryLogging;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.internal.AutoGenerationTypeStrategy;
import org.hibernate.id.factory.internal.IdentityGenerationTypeStrategy;
import org.hibernate.id.factory.internal.SequenceGenerationTypeStrategy;
import org.hibernate.id.factory.internal.TableGenerationTypeStrategy;
import org.hibernate.id.factory.internal.UUIDGenerationTypeStrategy;
import org.hibernate.id.factory.spi.GenerationTypeStrategy;
import org.hibernate.id.factory.spi.GenerationTypeStrategyRegistration;
import org.hibernate.id.factory.spi.GeneratorDefinitionResolver;
import org.hibernate.id.factory.spi.StandardGenerator;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.jpa.spi.IdentifierGeneratorStrategyProvider;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.internal.Helper;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;

public class StandardIdentifierGeneratorFactory
implements IdentifierGeneratorFactory,
BeanContainer.LifecycleOptions,
Serializable {
    private final ConcurrentHashMap<GenerationType, GenerationTypeStrategy> generatorTypeStrategyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<? extends Generator>> legacyGeneratorClassNameMap = new ConcurrentHashMap();
    private final ServiceRegistry serviceRegistry;
    private final BeanContainer beanContainer;
    private Dialect dialect;

    public StandardIdentifierGeneratorFactory(ServiceRegistry serviceRegistry) {
        this(serviceRegistry, !Helper.allowExtensionsInCdi(serviceRegistry));
    }

    public StandardIdentifierGeneratorFactory(ServiceRegistry serviceRegistry, boolean ignoreBeanContainer) {
        this.serviceRegistry = serviceRegistry;
        this.beanContainer = StandardIdentifierGeneratorFactory.getBeanContainer(serviceRegistry, ignoreBeanContainer);
        this.registerJpaGenerators();
        this.logOverrides();
        this.registerPredefinedGenerators();
        this.registerUsingLegacyContributor();
    }

    private static BeanContainer getBeanContainer(ServiceRegistry serviceRegistry, boolean ignoreBeanContainer) {
        if (ignoreBeanContainer) {
            IdGenFactoryLogging.ID_GEN_FAC_LOGGER.debug("Ignoring CDI for resolving IdentifierGenerator instances as extended or delayed CDI support was enabled");
            return null;
        }
        BeanContainer beanContainer = serviceRegistry.getService(ManagedBeanRegistry.class).getBeanContainer();
        if (beanContainer == null) {
            IdGenFactoryLogging.ID_GEN_FAC_LOGGER.debug("Resolving IdentifierGenerator instances will not use CDI as it was not configured");
        }
        return beanContainer;
    }

    private void registerJpaGenerators() {
        this.generatorTypeStrategyMap.put(GenerationType.AUTO, AutoGenerationTypeStrategy.INSTANCE);
        this.generatorTypeStrategyMap.put(GenerationType.SEQUENCE, SequenceGenerationTypeStrategy.INSTANCE);
        this.generatorTypeStrategyMap.put(GenerationType.TABLE, TableGenerationTypeStrategy.INSTANCE);
        this.generatorTypeStrategyMap.put(GenerationType.IDENTITY, IdentityGenerationTypeStrategy.INSTANCE);
        this.generatorTypeStrategyMap.put(GenerationType.UUID, UUIDGenerationTypeStrategy.INSTANCE);
    }

    private void logOverrides() {
        this.serviceRegistry.getService(ClassLoaderService.class).loadJavaServices(GenerationTypeStrategyRegistration.class).forEach(registration -> registration.registerStrategies((generationType, generationTypeStrategy) -> {
            GenerationTypeStrategy previous = this.generatorTypeStrategyMap.put((GenerationType)((Object)((Object)generationType)), (GenerationTypeStrategy)generationTypeStrategy);
            if (previous != null) {
                IdGenFactoryLogging.ID_GEN_FAC_LOGGER.debugf("GenerationTypeStrategyRegistration [%s] overrode previous registration for GenerationType#%s : %s", registration, (Object)generationType.name(), (Object)previous);
            }
        }, this.serviceRegistry));
    }

    private void registerPredefinedGenerators() {
        this.register("uuid2", UUIDGenerator.class);
        this.register("guid", GUIDGenerator.class);
        this.register("uuid", UUIDHexGenerator.class);
        this.register("uuid.hex", UUIDHexGenerator.class);
        this.register("assigned", Assigned.class);
        this.register("identity", IdentityGenerator.class);
        this.register("select", SelectGenerator.class);
        this.register("sequence", SequenceStyleGenerator.class);
        this.register("increment", IncrementGenerator.class);
        this.register("foreign", ForeignGenerator.class);
        this.register("enhanced-sequence", SequenceStyleGenerator.class);
        this.register("enhanced-table", TableGenerator.class);
    }

    private void registerUsingLegacyContributor() {
        ConfigurationService configService = this.serviceRegistry.getService(ConfigurationService.class);
        Object providerSetting = configService.getSettings().get("hibernate.identifier_generator_strategy_provider");
        if (providerSetting != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting2("hibernate.identifier_generator_strategy_provider", "supply a org.hibernate.id.factory.spi.GenerationTypeStrategyRegistration Java service");
            IdentifierGeneratorStrategyProvider idGeneratorStrategyProvider = this.serviceRegistry.getService(StrategySelector.class).resolveStrategy(IdentifierGeneratorStrategyProvider.class, providerSetting);
            for (Map.Entry<String, Class<?>> entry : idGeneratorStrategyProvider.getStrategies().entrySet()) {
                Class<?> generatorClass = entry.getValue();
                this.register(entry.getKey(), generatorClass);
            }
        }
    }

    private void register(String strategy, Class<? extends Generator> generatorClass) {
        IdGenFactoryLogging.ID_GEN_FAC_LOGGER.debugf("Registering IdentifierGenerator strategy [%s] -> [%s]", (Object)strategy, (Object)generatorClass.getName());
        Class<? extends Generator> previous = this.legacyGeneratorClassNameMap.put(strategy, generatorClass);
        if (previous != null && IdGenFactoryLogging.ID_GEN_FAC_LOGGER.isDebugEnabled()) {
            IdGenFactoryLogging.ID_GEN_FAC_LOGGER.debugf("    - overriding [%s]", (Object)previous.getName());
        }
    }

    @Override
    public IdentifierGenerator createIdentifierGenerator(GenerationType generationType, String generatedValueGeneratorName, String generatorName, JavaType<?> javaType, Properties config, GeneratorDefinitionResolver definitionResolver) {
        GenerationTypeStrategy strategy = this.generatorTypeStrategyMap.get((Object)generationType);
        if (strategy != null) {
            return strategy.createIdentifierGenerator(generationType, generatorName, javaType, config, definitionResolver, this.serviceRegistry);
        }
        throw new UnsupportedOperationException("No GenerationTypeStrategy specified");
    }

    @Override
    @Deprecated
    public Dialect getDialect() {
        if (this.dialect == null) {
            this.dialect = this.serviceRegistry.getService(JdbcEnvironment.class).getDialect();
        }
        return this.dialect;
    }

    @Override
    public Generator createIdentifierGenerator(String strategy, Type type, Properties parameters) {
        try {
            Class<? extends Generator> clazz = this.getIdentifierGeneratorClass(strategy);
            Generator identifierGenerator = this.beanContainer == null || StandardGenerator.class.isAssignableFrom(clazz) || this.legacyGeneratorClassNameMap.containsKey(strategy) ? clazz.newInstance() : this.beanContainer.getBean(clazz, this, FallbackBeanInstanceProducer.INSTANCE).getBeanInstance();
            if (identifierGenerator instanceof Configurable) {
                ((Configurable)((Object)identifierGenerator)).configure(type, parameters, this.serviceRegistry);
            }
            return identifierGenerator;
        }
        catch (Exception e) {
            String entityName = parameters.getProperty("entity_name");
            throw new MappingException(String.format("Could not instantiate id generator [entity-name=%s]", entityName), e);
        }
    }

    @Override
    public boolean canUseCachedReferences() {
        return false;
    }

    @Override
    public boolean useJpaCompliantCreation() {
        return true;
    }

    @Override
    public Class<? extends Generator> getIdentifierGeneratorClass(String strategy) {
        switch (strategy) {
            case "hilo": {
                throw new UnsupportedOperationException("Support for 'hilo' generator has been removed");
            }
            case "native": {
                strategy = this.getDialect().getNativeIdentifierGeneratorStrategy();
            }
        }
        Class<? extends Generator> generatorClass = this.legacyGeneratorClassNameMap.get(strategy);
        return generatorClass != null ? generatorClass : this.generatorClassForName(strategy);
    }

    protected Class<? extends Generator> generatorClassForName(String strategy) {
        try {
            Class clazz = this.serviceRegistry.getService(ClassLoaderService.class).classForName(strategy);
            if (!Generator.class.isAssignableFrom(clazz)) {
                throw new MappingException(clazz.getName() + " does not implement 'Generator'");
            }
            return clazz;
        }
        catch (ClassLoadingException e) {
            throw new MappingException(String.format("Could not interpret id generator strategy [%s]", strategy));
        }
    }
}

