/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.boot.BootLogging;
import org.hibernate.boot.model.internal.DelayedParameterizedTypeBean;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.mapping.MappingModelCreationLogging;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.resource.beans.spi.ProvidedInstanceManagedBeanImpl;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CustomCollectionType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MetaType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.SpecialOneToOneType;
import org.hibernate.type.Type;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserCollectionType;

@Internal
public final class MappingHelper {
    private static final Properties EMPTY_PROPERTIES = new Properties();

    private MappingHelper() {
    }

    public static CollectionType customCollection(String typeName, Properties typeParameters, String role, String propertyRef, MetadataImplementor metadata) {
        ManagedBean<UserCollectionType> userTypeBean;
        ClassLoaderService cls = metadata.getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
        Class userCollectionTypeClass = cls.classForName(typeName);
        boolean hasParameters = CollectionHelper.isNotEmpty(typeParameters);
        if (!metadata.getMetadataBuildingOptions().isAllowExtensionsInCdi()) {
            userTypeBean = MappingHelper.createLocalUserCollectionTypeBean(role, userCollectionTypeClass, hasParameters, typeParameters);
        } else {
            ManagedBeanRegistry beanRegistry = metadata.getMetadataBuildingOptions().getServiceRegistry().getService(ManagedBeanRegistry.class);
            ManagedBean userCollectionTypeBean = beanRegistry.getBean(userCollectionTypeClass);
            if (hasParameters) {
                if (ParameterizedType.class.isAssignableFrom(userCollectionTypeBean.getBeanClass())) {
                    Properties copy = new Properties();
                    copy.putAll((Map<?, ?>)typeParameters);
                    userTypeBean = new DelayedParameterizedTypeBean<UserCollectionType>(userCollectionTypeBean, copy);
                } else {
                    BootLogging.BOOT_LOGGER.debugf("`@CollectionType` (%s) specified parameters, but the implementation does not implement `%s` which is used to inject them - `%s`", (Object)role, (Object)ParameterizedType.class.getName(), (Object)userCollectionTypeClass.getName());
                    userTypeBean = userCollectionTypeBean;
                }
            } else {
                userTypeBean = userCollectionTypeBean;
            }
        }
        return new CustomCollectionType(userTypeBean, role, propertyRef);
    }

    public static void injectParameters(Object type, Properties parameters) {
        if (type instanceof ParameterizedType) {
            ((ParameterizedType)type).setParameterValues(parameters == null ? EMPTY_PROPERTIES : parameters);
        } else if (parameters != null && !parameters.isEmpty()) {
            MappingModelCreationLogging.MAPPING_MODEL_CREATION_MESSAGE_LOGGER.debugf("UserCollectionType impl does not implement ParameterizedType but parameters were present : `%s`", (Object)type.getClass().getName());
        }
    }

    public static void injectParameters(Object type, Supplier<Properties> parameterAccess) {
        MappingHelper.injectParameters(type, parameterAccess.get());
    }

    public static AnyType anyMapping(Type metaType, Type identifierType, Map<Object, String> metaValueToEntityNameMap, boolean lazy, MetadataBuildingContext buildingContext) {
        if (metaValueToEntityNameMap != null) {
            metaType = new MetaType(metaValueToEntityNameMap, metaType);
        }
        return new AnyType(buildingContext.getBootstrapContext().getTypeConfiguration(), metaType, identifierType, lazy);
    }

    public static ManyToOneType manyToOne(String referencedEntityName, boolean referenceToPrimaryKey, String referencedPropertyName, String propertyName, boolean isLogicalOneToOne, boolean lazy, boolean unwrapProxy, boolean ignoreNotFound, MetadataBuildingContext buildingContext) {
        return new ManyToOneType(buildingContext.getBootstrapContext().getTypeConfiguration(), referencedEntityName, referenceToPrimaryKey, referencedPropertyName, propertyName, lazy, unwrapProxy, ignoreNotFound, isLogicalOneToOne);
    }

    public static SpecialOneToOneType specialOneToOne(String referencedEntityName, ForeignKeyDirection foreignKeyType, boolean referenceToPrimaryKey, String referencedPropertyName, boolean lazy, boolean unwrapProxy, String owningEntityName, String owningEntityPropertyName, boolean constrained, MetadataBuildingContext buildingContext) {
        return new SpecialOneToOneType(buildingContext.getBootstrapContext().getTypeConfiguration(), referencedEntityName, foreignKeyType, referenceToPrimaryKey, referencedPropertyName, lazy, unwrapProxy, owningEntityName, owningEntityPropertyName, constrained);
    }

    public static OneToOneType oneToOne(String referencedEntityName, ForeignKeyDirection foreignKeyType, boolean referenceToPrimaryKey, String referencedPropertyName, boolean lazy, boolean unwrapProxy, String owningEntityName, String owningEntityPropertyName, boolean constrained, MetadataBuildingContext buildingContext) {
        return new OneToOneType(buildingContext.getBootstrapContext().getTypeConfiguration(), referencedEntityName, foreignKeyType, referenceToPrimaryKey, referencedPropertyName, lazy, unwrapProxy, owningEntityName, owningEntityPropertyName, constrained);
    }

    public static ManagedBean<UserCollectionType> createLocalUserCollectionTypeBean(String role, Class<? extends UserCollectionType> implementation, boolean hasParameters, Map<String, String> parameters) {
        UserCollectionType userCollectionType = FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(implementation);
        if (hasParameters) {
            if (userCollectionType instanceof ParameterizedType) {
                Properties properties = new Properties();
                properties.putAll(parameters);
                ((ParameterizedType)((Object)userCollectionType)).setParameterValues(properties);
            } else {
                BootLogging.BOOT_LOGGER.debugf("`@CollectionType` (%s) specified parameters, but the implementation does not implement `%s` which is used to inject them - `%s`", (Object)role, (Object)ParameterizedType.class.getName(), (Object)implementation.getName());
            }
        }
        return new ProvidedInstanceManagedBeanImpl<UserCollectionType>(userCollectionType);
    }

    public static void checkPropertyColumnDuplication(Set<String> distinctColumns, List<Property> properties, String owner) throws MappingException {
        for (Property prop : properties) {
            if (!prop.isUpdateable() && !prop.isInsertable()) continue;
            prop.getValue().checkColumnDuplication(distinctColumns, owner);
        }
    }
}

