/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EntityDiscriminatorSqmPath;
import org.hibernate.metamodel.model.domain.internal.PathHelper;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;

public class DiscriminatorSqmPathSource<D>
extends AbstractSqmPathSource<D>
implements ReturnableType<D> {
    private final EntityDomainType<?> entityDomainType;
    private final EntityMappingType entityMapping;

    public DiscriminatorSqmPathSource(DomainType<D> discriminatorValueType, EntityDomainType<?> entityDomainType, EntityMappingType entityMapping) {
        super("{discriminator}", null, discriminatorValueType, Bindable.BindableType.SINGULAR_ATTRIBUTE);
        this.entityDomainType = entityDomainType;
        this.entityMapping = entityMapping;
    }

    public EntityDomainType<?> getEntityDomainType() {
        return this.entityDomainType;
    }

    public EntityMappingType getEntityMapping() {
        return this.entityMapping;
    }

    @Override
    public SqmPath<D> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        return new EntityDiscriminatorSqmPath(PathHelper.append(lhs, this, intermediatePathSource), this.pathModel, lhs, this.entityDomainType, this.entityMapping, lhs.nodeBuilder());
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        throw new IllegalStateException("Entity discriminator cannot be de-referenced");
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    @Override
    public Class<D> getJavaType() {
        return this.getExpressibleJavaType().getJavaTypeClass();
    }

    @Override
    public DomainType<D> getSqmType() {
        return this;
    }
}

