/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import java.util.Iterator;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.spi.BatchKeyAccess;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.CollectionTableMapping;
import org.hibernate.persister.collection.mutation.DeleteRowsCoordinator;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class DeleteRowsCoordinatorTablePerSubclass
implements DeleteRowsCoordinator {
    private final CollectionMutationTarget mutationTarget;
    private final RowMutationOperations rowMutationOperations;
    private final boolean deleteByIndex;
    private final SubclassEntry[] subclassEntries;
    private final MutationExecutorService mutationExecutorService;

    public DeleteRowsCoordinatorTablePerSubclass(OneToManyPersister mutationTarget, RowMutationOperations rowMutationOperations, boolean deleteByIndex, ServiceRegistry serviceRegistry) {
        this.mutationTarget = mutationTarget;
        this.rowMutationOperations = rowMutationOperations;
        this.deleteByIndex = deleteByIndex;
        this.subclassEntries = new SubclassEntry[mutationTarget.getElementPersister().getRootEntityDescriptor().getSubclassEntityNames().size()];
        this.mutationExecutorService = serviceRegistry.getService(MutationExecutorService.class);
    }

    @Override
    public CollectionMutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRows(PersistentCollection<?> collection, Object key, SharedSessionContractImplementor session) {
        PluralAttributeMapping pluralAttribute;
        CollectionPersister collectionDescriptor;
        Iterator<?> deletes;
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Deleting removed collection rows - %s : %s", (Object)this.mutationTarget.getRolePath(), key);
        }
        if (!(deletes = collection.getDeletes(collectionDescriptor = (pluralAttribute = this.mutationTarget.getTargetPart()).getCollectionDescriptor(), !this.deleteByIndex)).hasNext()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debug("No rows to delete");
            return;
        }
        MutationExecutor[] executors = new MutationExecutor[this.subclassEntries.length];
        try {
            int deletionCount = 0;
            RowMutationOperations.Restrictions restrictions = this.rowMutationOperations.getDeleteRowRestrictions();
            while (deletes.hasNext()) {
                MutationExecutor mutationExecutor;
                Object removal = deletes.next();
                EntityEntry entityEntry = session.getPersistenceContextInternal().getEntry(removal);
                int subclassId = entityEntry.getPersister().getSubclassId();
                if (executors[subclassId] == null) {
                    SubclassEntry subclassEntry = this.getSubclassEntry(entityEntry.getPersister());
                    mutationExecutor = executors[subclassId] = this.mutationExecutorService.createExecutor(subclassEntry.batchKeySupplier, subclassEntry.operationGroup, session);
                } else {
                    mutationExecutor = executors[subclassId];
                }
                restrictions.applyRestrictions(collection, key, removal, deletionCount, session, mutationExecutor.getJdbcValueBindings());
                mutationExecutor.execute(removal, null, null, null, session);
                ++deletionCount;
            }
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Done deleting `%s` collection rows : %s", deletionCount, (Object)this.mutationTarget.getRolePath());
        }
        finally {
            for (MutationExecutor executor : executors) {
                if (executor == null) continue;
                executor.release();
            }
        }
    }

    private SubclassEntry getSubclassEntry(EntityPersister elementPersister) {
        int subclassId = elementPersister.getSubclassId();
        SubclassEntry subclassEntry = this.subclassEntries[subclassId];
        if (subclassEntry != null) {
            return subclassEntry;
        }
        BasicBatchKey basicBatchKey = new BasicBatchKey(this.mutationTarget.getRolePath() + "#DELETE#" + subclassId);
        this.subclassEntries[subclassId] = new SubclassEntry(() -> basicBatchKey, this.createOperationGroup(elementPersister));
        return this.subclassEntries[subclassId];
    }

    private MutationOperationGroup createOperationGroup(EntityPersister elementPersister) {
        assert (this.mutationTarget.getTargetPart() != null);
        assert (this.mutationTarget.getTargetPart().getKeyDescriptor() != null);
        CollectionTableMapping collectionTableMapping = this.mutationTarget.getCollectionTableMapping();
        JdbcMutationOperation operation = this.rowMutationOperations.getDeleteRowOperation(new CollectionTableMapping(elementPersister.getMappedTableDetails().getTableName(), collectionTableMapping.getSpaces(), collectionTableMapping.isJoinTable(), collectionTableMapping.isInverse(), collectionTableMapping.getInsertDetails(), collectionTableMapping.getUpdateDetails(), collectionTableMapping.isCascadeDeleteEnabled(), collectionTableMapping.getDeleteDetails(), collectionTableMapping.getDeleteRowDetails()));
        return MutationOperationGroupFactory.singleOperation(MutationType.DELETE, this.mutationTarget, operation);
    }

    private static class SubclassEntry {
        private final BatchKeyAccess batchKeySupplier;
        private final MutationOperationGroup operationGroup;

        public SubclassEntry(BatchKeyAccess batchKeySupplier, MutationOperationGroup operationGroup) {
            this.batchKeySupplier = batchKeySupplier;
            this.operationGroup = operationGroup;
        }
    }
}

