/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.PersistenceException;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.descriptor.converter.internal.AttributeConverterMutabilityPlanImpl;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.java.spi.RegistryHelper;

public class JpaAttributeConverterImpl<O, R>
implements JpaAttributeConverter<O, R> {
    private final ManagedBean<? extends AttributeConverter<O, R>> attributeConverterBean;
    private final JavaType<? extends AttributeConverter<O, R>> converterJtd;
    private final JavaType<O> domainJtd;
    private final JavaType<R> jdbcJtd;

    public JpaAttributeConverterImpl(ManagedBean<? extends AttributeConverter<O, R>> attributeConverterBean, JavaType<? extends AttributeConverter<O, R>> converterJtd, JavaType<O> domainJtd, JavaType<R> jdbcJtd) {
        this.attributeConverterBean = attributeConverterBean;
        this.converterJtd = converterJtd;
        this.domainJtd = domainJtd;
        this.jdbcJtd = jdbcJtd;
    }

    public JpaAttributeConverterImpl(ManagedBean<? extends AttributeConverter<O, R>> attributeConverterBean, JavaType<? extends AttributeConverter<O, R>> converterJtd, Class<O> domainJavaType, Class<R> jdbcJavaType, JpaAttributeConverterCreationContext context) {
        this.attributeConverterBean = attributeConverterBean;
        this.converterJtd = converterJtd;
        JavaTypeRegistry jtdRegistry = context.getJavaTypeRegistry();
        this.jdbcJtd = jtdRegistry.getDescriptor(jdbcJavaType);
        this.domainJtd = jtdRegistry.resolveDescriptor(domainJavaType, () -> RegistryHelper.INSTANCE.createTypeDescriptor(domainJavaType, () -> {
            Class converterClass = attributeConverterBean.getBeanClass();
            MutabilityPlan mutabilityPlan = RegistryHelper.INSTANCE.determineMutabilityPlan(converterClass, context.getTypeConfiguration());
            if (mutabilityPlan != null) {
                return mutabilityPlan;
            }
            return new AttributeConverterMutabilityPlanImpl(this, true);
        }, context.getTypeConfiguration()));
    }

    @Override
    public ManagedBean<? extends AttributeConverter<O, R>> getConverterBean() {
        return this.attributeConverterBean;
    }

    @Override
    public O toDomainValue(R relationalForm) {
        try {
            return this.attributeConverterBean.getBeanInstance().convertToEntityAttribute(relationalForm);
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (RuntimeException re) {
            throw new PersistenceException("Error attempting to apply AttributeConverter", re);
        }
    }

    @Override
    public R toRelationalValue(O domainForm) {
        try {
            return this.attributeConverterBean.getBeanInstance().convertToDatabaseColumn(domainForm);
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (RuntimeException re) {
            throw new PersistenceException("Error attempting to apply AttributeConverter: " + re.getMessage(), re);
        }
    }

    @Override
    public JavaType<? extends AttributeConverter<O, R>> getConverterJavaType() {
        return this.converterJtd;
    }

    @Override
    public JavaType<O> getDomainJavaType() {
        return this.domainJtd;
    }

    @Override
    public JavaType<R> getRelationalJavaType() {
        return this.jdbcJtd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpaAttributeConverterImpl that = (JpaAttributeConverterImpl)o;
        if (!this.attributeConverterBean.equals(that.attributeConverterBean)) {
            return false;
        }
        if (!this.converterJtd.equals(that.converterJtd)) {
            return false;
        }
        if (!this.domainJtd.equals(that.domainJtd)) {
            return false;
        }
        return this.jdbcJtd.equals(that.jdbcJtd);
    }

    public int hashCode() {
        int result = this.attributeConverterBean.hashCode();
        result = 31 * result + this.converterJtd.hashCode();
        result = 31 * result + this.domainJtd.hashCode();
        result = 31 * result + this.jdbcJtd.hashCode();
        return result;
    }
}

