/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.extensions;

import com.github.blindpirate.extensions.CaptureSystemOutput;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;

class CaptureSystemOutputExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    CaptureSystemOutputExtension() {
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.getOutputCapture(context).captureOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterEach(ExtensionContext context) throws Exception {
        CaptureSystemOutput.OutputCapture outputCapture = this.getOutputCapture(context);
        try {
            if (!outputCapture.matchers.isEmpty()) {
                String output = outputCapture.toString();
                MatcherAssert.assertThat((Object)output, (Matcher)Matchers.allOf(outputCapture.matchers));
            }
        }
        finally {
            outputCapture.releaseOutput();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        boolean isTestMethodLevel = extensionContext.getTestMethod().isPresent();
        boolean isOutputCapture = parameterContext.getParameter().getType() == CaptureSystemOutput.OutputCapture.class;
        return isTestMethodLevel && isOutputCapture;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.getOutputCapture(extensionContext);
    }

    private CaptureSystemOutput.OutputCapture getOutputCapture(ExtensionContext context) {
        return (CaptureSystemOutput.OutputCapture)this.getStore(context).getOrComputeIfAbsent(CaptureSystemOutput.OutputCapture.class);
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getRequiredTestMethod()}));
    }
}

