/*
 * Decompiled with CFR 0.152.
 */
package com.bluejamesbond.text;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.os.AsyncTask;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import com.bluejamesbond.text.IDocumentLayout;
import com.bluejamesbond.text.R;
import com.bluejamesbond.text.SpannableDocumentLayout;
import com.bluejamesbond.text.StringDocumentLayout;
import com.bluejamesbond.text.style.TextAlignment;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;

public class DocumentView
extends ScrollView {
    public static final int PLAIN_TEXT = 0;
    public static final int FORMATTED_TEXT = 1;
    private static final ITween LINEAR_EASE_IN;
    private static final Object eglBitmapHeightLock;
    private static int eglBitmapHeight;
    protected ILayoutProgressListener layoutProgressListener;
    private IDocumentLayout layout;
    private TextPaint paint;
    private TextPaint cachePaint;
    private View viewportView;
    private ITween fadeInTween;
    private int fadeInDuration = 250;
    private int fadeInAnimationStepDelay = 35;
    private volatile MeasureTask measureTask;
    private volatile MeasureTaskState measureState;
    private int minimumHeight;
    private int orientation;
    private CacheConfig cacheConfig;
    private CacheBitmap cacheBitmapTop;
    private CacheBitmap cacheBitmapBottom;
    private boolean disallowInterceptTouch;

    public DocumentView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initDocumentView(context, attrs, 0);
    }

    public DocumentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initDocumentView(context, attrs, 0);
    }

    public DocumentView(Context context) {
        super(context);
        this.initDocumentView(context, null, 0);
    }

    public DocumentView(Context context, int type) {
        super(context);
        this.initDocumentView(context, null, type);
    }

    @TargetApi(value=21)
    public DocumentView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initDocumentView(context, attrs, 0);
    }

    private static int getMaxTextureSize() {
        int GL_MAX_TEXTURE_SIZE = 2048;
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int[] version = new int[2];
        egl.eglInitialize(display, version);
        int[] totalConfigurations = new int[1];
        egl.eglGetConfigs(display, null, 0, totalConfigurations);
        EGLConfig[] configurationsList = new EGLConfig[totalConfigurations[0]];
        egl.eglGetConfigs(display, configurationsList, totalConfigurations[0], totalConfigurations);
        int[] textureSize = new int[1];
        int maximumTextureSize = 0;
        for (int i = 0; i < totalConfigurations[0]; ++i) {
            egl.eglGetConfigAttrib(display, configurationsList[i], 12332, textureSize);
            if (maximumTextureSize >= textureSize[0]) continue;
            maximumTextureSize = textureSize[0];
        }
        egl.eglTerminate(display);
        return Math.max(maximumTextureSize, 2048);
    }

    public boolean isDisallowInterceptTouch() {
        return this.disallowInterceptTouch;
    }

    public void setDisallowInterceptTouch(boolean disallowInterceptTouch) {
        this.disallowInterceptTouch = disallowInterceptTouch;
    }

    protected synchronized void drawLayout(Canvas canvas, int startY, int endY, boolean isCache) {
        if (isCache) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        this.layout.draw(canvas, startY, endY);
        if (this.getDocumentLayoutParams().isDebugging()) {
            float f;
            IDocumentLayout.LayoutParams params = this.getDocumentLayoutParams();
            int lastColor = this.paint.getColor();
            float lastStrokeWidth = this.paint.getStrokeWidth();
            Paint.Style lastStyle = this.paint.getStyle();
            this.paint.setColor(-65281);
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setStrokeWidth(4.0f);
            float left = params.insetPaddingLeft.floatValue();
            float top = params.insetPaddingTop.floatValue() >= (float)startY && params.insetPaddingTop.floatValue() < (float)endY ? params.insetPaddingTop.floatValue() : 0.0f;
            float right = params.parentWidth.floatValue() - params.insetPaddingRight.floatValue();
            float bottom = (float)this.layout.getMeasuredHeight() - params.insetPaddingBottom.floatValue();
            bottom = f >= (float)startY && bottom < (float)endY ? bottom - (float)startY : (float)canvas.getHeight();
            canvas.drawRect(left, top, right, bottom, (Paint)this.paint);
            this.paint.setStrokeWidth(lastStrokeWidth);
            this.paint.setColor(lastColor);
            this.paint.setStyle(lastStyle);
        }
    }

    public int getFadeInAnimationStepDelay() {
        return this.fadeInAnimationStepDelay;
    }

    public void setFadeInAnimationStepDelay(int delay) {
        this.fadeInAnimationStepDelay = delay;
    }

    public int getFadeInDuration() {
        return this.fadeInDuration;
    }

    public void setFadeInDuration(int duration) {
        this.fadeInDuration = duration;
    }

    public ITween getFadeInTween() {
        return this.fadeInTween;
    }

    public void setFadeInTween(ITween tween) {
        this.fadeInTween = tween;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDocumentView(Context context, AttributeSet attrs, int type) {
        Object object = eglBitmapHeightLock;
        synchronized (object) {
            if (eglBitmapHeight == -1) {
                DisplayMetrics metrics = context.getResources().getDisplayMetrics();
                eglBitmapHeight = Math.min(Math.max(metrics.heightPixels, metrics.widthPixels) * 7 / 6, DocumentView.getMaxTextureSize());
            }
        }
        this.disallowInterceptTouch = false;
        this.fadeInTween = LINEAR_EASE_IN;
        this.cacheConfig = CacheConfig.AUTO_QUALITY;
        this.paint = new TextPaint();
        this.cachePaint = new TextPaint();
        this.viewportView = new View(context);
        this.measureState = MeasureTaskState.START;
        this.initPaint((Paint)this.paint);
        this.setPadding(0, 0, 0, 0);
        this.addView(this.viewportView);
        if (attrs != null && !this.isInEditMode()) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DocumentView);
            int N = a.getIndexCount();
            this.layout = this.getDocumentLayoutInstance(a.getInt(R.styleable.DocumentView_documentView_textFormat, 0), this.paint);
            IDocumentLayout.LayoutParams layoutParams = this.layout.getLayoutParams();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.DocumentView_documentView_insetPadding) {
                    Float pad = Float.valueOf(a.getDimension(attr, 0.0f));
                    layoutParams.setInsetPaddingLeft(pad.floatValue());
                    layoutParams.setInsetPaddingBottom(pad.floatValue());
                    layoutParams.setInsetPaddingRight(pad.floatValue());
                    layoutParams.setInsetPaddingTop(pad.floatValue());
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_insetPaddingLeft) {
                    layoutParams.setInsetPaddingLeft(a.getDimension(attr, layoutParams.getInsetPaddingLeft()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_insetPaddingBottom) {
                    layoutParams.setInsetPaddingBottom(a.getDimension(attr, layoutParams.getInsetPaddingBottom()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_insetPaddingRight) {
                    layoutParams.setInsetPaddingRight(a.getDimension(attr, layoutParams.getInsetPaddingRight()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_insetPaddingTop) {
                    layoutParams.setInsetPaddingTop(a.getDimension(attr, layoutParams.getInsetPaddingTop()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_offsetX) {
                    layoutParams.setOffsetX(a.getDimension(attr, layoutParams.getOffsetX()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_offsetY) {
                    layoutParams.setOffsetY(a.getDimension(attr, layoutParams.getOffsetY()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_hyphen) {
                    layoutParams.setHyphen(a.getString(attr));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_maxLines) {
                    layoutParams.setMaxLines(a.getInt(attr, layoutParams.getMaxLines()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_lineHeightMultiplier) {
                    layoutParams.setLineHeightMultiplier(a.getFloat(attr, layoutParams.getLineHeightMultiplier()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_textAlignment) {
                    layoutParams.setTextAlignment(TextAlignment.getById(a.getInt(attr, layoutParams.getTextAlignment().getId())));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_reverse) {
                    layoutParams.setReverse(a.getBoolean(attr, layoutParams.isReverse()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_wordSpacingMultiplier) {
                    layoutParams.setWordSpacingMultiplier(a.getFloat(attr, layoutParams.getWordSpacingMultiplier().floatValue()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_textColor) {
                    layoutParams.setTextColor(a.getColor(attr, layoutParams.getTextColor()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_textSize) {
                    layoutParams.setRawTextSize(a.getDimension(attr, layoutParams.getTextSize()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_textStyle) {
                    int style = a.getInt(attr, 0);
                    layoutParams.setTextFakeBold((style & 1) > 0);
                    layoutParams.setTextUnderline((style >> 1 & 1) > 0);
                    layoutParams.setTextStrikeThru((style >> 2 & 1) > 0);
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_textTypefacePath) {
                    layoutParams.setTextTypeface(Typeface.createFromAsset((AssetManager)this.getResources().getAssets(), (String)a.getString(attr)));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_antialias) {
                    layoutParams.setAntialias(a.getBoolean(attr, layoutParams.isAntiAlias()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_textSubPixel) {
                    layoutParams.setTextSubPixel(a.getBoolean(attr, layoutParams.isTextSubPixel()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_text) {
                    this.layout.setText(a.getString(attr));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_cacheConfig) {
                    this.setCacheConfig(CacheConfig.getById(a.getInt(attr, CacheConfig.AUTO_QUALITY.getId())));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_progressBar) {
                    this.setProgressBar(a.getResourceId(R.styleable.DocumentView_documentView_progressBar, 0));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_fadeInAnimationStepDelay) {
                    this.setFadeInAnimationStepDelay(a.getInteger(attr, this.getFadeInAnimationStepDelay()));
                    continue;
                }
                if (attr == R.styleable.DocumentView_documentView_fadeInDuration) {
                    this.setFadeInDuration(a.getInteger(attr, this.getFadeInDuration()));
                    continue;
                }
                if (attr != R.styleable.DocumentView_documentView_disallowInterceptTouch) continue;
                this.setDisallowInterceptTouch(a.getBoolean(attr, this.isDisallowInterceptTouch()));
            }
            a.recycle();
        } else {
            this.layout = this.getDocumentLayoutInstance(type, this.paint);
        }
    }

    protected void initPaint(Paint paint) {
        paint.setTypeface(Typeface.defaultFromStyle((int)0));
        paint.setTextSize(34.0f);
        paint.setAntiAlias(true);
    }

    protected void onAttachedToWindow() {
        this.orientation = this.getResources().getConfiguration().orientation;
        super.onAttachedToWindow();
    }

    public IDocumentLayout getDocumentLayoutInstance(int type, TextPaint paint) {
        switch (type) {
            case 1: {
                return new SpannableDocumentLayout(this.getContext(), paint){

                    @Override
                    public void onLayoutParamsChange() {
                        DocumentView.this.invalidateCache();
                        DocumentView.this.postInvalidate();
                    }

                    @Override
                    public void onTextChange() {
                        DocumentView.this.invalidateCache();
                        DocumentView.this.requestLayout();
                    }
                };
            }
        }
        return new StringDocumentLayout(this.getContext(), paint){

            @Override
            public void onLayoutParamsChange() {
                DocumentView.this.invalidateCache();
                DocumentView.this.postInvalidate();
            }

            @Override
            public void onTextChange() {
                DocumentView.this.invalidateCache();
                DocumentView.this.requestLayout();
            }
        };
    }

    public void invalidateCache() {
        if (this.cacheBitmapTop != null) {
            this.cacheBitmapTop.setStart(-1);
        }
        if (this.cacheBitmapBottom != null) {
            this.cacheBitmapBottom.setStart(-1);
        }
    }

    public View getViewportView() {
        return this.viewportView;
    }

    public void setProgressBar(final int progressBarId) {
        this.setOnLayoutProgressListener(new ILayoutProgressListener(){
            private ProgressBar progressBar;

            @Override
            public void onCancelled() {
                this.progressBar.setProgress(this.progressBar.getMax());
                this.progressBar = null;
            }

            @Override
            public void onFinish() {
                this.progressBar.setProgress(this.progressBar.getMax());
                this.progressBar = null;
            }

            @Override
            public void onStart() {
                this.progressBar = (ProgressBar)((Activity)DocumentView.this.getContext()).getWindow().getDecorView().findViewById(progressBarId);
                this.progressBar.setProgress(0);
            }

            @Override
            public void onProgressUpdate(float progress) {
                this.progressBar.setProgress((int)(progress * (float)this.progressBar.getMax()));
            }
        });
    }

    public void setOnLayoutProgressListener(ILayoutProgressListener listener) {
        this.layoutProgressListener = listener;
    }

    public CharSequence getText() {
        return this.layout.getText();
    }

    public void setText(CharSequence text) {
        this.layout.setText(text);
        this.requestLayout();
    }

    public IDocumentLayout.LayoutParams getDocumentLayoutParams() {
        return this.layout.getLayoutParams();
    }

    public IDocumentLayout getLayout() {
        return this.layout;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public void setCacheConfig(CacheConfig quality) {
        this.cacheConfig = quality;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        switch (this.measureState) {
            case FINISH_AWAIT: {
                break;
            }
            case AWAIT: {
                break;
            }
            case FINISH: {
                this.viewportView.setMinimumWidth(width);
                this.viewportView.setMinimumHeight(this.layout.getMeasuredHeight());
                this.measureState = MeasureTaskState.FINISH_AWAIT;
                if (this.cacheConfig == CacheConfig.NO_CACHE) break;
                this.allocateResources();
                break;
            }
            case START: {
                if (this.measureTask != null) {
                    this.measureTask.cancel(true);
                    this.measureTask = null;
                }
                this.measureTask = new MeasureTask(width);
                this.measureTask.execute(new Void[0]);
                this.measureState = MeasureTaskState.AWAIT;
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.requestDisallowInterceptTouchEvent(this.disallowInterceptTouch);
        return super.onTouchEvent(ev);
    }

    public void requestLayout() {
        this.measureState = MeasureTaskState.START;
        super.requestLayout();
    }

    protected void onDetachedFromWindow() {
        this.freeResources();
        super.onDetachedFromWindow();
    }

    public void setProgressBar(final ProgressBar progressBar) {
        this.setOnLayoutProgressListener(new ILayoutProgressListener(){

            @Override
            public void onCancelled() {
                progressBar.setProgress(progressBar.getMax());
            }

            @Override
            public void onFinish() {
                progressBar.setProgress(progressBar.getMax());
            }

            @Override
            public void onStart() {
                progressBar.setProgress(0);
            }

            @Override
            public void onProgressUpdate(float progress) {
                progressBar.setProgress((int)(progress * (float)progressBar.getMax()));
            }
        });
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        if (this.orientation != newConfig.orientation) {
            this.orientation = newConfig.orientation;
            this.freeResources();
        }
        super.onConfigurationChanged(newConfig);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final void onDraw(Canvas canvas) {
        boolean cacheEnabled;
        super.onDraw(canvas);
        if (this.isInEditMode()) {
            return;
        }
        boolean bl = cacheEnabled = this.cacheConfig != CacheConfig.NO_CACHE && this.layout.getMeasuredHeight() > this.getHeight();
        if (cacheEnabled) {
            boolean postInvalidate;
            this.allocateResources();
            int scrollTop = this.getScrollY();
            int scrollBottom = scrollTop + this.getHeight();
            final CacheBitmap top = scrollTop % (eglBitmapHeight * 2) < eglBitmapHeight ? this.cacheBitmapTop : this.cacheBitmapBottom;
            final CacheBitmap bottom = scrollBottom % (eglBitmapHeight * 2) >= eglBitmapHeight ? this.cacheBitmapBottom : this.cacheBitmapTop;
            final int startTop = scrollTop - scrollTop % (eglBitmapHeight * 2) + (top == this.cacheBitmapTop ? 0 : eglBitmapHeight);
            if (top == bottom) {
                if (startTop != top.getStart()) {
                    top.setStart(startTop);
                    top.drawInBackground(new Runnable(){

                        @Override
                        public void run() {
                            DocumentView.this.drawLayout(new Canvas(bottom.getBitmap()), startTop, startTop + eglBitmapHeight, true);
                        }
                    });
                }
                postInvalidate = this.drawCacheToView(canvas, (Paint)this.cachePaint, top, startTop);
            } else {
                final int startBottom = startTop + eglBitmapHeight;
                if (startTop != top.getStart()) {
                    top.setStart(startTop);
                    top.drawInBackground(new Runnable(){

                        @Override
                        public void run() {
                            DocumentView.this.drawLayout(new Canvas(top.getBitmap()), startTop, startTop + eglBitmapHeight, true);
                        }
                    });
                }
                if (startBottom != bottom.getStart()) {
                    bottom.setStart(startBottom);
                    bottom.drawInBackground(new Runnable(){

                        @Override
                        public void run() {
                            DocumentView.this.drawLayout(new Canvas(bottom.getBitmap()), startBottom, startBottom + eglBitmapHeight, true);
                        }
                    });
                }
                postInvalidate = this.drawCacheToView(canvas, (Paint)this.cachePaint, top, startTop) | this.drawCacheToView(canvas, (Paint)this.cachePaint, bottom, startBottom);
            }
            if (postInvalidate) {
                this.postInvalidateDelayed(this.fadeInAnimationStepDelay);
            }
        } else {
            this.drawLayout(canvas, 0, this.layout.getMeasuredHeight(), false);
        }
    }

    public void setMinimumHeight(int minHeight) {
        this.minimumHeight = minHeight;
        this.viewportView.setMinimumHeight(this.minimumHeight);
    }

    public void allocateResources() {
        if (this.cacheBitmapTop == null) {
            this.cacheBitmapTop = new CacheBitmap(this.getWidth(), eglBitmapHeight, this.cacheConfig.getConfig());
        }
        if (this.cacheBitmapBottom == null) {
            this.cacheBitmapBottom = new CacheBitmap(this.getWidth(), eglBitmapHeight, this.cacheConfig.getConfig());
        }
    }

    protected boolean drawCacheToView(Canvas canvas, Paint paint, CacheBitmap cache, int y) {
        if (cache.isReady()) {
            int lastAlpha = paint.getAlpha();
            paint.setAlpha(cache.getAlpha());
            canvas.drawBitmap(cache.getBitmap(), 0.0f, (float)y, paint);
            paint.setAlpha(lastAlpha);
            return cache.getAlpha() < 255;
        }
        return false;
    }

    protected void freeResources() {
        this.viewportView.setMinimumHeight(this.minimumHeight);
        if (this.measureTask != null) {
            this.measureTask.cancel(true);
            this.measureTask = null;
            this.measureState = MeasureTaskState.START;
        }
        this.destroyCache();
    }

    public void destroyCache() {
        if (this.cacheBitmapTop != null) {
            this.cacheBitmapTop.recycle();
            this.cacheBitmapTop = null;
        }
        if (this.cacheBitmapBottom != null) {
            this.cacheBitmapBottom.recycle();
            this.cacheBitmapBottom = null;
        }
    }

    static {
        eglBitmapHeightLock = new Object();
        eglBitmapHeight = -1;
        LINEAR_EASE_IN = new ITween(){

            @Override
            public float get(float t, float b, float c, float d) {
                return c * t / d + b;
            }
        };
    }

    private class CacheBitmap {
        private long drawFadeInStartTime;
        private Bitmap bitmap;
        private int start;
        private volatile boolean drawCompleted;
        private volatile CacheDrawTask drawTask;
        private volatile int alpha;

        public CacheBitmap(int w, int h, Bitmap.Config config) {
            this.bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)config);
            this.start = -1;
            this.drawCompleted = false;
        }

        public int getAlpha() {
            return (int)Math.min(DocumentView.this.fadeInTween.get(System.currentTimeMillis() - this.drawFadeInStartTime, 0.0f, 255.0f, DocumentView.this.fadeInDuration), 255.0f);
        }

        public void drawInBackground(Runnable runnable) {
            if (this.drawTask != null) {
                this.drawTask.cancel(true);
                this.drawTask = null;
            }
            this.drawCompleted = false;
            this.alpha = 0;
            this.drawTask = new CacheDrawTask(runnable);
            this.drawTask.execute(new Void[0]);
        }

        public Bitmap getBitmap() {
            return this.bitmap;
        }

        public void setBitmap(Bitmap bitmap) {
            this.bitmap = bitmap;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public boolean isReady() {
            return this.drawCompleted;
        }

        public void recycle() {
            if (this.drawTask != null) {
                this.drawTask.cancel(true);
                this.drawTask = null;
                this.drawCompleted = false;
            }
            if (this.bitmap != null) {
                this.bitmap.recycle();
                this.bitmap = null;
            }
        }

        public class CacheDrawTask
        extends AsyncTask<Void, Void, Void> {
            private Runnable drawRunnable;

            public CacheDrawTask(Runnable runnable) {
                this.drawRunnable = runnable;
            }

            protected void onPreExecute() {
                super.onPreExecute();
            }

            protected Void doInBackground(Void ... params) {
                this.drawRunnable.run();
                return null;
            }

            protected void onPostExecute(Void aVoid) {
                CacheBitmap.this.drawFadeInStartTime = System.currentTimeMillis();
                CacheBitmap.this.drawCompleted = true;
                DocumentView.this.invalidate();
            }
        }
    }

    public class MeasureTask
    extends AsyncTask<Void, Float, Boolean> {
        private IDocumentLayout.IProgress<Float> progress;
        private IDocumentLayout.ICancel<Boolean> cancelled;

        public MeasureTask(float parentWidth) {
            DocumentView.this.layout.getLayoutParams().setParentWidth(parentWidth);
            this.progress = new IDocumentLayout.IProgress<Float>(){

                @Override
                public void onUpdate(Float progress) {
                    if (DocumentView.this.layoutProgressListener != null) {
                        DocumentView.this.layoutProgressListener.onProgressUpdate(progress.floatValue());
                    }
                }
            };
            this.cancelled = new IDocumentLayout.ICancel<Boolean>(){

                @Override
                public Boolean isCancelled() {
                    return MeasureTask.this.isCancelled();
                }
            };
        }

        protected Boolean doInBackground(Void ... params) {
            try {
                return DocumentView.this.layout.measure(this.progress, this.cancelled);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        protected void onPreExecute() {
            if (DocumentView.this.layoutProgressListener != null) {
                DocumentView.this.layoutProgressListener.onStart();
            }
        }

        protected void onPostExecute(Boolean done) {
            if (!done.booleanValue() || this.isCancelled()) {
                if (DocumentView.this.layoutProgressListener != null) {
                    DocumentView.this.layoutProgressListener.onCancelled();
                }
                return;
            }
            DocumentView.this.measureTask = null;
            DocumentView.this.measureState = MeasureTaskState.FINISH;
            DocumentView.super.requestLayout();
            if (DocumentView.this.layoutProgressListener != null) {
                DocumentView.this.layoutProgressListener.onFinish();
            }
        }

        protected void onCancelled() {
            super.onCancelled();
            if (DocumentView.this.layoutProgressListener != null) {
                DocumentView.this.layoutProgressListener.onCancelled();
            }
        }
    }

    public static interface ITween {
        public float get(float var1, float var2, float var3, float var4);
    }

    public static interface ILayoutProgressListener {
        public void onCancelled();

        public void onFinish();

        public void onStart();

        public void onProgressUpdate(float var1);
    }

    static enum MeasureTaskState {
        AWAIT,
        FINISH,
        START,
        FINISH_AWAIT;

    }

    public static enum CacheConfig {
        NO_CACHE(null, 0),
        AUTO_QUALITY(Bitmap.Config.ARGB_4444, 1),
        LOW_QUALITY(Bitmap.Config.RGB_565, 2),
        HIGH_QUALITY(Bitmap.Config.ARGB_8888, 3),
        GRAYSCALE(Bitmap.Config.ALPHA_8, 4);

        private final Bitmap.Config mConfig;
        private final int mId;

        private CacheConfig(Bitmap.Config config, int id) {
            this.mConfig = config;
            this.mId = id;
        }

        public static CacheConfig getById(int id) {
            switch (id) {
                default: {
                    return NO_CACHE;
                }
                case 1: {
                    return AUTO_QUALITY;
                }
                case 2: {
                    return LOW_QUALITY;
                }
                case 3: {
                    return HIGH_QUALITY;
                }
                case 4: 
            }
            return GRAYSCALE;
        }

        private Bitmap.Config getConfig() {
            return this.mConfig;
        }

        public int getId() {
            return this.mId;
        }
    }
}

