/*
 * Decompiled with CFR 0.152.
 */
package com.bluejamesbond.text;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.Toast;
import com.bluejamesbond.text.hyphen.IHyphenator;
import com.bluejamesbond.text.style.TextAlignment;

public abstract class IDocumentLayout {
    protected CharSequence text;
    protected int lineCount;
    protected int measuredHeight;
    protected boolean textChange;
    protected LayoutParams params;
    protected TextPaint paint;
    private Toast toast;
    private DisplayMetrics displayMetrics;

    @SuppressLint(value={"ShowToast"})
    public IDocumentLayout(Context context, TextPaint textPaint) {
        this.paint = textPaint;
        this.text = "";
        this.measuredHeight = 0;
        this.lineCount = 0;
        this.textChange = false;
        this.displayMetrics = context.getResources().getDisplayMetrics();
        this.toast = Toast.makeText((Context)context, (CharSequence)"", (int)0);
        this.params = new LayoutParams();
        this.params.setLineHeightMultiplier(1.0f);
        this.params.setHyphenated(false);
        this.params.setReverse(false);
    }

    protected void showToast(String s) {
        this.toast.setText((CharSequence)s);
        this.toast.show();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public LayoutParams getLayoutParams() {
        return this.params;
    }

    public CharSequence getText() {
        return this.text;
    }

    public void setText(CharSequence text) {
        Object object = text = text == null ? new SpannableString((CharSequence)"") : new SpannableString(text);
        if (this.text.equals(text)) {
            return;
        }
        this.text = text;
        this.textChange = true;
        this.onTextChange();
    }

    public int getMeasuredHeight() {
        return this.measuredHeight;
    }

    protected void onTextNull() {
        this.params.changed = false;
        this.measuredHeight = (int)(this.params.insetPaddingTop.floatValue() + this.params.insetPaddingBottom.floatValue());
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public boolean measure(IProgress<Float> progress, ICancel<Boolean> cancelled) {
        if (!this.params.changed && !this.textChange) {
            return true;
        }
        this.params.loadToPaint((Paint)this.paint);
        if (this.text == null) {
            this.text = new SpannableString((CharSequence)"");
        } else if (!(this.text instanceof Spannable)) {
            this.text = new SpannableString(this.text);
        }
        return this.onMeasure(progress, cancelled);
    }

    protected abstract boolean onMeasure(IProgress<Float> var1, ICancel<Boolean> var2);

    public void draw(Canvas canvas, int startTop, int startBottom) {
        this.params.loadToPaint((Paint)this.paint);
        this.onDraw(canvas, startTop, startBottom);
    }

    protected abstract void onDraw(Canvas var1, int var2, int var3);

    public abstract float getTokenAscent(int var1);

    public abstract float getTokenDescent(int var1);

    public abstract int getTokenForVertical(float var1, TokenPosition var2);

    public abstract int getLineForToken(int var1);

    public abstract int getTokenStart(int var1);

    public abstract int getTokenEnd(int var1);

    public abstract float getTokenTopAt(int var1);

    public abstract CharSequence getTokenTextAt(int var1);

    public abstract boolean isTokenized();

    public abstract void onLayoutParamsChange();

    public abstract void onTextChange();

    public class LayoutParams {
        protected IHyphenator hyphenator = null;
        protected Float insetPaddingLeft = Float.valueOf(0.0f);
        protected Float insetPaddingTop = Float.valueOf(0.0f);
        protected Float insetPaddingBottom = Float.valueOf(0.0f);
        protected Float insetPaddingRight = Float.valueOf(0.0f);
        protected Float parentWidth = Float.valueOf(800.0f);
        protected Float offsetX = Float.valueOf(0.0f);
        protected Float offsetY = Float.valueOf(0.0f);
        protected Boolean debugging = false;
        protected Float wordSpacingMultiplier = Float.valueOf(1.0f);
        protected Float lineHeightMultiplier = Float.valueOf(0.0f);
        protected Boolean hyphenated = false;
        protected Boolean reverse = false;
        protected Boolean subpixelText = false;
        protected Boolean antialias = false;
        protected Integer maxLines = Integer.MAX_VALUE;
        protected String hyphen = "-";
        protected TextAlignment textAlignment = TextAlignment.LEFT;
        protected Boolean textUnderline = false;
        protected Boolean textStrikeThru = false;
        protected Boolean textFakeBold = false;
        protected Typeface textTypeface = Typeface.DEFAULT;
        protected Float rawTextSize = Float.valueOf(TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)IDocumentLayout.access$000(IDocumentLayout.this)));
        protected Integer textColor = -16777216;
        protected Integer textLinkColor = Color.parseColor((String)"#ff05c5cf");
        protected boolean changed = false;

        public Integer getTextLinkColor() {
            return this.textLinkColor;
        }

        public void setTextLinkColor(Integer textLinkColor) {
            this.textLinkColor = textLinkColor;
        }

        public void loadToPaint(Paint paint) {
            paint.setTextSize(this.rawTextSize.floatValue());
            paint.setFakeBoldText(this.textFakeBold.booleanValue());
            paint.setStrikeThruText(this.textStrikeThru.booleanValue());
            paint.setColor(this.textColor.intValue());
            paint.setTypeface(this.textTypeface);
            paint.setUnderlineText(this.textUnderline.booleanValue());
            paint.setAntiAlias(this.antialias.booleanValue());
            paint.setSubpixelText(this.subpixelText.booleanValue());
        }

        public Float getWordSpacingMultiplier() {
            return this.wordSpacingMultiplier;
        }

        public void setWordSpacingMultiplier(float wordSpacingMultiplier) {
            if (this.wordSpacingMultiplier.equals(Float.valueOf(wordSpacingMultiplier))) {
                return;
            }
            this.wordSpacingMultiplier = Float.valueOf(wordSpacingMultiplier);
            this.invalidate();
        }

        public TextAlignment getTextAlignment() {
            return this.textAlignment;
        }

        public void setTextAlignment(TextAlignment textAlignment) {
            if (this.textAlignment == textAlignment) {
                return;
            }
            this.textAlignment = textAlignment;
            this.invalidate();
        }

        public IHyphenator getHyphenator() {
            return this.hyphenator;
        }

        public void setHyphenator(IHyphenator hyphenator) {
            if (hyphenator == null) {
                return;
            }
            if (this.hyphenator != null && this.hyphenator.equals(hyphenator)) {
                return;
            }
            this.hyphenator = hyphenator;
            this.invalidate();
        }

        public float getInsetPaddingLeft() {
            return this.insetPaddingLeft.floatValue();
        }

        public void setInsetPaddingLeft(float insetPaddingLeft) {
            if (this.insetPaddingLeft.equals(Float.valueOf(insetPaddingLeft))) {
                return;
            }
            this.insetPaddingLeft = Float.valueOf(insetPaddingLeft);
            this.invalidate();
        }

        public float getInsetPaddingTop() {
            return this.insetPaddingTop.floatValue();
        }

        public void setInsetPaddingTop(float insetPaddingTop) {
            if (this.insetPaddingTop.equals(Float.valueOf(insetPaddingTop))) {
                return;
            }
            this.insetPaddingTop = Float.valueOf(insetPaddingTop);
            this.invalidate();
        }

        public float getInsetPaddingBottom() {
            return this.insetPaddingBottom.floatValue();
        }

        public void setInsetPaddingBottom(float insetPaddingBottom) {
            if (this.insetPaddingBottom.equals(Float.valueOf(insetPaddingBottom))) {
                return;
            }
            this.insetPaddingBottom = Float.valueOf(insetPaddingBottom);
            this.invalidate();
        }

        public float getInsetPaddingRight() {
            return this.insetPaddingRight.floatValue();
        }

        public void setInsetPaddingRight(float insetPaddingRight) {
            if (this.insetPaddingRight.equals(Float.valueOf(insetPaddingRight))) {
                return;
            }
            this.insetPaddingRight = Float.valueOf(insetPaddingRight);
            this.invalidate();
        }

        public float getParentWidth() {
            return this.parentWidth.floatValue();
        }

        public void setParentWidth(float parentWidth) {
            if (this.parentWidth.equals(Float.valueOf(parentWidth))) {
                return;
            }
            this.parentWidth = Float.valueOf(parentWidth);
            this.invalidate();
        }

        public float getOffsetX() {
            return this.offsetX.floatValue();
        }

        public void setOffsetX(float offsetX) {
            this.offsetX = Float.valueOf(offsetX);
        }

        public float getOffsetY() {
            return this.offsetY.floatValue();
        }

        public void setOffsetY(float offsetY) {
            this.offsetY = Float.valueOf(offsetY);
        }

        public float getLineHeightMultiplier() {
            return this.lineHeightMultiplier.floatValue();
        }

        public void setLineHeightMultiplier(float lineHeightMultiplier) {
            if (this.lineHeightMultiplier.equals(Float.valueOf(lineHeightMultiplier))) {
                return;
            }
            this.lineHeightMultiplier = Float.valueOf(lineHeightMultiplier);
            this.invalidate();
        }

        public boolean isHyphenated() {
            return this.hyphenated;
        }

        public void setHyphenated(boolean hyphenated) {
            if (this.hyphenated.equals(hyphenated)) {
                return;
            }
            this.hyphenated = hyphenated && this.hyphenator != null;
            this.invalidate();
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public void setReverse(boolean reverse) {
            if (this.reverse.equals(reverse)) {
                return;
            }
            this.reverse = reverse;
            this.invalidate();
        }

        public int getMaxLines() {
            return this.maxLines;
        }

        public void setMaxLines(int maxLines) {
            if (this.maxLines.equals(maxLines)) {
                return;
            }
            this.maxLines = maxLines;
            this.invalidate();
        }

        public String getHyphen() {
            return this.hyphen;
        }

        public void setHyphen(String hyphen) {
            if (this.hyphen.equals(hyphen)) {
                return;
            }
            this.hyphen = hyphen;
            this.invalidate();
        }

        public boolean hasChanged() {
            return this.changed;
        }

        public void invalidate() {
            this.changed = true;
            IDocumentLayout.this.onLayoutParamsChange();
        }

        public boolean isTextUnderline() {
            return this.textUnderline;
        }

        public void setTextUnderline(boolean underline) {
            if (this.textUnderline.equals(underline)) {
                return;
            }
            this.textUnderline = underline;
            IDocumentLayout.this.onLayoutParamsChange();
        }

        public boolean isTextStrikeThru() {
            return this.textStrikeThru;
        }

        public void setTextStrikeThru(boolean strikeThru) {
            if (this.textStrikeThru.equals(strikeThru)) {
                return;
            }
            this.textStrikeThru = strikeThru;
            IDocumentLayout.this.onLayoutParamsChange();
        }

        public boolean isTextFakeBold() {
            return this.textFakeBold;
        }

        public void setTextFakeBold(boolean fakeBold) {
            if (this.textFakeBold.equals(fakeBold)) {
                return;
            }
            this.textFakeBold = fakeBold;
            this.invalidate();
        }

        public Typeface getTextTypeface() {
            return this.textTypeface;
        }

        public void setTextTypeface(Typeface typeface) {
            if (this.textTypeface.equals((Object)typeface)) {
                return;
            }
            this.textTypeface = typeface;
            this.invalidate();
        }

        public void setTextSize(int unit, float size) {
            this.setRawTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)IDocumentLayout.this.displayMetrics));
        }

        public float getTextSize() {
            return this.rawTextSize.floatValue();
        }

        public void setTextSize(float size) {
            this.setTextSize(2, size);
        }

        public void setRawTextSize(float textSize) {
            if (this.rawTextSize.equals(Float.valueOf(textSize))) {
                return;
            }
            this.rawTextSize = Float.valueOf(textSize);
            this.invalidate();
        }

        public int getTextColor() {
            return this.textColor;
        }

        public void setTextColor(int textColor) {
            if (this.textColor.equals(textColor)) {
                return;
            }
            this.textColor = textColor;
            IDocumentLayout.this.onLayoutParamsChange();
        }

        public boolean isDebugging() {
            return this.debugging;
        }

        public void setDebugging(Boolean debugging) {
            if (this.debugging.equals(debugging)) {
                return;
            }
            this.debugging = debugging;
            IDocumentLayout.this.onLayoutParamsChange();
        }

        public boolean isTextSubPixel() {
            return this.subpixelText;
        }

        public void setTextSubPixel(boolean subpixelText) {
            if (this.subpixelText.equals(subpixelText)) {
                return;
            }
            this.subpixelText = subpixelText;
        }

        public boolean isAntiAlias() {
            return this.antialias;
        }

        public void setAntialias(boolean antialias) {
            if (this.antialias.equals(antialias)) {
                return;
            }
            this.antialias = antialias;
        }
    }

    public static interface ICancel<T> {
        public T isCancelled();
    }

    public static interface IProgress<T> {
        public void onUpdate(T var1);
    }

    public static enum TokenPosition {
        START_OF_LINE,
        END_OF_LINE;

    }
}

