/*
 * Decompiled with CFR 0.152.
 */
package com.bluejamesbond.text;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.style.LeadingMarginSpan;
import com.bluejamesbond.text.Console;
import com.bluejamesbond.text.IDocumentLayout;
import com.bluejamesbond.text.Styled;
import com.bluejamesbond.text.style.DirectionSpan;
import com.bluejamesbond.text.style.TextAlignment;
import com.bluejamesbond.text.style.TextAlignmentSpan;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.Assert;

public abstract class SpannableDocumentLayout
extends IDocumentLayout {
    private static final int TOKEN_START = 0;
    private static final int TOKEN_END = 1;
    private static final int TOKEN_X = 2;
    private static final int TOKEN_Y = 3;
    private static final int TOKEN_ASCENT = 4;
    private static final int TOKEN_DESCENT = 5;
    private static final int TOKEN_LINE = 6;
    private static final int TOKEN_LENGTH = 7;
    private TextPaint workPaint;
    private LinkedList<LeadingMarginSpanDrawParameters> mLeadMarginSpanDrawEvents;
    private int[] tokens;

    public SpannableDocumentLayout(Context context, TextPaint paint) {
        super(context, paint);
        this.workPaint = new TextPaint((Paint)paint);
        this.tokens = new int[0];
    }

    private static int pushToken(int[] tokens, int index, int start, int end, float x, float y, float ascent, float descent, int line) {
        Assert.assertTrue((index % 7 == 0 ? 1 : 0) != 0);
        tokens[index + 0] = start;
        tokens[index + 1] = end;
        tokens[index + 2] = (int)x;
        tokens[index + 3] = (int)y;
        tokens[index + 4] = (int)ascent;
        tokens[index + 5] = (int)descent;
        tokens[index + 6] = line;
        return index + 7;
    }

    private static int[] ammortizeArray(int[] array, int index) {
        if (index >= array.length) {
            int[] newArray = new int[array.length * 2];
            Arrays.fill(newArray, Integer.MAX_VALUE);
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    private static LinkedList<Integer> tokenize(CharSequence source, int start, int end) {
        LinkedList<Integer> units = new LinkedList<Integer>();
        if (start >= end) {
            return units;
        }
        boolean charSearch = source.charAt(start) == ' ';
        for (int i = start; i < end; ++i) {
            if (i + 1 == end) {
                units.add(i + 1);
                start = i + 1;
                continue;
            }
            if (charSearch && source.charAt(i) != ' ') {
                if (i - start > 0) {
                    units.add(i);
                }
                start = i;
                charSearch = false;
                continue;
            }
            if (charSearch || source.charAt(i) != ' ') continue;
            units.add(i);
            start = i + 1;
            charSearch = true;
        }
        return units;
    }

    protected int getTrimmedLength(CharSequence s, int start, int end) {
        int endCpy;
        while (start < end && s.charAt(start) <= ' ') {
            ++start;
        }
        for (endCpy = end; endCpy > start && s.charAt(endCpy - 1) <= ' '; --endCpy) {
        }
        return endCpy - start;
    }

    @Override
    public boolean onMeasure(IDocumentLayout.IProgress<Float> progress, IDocumentLayout.ICancel<Boolean> cancelled) {
        int lineNumber;
        boolean done = true;
        float parentWidth = this.params.getParentWidth();
        float boundWidth = this.params.getParentWidth() - this.params.getInsetPaddingLeft() - this.params.getInsetPaddingRight();
        this.mLeadMarginSpanDrawEvents = new LinkedList();
        StaticLayout staticLayout = new StaticLayout(this.getText(), (TextPaint)this.getPaint(), (int)boundWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        int[] newTokens = new int[7000];
        LeadingMarginSpan[] activeLeadSpans = new LeadingMarginSpan[]{};
        HashMap<LeadingMarginSpan, Integer> leadSpans = new HashMap<LeadingMarginSpan, Integer>();
        TextAlignment defAlign = this.params.textAlignment;
        Spannable textCpy = (Spannable)this.text;
        Paint.FontMetricsInt fmi = this.paint.getFontMetricsInt();
        int maxTextIndex = textCpy.length() - 1;
        int lines = staticLayout.getLineCount();
        int enableLineBreak = 0;
        int index = 0;
        float y = this.params.insetPaddingTop.floatValue();
        float left = this.params.insetPaddingLeft.floatValue();
        float right = this.params.insetPaddingRight.floatValue();
        float lineHeightAdd = this.params.lineHeightMultiplier.floatValue();
        boolean isParaStart = true;
        boolean isReverse = this.params.reverse;
        block5: for (lineNumber = 0; lineNumber < lines; ++lineNumber) {
            boolean isParaEnd;
            if (cancelled.isCancelled().booleanValue()) {
                done = false;
                break;
            }
            progress.onUpdate(Float.valueOf((float)lineNumber / (float)lines));
            newTokens = SpannableDocumentLayout.ammortizeArray(newTokens, index);
            int start = staticLayout.getLineStart(lineNumber);
            int end = staticLayout.getLineEnd(lineNumber);
            float realWidth = boundWidth;
            if (this.params.debugging.booleanValue()) {
                Console.log(start + " => " + end + " :: " + " " + -staticLayout.getLineAscent(lineNumber) + " " + staticLayout.getLineDescent(lineNumber) + " " + textCpy.subSequence(start, end).toString());
            }
            if (start == end || lineNumber >= this.params.maxLines) break;
            TextAlignmentSpan[] textAlignmentSpans = (TextAlignmentSpan[])textCpy.getSpans(start, end, TextAlignmentSpan.class);
            TextAlignment lineTextAlignment = textAlignmentSpans.length == 0 ? defAlign : textAlignmentSpans[0].getTextAlignment();
            float lastAscent = -staticLayout.getLineAscent(lineNumber);
            float lastDescent = (float)staticLayout.getLineDescent(lineNumber) + lineHeightAdd;
            DirectionSpan[] directionSpans = (DirectionSpan[])textCpy.getSpans(start, end, DirectionSpan.class);
            boolean bl = isReverse = directionSpans.length > 0 ? directionSpans[0].isReverse() : this.params.reverse.booleanValue();
            if (start + 1 == end && (Character.getNumericValue(textCpy.charAt(start)) == -1 || textCpy.charAt(start) == '\n')) {
                isParaStart = true;
                if (lineNumber + 1 < lines) {
                    y += (float)(enableLineBreak * (-staticLayout.getLineAscent(lineNumber + 1) + staticLayout.getLineDescent(lineNumber + 1)));
                }
                enableLineBreak = 1;
                continue;
            }
            enableLineBreak = 0;
            float x = lineTextAlignment == TextAlignment.RIGHT ? right : left;
            y += lastAscent;
            boolean bl2 = isParaEnd = end == maxTextIndex || textCpy.charAt(Math.min(end, maxTextIndex)) == '\n' || textCpy.charAt(end - 1) == '\n';
            if (isParaEnd) {
                enableLineBreak = 1;
            }
            if (isParaStart && (activeLeadSpans = (LeadingMarginSpan[])textCpy.getSpans(start, end, LeadingMarginSpan.class)).length > 0) {
                for (LeadingMarginSpan leadSpan : activeLeadSpans) {
                    if (leadSpans.containsKey(leadSpan)) continue;
                    int marginLineCount = -1;
                    if (leadSpan instanceof LeadingMarginSpan.LeadingMarginSpan2) {
                        LeadingMarginSpan.LeadingMarginSpan2 leadSpan2 = (LeadingMarginSpan.LeadingMarginSpan2)leadSpan;
                        marginLineCount = leadSpan2.getLeadingMarginLineCount();
                    }
                    leadSpans.put(leadSpan, marginLineCount);
                }
            }
            float totalMargin = 0.0f;
            int top = (int)(y - lastAscent);
            int baseline = (int)y;
            int bottom = (int)(y + lastDescent);
            for (LeadingMarginSpan leadSpan : activeLeadSpans) {
                int spanLines;
                float calcX = x;
                int lineAlignmentVal = 1;
                if (lineTextAlignment == TextAlignment.RIGHT) {
                    lineAlignmentVal = -1;
                    calcX = parentWidth - x;
                }
                if ((spanLines = ((Integer)leadSpans.get(leadSpan)).intValue()) <= 0 && spanLines != -1) continue;
                leadSpans.put(leadSpan, spanLines == -1 ? -1 : spanLines - 1);
                this.mLeadMarginSpanDrawEvents.add(new LeadingMarginSpanDrawParameters(leadSpan, (int)calcX, lineAlignmentVal, top, baseline, bottom, start, end, isParaStart));
                totalMargin += (float)leadSpan.getLeadingMargin(isParaStart);
            }
            x += totalMargin;
            realWidth -= totalMargin;
            isParaStart = isParaEnd;
            if (isParaEnd && lineTextAlignment == TextAlignment.JUSTIFIED) {
                TextAlignment textAlignment = lineTextAlignment = isReverse ? TextAlignment.RIGHT : TextAlignment.LEFT;
            }
            if (this.params.debugging.booleanValue()) {
                Console.log(String.format("Align: %s, X: %fpx, Y: %fpx, PWidth: %fpx", new Object[]{lineTextAlignment, Float.valueOf(x), Float.valueOf(y), Float.valueOf(parentWidth)}));
            }
            switch (lineTextAlignment) {
                case RIGHT: {
                    float lineWidth = Styled.measureText(this.paint, this.workPaint, (CharSequence)textCpy, start, end, fmi);
                    index = SpannableDocumentLayout.pushToken(newTokens, index, start, end, parentWidth - x - lineWidth, y, lastAscent, lastDescent, lineNumber);
                    y += lastDescent;
                    continue block5;
                }
                case CENTER: {
                    float lineWidth = Styled.measureText(this.paint, this.workPaint, (CharSequence)textCpy, start, end, fmi);
                    index = SpannableDocumentLayout.pushToken(newTokens, index, start, end, x + (realWidth - lineWidth) / 2.0f, y, lastAscent, lastDescent, lineNumber);
                    y += lastDescent;
                    continue block5;
                }
                case LEFT: {
                    index = SpannableDocumentLayout.pushToken(newTokens, index, start, end, x, y, lastAscent, lastDescent, lineNumber);
                    y += lastDescent;
                    continue block5;
                }
                default: {
                    LinkedList<Integer> tokenized = SpannableDocumentLayout.tokenize((CharSequence)textCpy, start, end);
                    if (tokenized.size() == 1) {
                        int stop = tokenized.get(0);
                        if (this.getTrimmedLength((CharSequence)textCpy, start, stop) != 0) {
                            float[] textWidths = new float[stop - start];
                            float sum = 0.0f;
                            float textsOffset = 0.0f;
                            int m = 0;
                            Styled.getTextWidths(this.paint, this.workPaint, (Spanned)textCpy, start, stop, textWidths, fmi);
                            for (float tw : textWidths) {
                                sum += tw;
                            }
                            float offset = (realWidth - sum) / (float)(textWidths.length - 1);
                            for (int k = start; k < stop; ++k) {
                                index = SpannableDocumentLayout.pushToken(newTokens, index, k, k + 1, x + textsOffset + offset * (float)m, y, lastAscent, lastDescent, lineNumber);
                                newTokens = SpannableDocumentLayout.ammortizeArray(newTokens, index);
                                textsOffset += textWidths[m++];
                            }
                        }
                    } else {
                        int m = 1;
                        int indexOffset = 0;
                        int startIndex = index;
                        int reqSpaces = (tokenized.size() - 1) * 7;
                        boolean rtlZero = false;
                        float rtlRight = 0.0f;
                        float rtlMul = 1.0f;
                        float lineWidth = 0.0f;
                        if (isReverse) {
                            indexOffset = -14;
                            rtlRight = parentWidth;
                            rtlMul = -1.0f;
                            rtlZero = true;
                            index += reqSpaces;
                        }
                        newTokens = SpannableDocumentLayout.ammortizeArray(newTokens, index + reqSpaces);
                        Iterator tw = tokenized.iterator();
                        while (tw.hasNext()) {
                            int stop = (Integer)tw.next();
                            float wordWidth = Styled.measureText(this.paint, this.workPaint, (CharSequence)textCpy, start, stop, fmi);
                            index = SpannableDocumentLayout.pushToken(newTokens, index, start, stop, rtlRight + rtlMul * (x + lineWidth + (float)rtlZero * wordWidth), y, lastAscent, lastDescent, lineNumber);
                            lineWidth += wordWidth;
                            start = stop + 1;
                            index += indexOffset;
                        }
                        if (isReverse) {
                            index = startIndex + reqSpaces + 7;
                        }
                        float offset = (realWidth - lineWidth) / (float)(tokenized.size() - 1);
                        if (isReverse) {
                            for (int pos = index - 14; pos >= startIndex; pos -= 7) {
                                newTokens[pos + 2] = (int)((float)newTokens[pos + 2] - offset * (float)m++);
                            }
                        } else {
                            for (int pos = startIndex + 7; pos < index; pos += 7) {
                                newTokens[pos + 2] = (int)((float)newTokens[pos + 2] + offset * (float)m++);
                            }
                        }
                    }
                    y += lastDescent;
                }
            }
        }
        this.lineCount = lineNumber;
        this.tokens = newTokens;
        this.params.changed = false;
        this.textChange = !done;
        this.measuredHeight = (int)(y - lineHeightAdd + this.params.insetPaddingBottom.floatValue());
        return done;
    }

    @Override
    public void onDraw(Canvas canvas, int scrollTop, int scrollBottom) {
        if (this.tokens.length < 7) {
            return;
        }
        Spannable textCpy = (Spannable)this.text;
        int startIndex = this.getTokenForVertical(scrollTop, IDocumentLayout.TokenPosition.START_OF_LINE);
        int endIndex = this.getTokenForVertical(scrollBottom, IDocumentLayout.TokenPosition.END_OF_LINE);
        boolean defIsReverse = false;
        for (LeadingMarginSpanDrawParameters parameters : this.mLeadMarginSpanDrawEvents) {
            int top = parameters.top - scrollTop;
            int bottom = parameters.bottom - scrollTop;
            if (bottom < 0 || top > scrollBottom) continue;
            parameters.span.drawLeadingMargin(canvas, (Paint)this.paint, parameters.x, parameters.dir, top, parameters.baseline, bottom, (CharSequence)textCpy, parameters.start, parameters.end, parameters.first, null);
        }
        int lastEndIndexY = this.tokens[endIndex + 3];
        int diffEndIndexYCount = 1;
        for (int s = endIndex; diffEndIndexYCount > 0 && s < this.tokens.length; s += 7) {
            endIndex += 7;
            if (lastEndIndexY == this.tokens[s + 3]) continue;
            --diffEndIndexYCount;
            lastEndIndexY = this.tokens[s + 3];
        }
        for (int index = startIndex; index < endIndex && this.tokens[index + 0] != Integer.MAX_VALUE; index += 7) {
            DirectionSpan[] directionSpans = (DirectionSpan[])textCpy.getSpans(this.tokens[index + 0], this.tokens[index + 1], DirectionSpan.class);
            Styled.drawText(canvas, (CharSequence)textCpy, this.tokens[index + 0], this.tokens[index + 1], 1, directionSpans.length > 0 ? directionSpans[0].isReverse() : defIsReverse, this.tokens[index + 2], 0, this.tokens[index + 3] - scrollTop, 0, this.paint, this.workPaint, false);
            if (!this.params.debugging.booleanValue()) continue;
            int lastColor = this.paint.getColor();
            float lastStrokeWidth = this.paint.getStrokeWidth();
            this.paint.setStrokeWidth(2.0f);
            this.paint.setColor(-16711936);
            canvas.drawLine(0.0f, (float)(this.tokens[index + 3] - this.tokens[index + 4] - scrollTop), this.params.parentWidth.floatValue(), (float)(this.tokens[index + 3] - this.tokens[index + 4] - scrollTop), (Paint)this.paint);
            this.paint.setColor(-16711681);
            canvas.drawLine(0.0f, (float)(this.tokens[index + 3] + this.tokens[index + 5] - scrollTop), this.params.parentWidth.floatValue(), (float)(this.tokens[index + 3] + this.tokens[index + 5] - scrollTop), (Paint)this.paint);
            this.paint.setColor(lastColor);
            this.paint.setStrokeWidth(lastStrokeWidth);
        }
    }

    @Override
    public float getTokenAscent(int tokenIndex) {
        return this.tokens[tokenIndex + 4];
    }

    @Override
    public float getTokenDescent(int tokenIndex) {
        return this.tokens[tokenIndex + 5];
    }

    @Override
    public int getTokenForVertical(float y, IDocumentLayout.TokenPosition position) {
        int s;
        int high = Math.max(0, this.tokens.length - 1);
        int low = 0;
        while (low + 1 < high) {
            int mid = (high + low) / 2;
            int midx = mid - mid % 7;
            int fY = this.tokens[midx + 3];
            if ((float)fY > y) {
                high = mid;
                continue;
            }
            low = mid;
        }
        switch (position) {
            default: {
                low -= low % 7;
                for (s = low; s > 0 && (float)this.tokens[s + 3] >= y; s -= 7) {
                    low -= 7;
                }
                return low;
            }
            case END_OF_LINE: 
        }
        high -= high % 7;
        s = high;
        while (s + 7 < this.tokens.length && (float)this.tokens[s + 3] <= y) {
            high += 7;
            s += 7;
        }
        return high;
    }

    @Override
    public int getLineForToken(int tokenIndex) {
        return this.tokens[tokenIndex + 6];
    }

    @Override
    public int getTokenStart(int tokenIndex) {
        return this.tokens[tokenIndex + 0];
    }

    @Override
    public int getTokenEnd(int tokenIndex) {
        return this.tokens[tokenIndex + 1];
    }

    @Override
    public float getTokenTopAt(int tokenIndex) {
        return this.tokens[tokenIndex + 3];
    }

    @Override
    public CharSequence getTokenTextAt(int index) {
        return this.text.subSequence(this.tokens[index + 0], this.tokens[index + 1]);
    }

    @Override
    public boolean isTokenized() {
        return this.tokens != null;
    }

    private class LeadingMarginSpanDrawParameters {
        public int x;
        public int top;
        public int baseline;
        public int bottom;
        public int dir;
        public int start;
        public int end;
        public boolean first;
        public LeadingMarginSpan span;

        public LeadingMarginSpanDrawParameters(LeadingMarginSpan span, int x, int dir, int top, int baseline, int bottom, int start, int end, boolean first) {
            this.span = span;
            this.x = x;
            this.dir = dir;
            this.top = top;
            this.baseline = baseline;
            this.bottom = bottom;
            this.start = start;
            this.end = end;
            this.first = first;
        }
    }
}

