/*
 * Decompiled with CFR 0.152.
 */
package com.bluejamesbond.text;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import com.bluejamesbond.text.ConcurrentModifiableLinkedList;
import com.bluejamesbond.text.IDocumentLayout;
import java.util.List;
import java.util.ListIterator;

public abstract class StringDocumentLayout
extends IDocumentLayout {
    private Token[] tokens = new Token[0];
    private ConcurrentModifiableLinkedList<String> chunks = new ConcurrentModifiableLinkedList();

    public StringDocumentLayout(Context context, TextPaint paint) {
        super(context, paint);
    }

    @Override
    public boolean onMeasure(IDocumentLayout.IProgress<Float> progress, IDocumentLayout.ICancel<Boolean> cancelled) {
        boolean done = true;
        String textCpy = this.text.toString();
        if (this.textChange) {
            this.chunks.clear();
            int start = 0;
            while (start > -1) {
                int next = textCpy.indexOf(10, start);
                if (next < 0) {
                    this.chunks.add(textCpy.substring(start, textCpy.length()));
                } else {
                    this.chunks.add(textCpy.substring(start, next++));
                }
                start = next;
            }
            this.textChange = false;
        }
        ConcurrentModifiableLinkedList<Token> tokensList = new ConcurrentModifiableLinkedList<Token>();
        Paint paint = this.getPaint();
        paint.setTextAlign(Paint.Align.LEFT);
        int lineNumber = 0;
        float width = this.params.parentWidth.floatValue() - this.params.insetPaddingRight.floatValue() - this.params.insetPaddingLeft.floatValue();
        float lineHeight = this.getTokenAscent(0) + this.getTokenDescent(0);
        float prog = 0.0f;
        float chunksLen = this.chunks.size();
        float y = this.params.insetPaddingTop.floatValue() + this.getTokenAscent(0);
        float spaceOffset = paint.measureText(" ") * this.params.wordSpacingMultiplier.floatValue();
        block6: for (String paragraph : this.chunks) {
            if (cancelled.isCancelled().booleanValue()) {
                done = false;
                break;
            }
            float f = prog;
            prog = f + 1.0f;
            progress.onUpdate(Float.valueOf(f / chunksLen));
            if (lineNumber >= this.params.maxLines) break;
            float x = this.params.insetPaddingLeft.floatValue();
            String trimParagraph = paragraph.trim();
            if (trimParagraph.length() == 0) {
                tokensList.add(new LineBreak(lineNumber++, y));
                y += lineHeight;
                continue;
            }
            float wrappedWidth = paint.measureText(trimParagraph);
            if (wrappedWidth < width) {
                tokensList.add(new SingleLine(lineNumber++, x, y, trimParagraph));
                y += lineHeight;
                continue;
            }
            int start = 0;
            boolean overallCounter = false;
            ConcurrentModifiableLinkedList<Unit> units = this.tokenize(paragraph);
            ListIterator unitIterator = units.listIterator();
            ListIterator<Unit> justifyIterator = units.listIterator();
            while (true) {
                x = this.params.insetPaddingLeft.floatValue();
                LineAnalysis format = this.fit(justifyIterator, start, spaceOffset, width);
                int tokenCount = format.end - format.start;
                boolean leftOverTokens = justifyIterator.hasNext();
                if (tokenCount == 0 && leftOverTokens) {
                    new PlainDocumentException("Cannot fit word(s) into one line. Font size too large?").printStackTrace();
                    done = false;
                    break block6;
                }
                float offset = 0.0f;
                switch (this.params.textAlignment) {
                    case CENTER: {
                        x += format.remainWidth / 2.0f;
                        break;
                    }
                    case RIGHT: {
                        x += format.remainWidth;
                        break;
                    }
                    case JUSTIFIED: {
                        offset = tokenCount > 2 && leftOverTokens ? format.remainWidth / (float)(tokenCount - 1) : 0.0f;
                        break;
                    }
                }
                for (int i = format.start; i < format.end; ++i) {
                    Unit unit = (Unit)unitIterator.next();
                    unit.x = x;
                    unit.y = y;
                    unit.lineNumber = lineNumber;
                    x += offset + paint.measureText(unit.unit) + spaceOffset;
                    tokensList.add(unit);
                }
                y += lineHeight;
                if (++lineNumber >= this.params.maxLines) break block6;
                if (cancelled.isCancelled().booleanValue()) {
                    done = false;
                    continue block6;
                }
                if (!leftOverTokens) continue block6;
                start = format.end;
            }
        }
        Token[] tokensArr = new Token[tokensList.size()];
        tokensList.toArray(tokensArr);
        tokensList.clear();
        this.lineCount = lineNumber;
        this.tokens = tokensArr;
        this.params.changed = !done;
        this.measuredHeight = (int)(y - this.getTokenAscent(0) + this.params.insetPaddingBottom.floatValue());
        return done;
    }

    @Override
    public void onDraw(Canvas canvas, int startTop, int startBottom) {
        int tokenStart = this.getTokenForVertical(startTop, IDocumentLayout.TokenPosition.START_OF_LINE);
        int tokenEnd = this.getTokenForVertical(startBottom, IDocumentLayout.TokenPosition.END_OF_LINE);
        for (int i = Math.max(0, tokenStart - 25); i < tokenEnd + 25 && i < this.tokens.length; ++i) {
            Token token = this.tokens[i];
            token.draw(canvas, -startTop, (Paint)this.paint, this.params);
            if (!this.params.debugging.booleanValue() || !(token instanceof LineBreak)) continue;
            int lastColor = this.paint.getColor();
            boolean lastFakeBold = this.paint.isFakeBoldText();
            Paint.Style lastStyle = this.paint.getStyle();
            Paint.Align lastAlign = this.paint.getTextAlign();
            this.paint.setColor(-256);
            this.paint.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.params.insetPaddingLeft.floatValue(), token.y - (float)startTop - this.getTokenAscent(0), this.params.parentWidth.floatValue() - this.params.insetPaddingRight.floatValue(), token.y - (float)startTop + this.getTokenDescent(0), (Paint)this.paint);
            this.paint.setColor(-16777216);
            this.paint.setFakeBoldText(true);
            this.paint.setTextAlign(Paint.Align.CENTER);
            canvas.drawText("LINEBREAK", this.params.insetPaddingLeft.floatValue() + (this.params.parentWidth.floatValue() - this.params.insetPaddingRight.floatValue() - this.params.insetPaddingLeft.floatValue()) / 2.0f, token.y - (float)startTop, (Paint)this.paint);
            this.paint.setStyle(lastStyle);
            this.paint.setColor(lastColor);
            this.paint.setTextAlign(lastAlign);
            this.paint.setFakeBoldText(lastFakeBold);
        }
    }

    @Override
    public float getTokenAscent(int tokenIndex) {
        return -this.paint.ascent() * this.params.lineHeightMultiplier.floatValue();
    }

    @Override
    public float getTokenDescent(int tokenIndex) {
        return this.paint.descent() * this.params.lineHeightMultiplier.floatValue();
    }

    @Override
    public int getTokenForVertical(float y, IDocumentLayout.TokenPosition position) {
        int s;
        int high = Math.max(0, this.tokens.length - 1);
        int low = 0;
        while (low + 1 < high) {
            int mid = (high + low) / 2;
            float fY = this.tokens[mid].getY();
            if (fY > y) {
                high = mid;
                continue;
            }
            low = mid;
        }
        switch (position) {
            default: {
                for (s = low; s > 0 && this.tokens[s].getY() >= y; --s) {
                    --low;
                }
                return low;
            }
            case END_OF_LINE: 
        }
        for (s = high; s < this.tokens.length && this.tokens[s].getY() <= y; ++s) {
            ++high;
        }
        return high;
    }

    @Override
    public int getLineForToken(int tokenIndex) {
        throw new RuntimeException("Use SpannableDocumentLayout for now. Method under construction.");
    }

    @Override
    public int getTokenStart(int tokenIndex) {
        throw new RuntimeException("Use SpannableDocumentLayout for now. Method under construction.");
    }

    @Override
    public int getTokenEnd(int tokenIndex) {
        throw new RuntimeException("Use SpannableDocumentLayout for now. Method under construction.");
    }

    @Override
    public float getTokenTopAt(int tokenIndex) {
        return this.tokens[tokenIndex].getY();
    }

    @Override
    public CharSequence getTokenTextAt(int index) {
        return this.tokens[index].toString();
    }

    @Override
    public boolean isTokenized() {
        return this.tokens != null;
    }

    private ConcurrentModifiableLinkedList<Unit> tokenize(String s) {
        ConcurrentModifiableLinkedList<Unit> units = new ConcurrentModifiableLinkedList<Unit>();
        if (s.trim().length() <= 1) {
            units.add(new Unit(s));
            return units;
        }
        int start = 0;
        boolean charSearch = s.charAt(0) == ' ';
        for (int i = 1; i < s.length(); ++i) {
            if (i + 1 == s.length()) {
                units.add(new Unit(s.substring(start, i + 1)));
                start = i + 1;
                continue;
            }
            if (charSearch && s.charAt(i) != ' ') {
                String substring = s.substring(start, i);
                if (substring.length() != 0) {
                    units.add(new Unit(s.substring(start, i)));
                }
                start = i;
                charSearch = false;
                continue;
            }
            if (charSearch || s.charAt(i) != ' ') continue;
            units.add(new Unit(s.substring(start, i)));
            start = i + 1;
            charSearch = true;
        }
        return units;
    }

    protected int getTrimmedLength(CharSequence s, int start, int end) {
        int endCpy;
        while (start < end && s.charAt(start) <= ' ') {
            ++start;
        }
        for (endCpy = end; endCpy > start && s.charAt(endCpy - 1) <= ' '; --endCpy) {
        }
        return endCpy - start;
    }

    private LineAnalysis fit(ListIterator<Unit> iterator, int startIndex, float spaceOffset, float availableWidth) {
        int i = startIndex;
        while (iterator.hasNext()) {
            Unit unit = iterator.next();
            String word = unit.unit;
            float wordWidth = this.paint.measureText(word);
            float remainingWidth = availableWidth - wordWidth;
            if (remainingWidth < 0.0f && word.trim().length() != 0) {
                if (this.params.hyphenated.booleanValue()) {
                    float lastFormattedPartialWidth = 0.0f;
                    String lastFormattedPartial = null;
                    String lastConcatPartial = null;
                    String concatPartial = "";
                    List<String> partials = this.params.hyphenator.hyphenate(word);
                    for (String partial : partials) {
                        String formattedPartial = (concatPartial = concatPartial + partial) + this.params.hyphen;
                        float formattedPartialWidth = this.paint.measureText(formattedPartial);
                        if (availableWidth - formattedPartialWidth > 0.0f) {
                            lastFormattedPartial = formattedPartial;
                            lastFormattedPartialWidth = formattedPartialWidth;
                            lastConcatPartial = concatPartial;
                            continue;
                        }
                        if (lastFormattedPartial == null) continue;
                        unit.unit = lastFormattedPartial;
                        iterator.add(new Unit(word.substring(lastConcatPartial.length())));
                        iterator.previous();
                        return new LineAnalysis(startIndex, i + 1, availableWidth -= lastFormattedPartialWidth);
                    }
                }
                iterator.previous();
                return new LineAnalysis(startIndex, i, availableWidth + spaceOffset);
            }
            availableWidth -= wordWidth + spaceOffset;
            if (remainingWidth == 0.0f) {
                return new LineAnalysis(startIndex, i + 1, availableWidth + spaceOffset);
            }
            ++i;
        }
        return new LineAnalysis(startIndex, i, availableWidth + spaceOffset);
    }

    private class LineAnalysis {
        public int start;
        public int end;
        public float remainWidth;

        public LineAnalysis(int start, int end, float remainWidth) {
            this.start = start;
            this.end = end;
            this.remainWidth = remainWidth;
        }
    }

    class PlainDocumentException
    extends Exception {
        public PlainDocumentException(String message) {
            super(message);
        }
    }

    private static class SingleLine
    extends Unit {
        public SingleLine(int lineNumber, float x, float y, String unit) {
            super(lineNumber, x, y, unit);
        }
    }

    private static class LineBreak
    extends Token {
        public LineBreak(int lineNumber, float y) {
            super(lineNumber, y);
        }

        @Override
        void draw(Canvas canvas, float offsetY, Paint paint, IDocumentLayout.LayoutParams params) {
        }

        public String toString() {
            return "\n";
        }
    }

    private static class Unit
    extends Token {
        public float x;
        public String unit;

        public Unit(String unit) {
            super(0, 0.0f);
            this.unit = unit;
        }

        public Unit(int lineNumber, float x, float y, String unit) {
            super(lineNumber, y);
            this.x = x;
            this.unit = unit;
        }

        @Override
        void draw(Canvas canvas, float offsetY, Paint paint, IDocumentLayout.LayoutParams params) {
            canvas.drawText(this.unit, this.x + params.getOffsetX(), this.y + params.getOffsetY() + offsetY, paint);
        }

        public String toString() {
            return this.unit;
        }
    }

    private static abstract class Token {
        public int lineNumber;
        public float y;

        public Token(int lineNumber, float y) {
            this.lineNumber = lineNumber;
            this.y = y;
        }

        public float getY() {
            return this.y;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        abstract void draw(Canvas var1, float var2, Paint var3, IDocumentLayout.LayoutParams var4);
    }
}

