/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.api;

import com.github.blutorange.bpmnspector.api.ValidationException;
import com.github.blutorange.bpmnspector.api.ValidationOption;
import com.github.blutorange.bpmnspector.api.ValidationResult;
import com.github.blutorange.bpmnspector.common.importer.BPMNProcess;
import com.github.blutorange.bpmnspector.common.importer.ProcessImporter;
import com.github.blutorange.bpmnspector.common.util.FileUtils;
import com.github.blutorange.bpmnspector.refcheck.BPMNReferenceValidator;
import com.github.blutorange.bpmnspector.schematron.SchematronBPMNValidator;
import com.github.blutorange.bpmnspector.validation.UnsortedValidationResult;
import com.github.blutorange.bpmnspector.validation.ValidationResultBuilder;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BPMNspector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BPMNspector.class.getSimpleName());
    private final ProcessImporter bpmnImporter;
    private final SchematronBPMNValidator extValidator = new SchematronBPMNValidator();
    private final BPMNReferenceValidator refValidator = new BPMNReferenceValidator();

    public BPMNspector() throws ValidationException {
        this.bpmnImporter = new ProcessImporter();
    }

    public List<ValidationResult> inspectDirectory(Path directory, List<ValidationOption> validationOptions) throws ValidationException {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List<Path> relevantFiles = FileUtils.getAllBpmnFileFromDirectory(directory);
        for (Path path : relevantFiles) {
            results.add(this.inspectFile(path, validationOptions));
        }
        return results;
    }

    public ValidationResult inspectFile(Path file, List<ValidationOption> validationOptions) throws ValidationException {
        UnsortedValidationResult result = new UnsortedValidationResult();
        BPMNProcess process = this.bpmnImporter.importProcessFromPath(file, result, false);
        result.setBpmnProcess(process);
        if (process == null) {
            LOGGER.warn("Process could not parsed correctly. Further processing is skipped.");
        } else {
            if (validationOptions.contains((Object)ValidationOption.REF)) {
                this.refValidator.validate(process, result);
            }
            if (validationOptions.contains((Object)ValidationOption.EXT)) {
                this.extValidator.validate(process, result);
            }
        }
        BPMNspector.logResult(result, file.getFileName().toString());
        return result;
    }

    public ValidationResult validate(String file) throws ValidationException {
        return this.validate(Paths.get(file, new String[0]));
    }

    public ValidationResult validate(Path path) throws ValidationException {
        ArrayList<ValidationOption> options = new ArrayList<ValidationOption>();
        options.add(ValidationOption.EXT);
        options.add(ValidationOption.REF);
        return this.inspectFile(path, options);
    }

    public ValidationResult validate(InputStream source, String resourceName) throws ValidationException {
        BPMNProcess process = this.bpmnImporter.importProcessFromStreamSource(source, resourceName, false);
        UnsortedValidationResult result = new UnsortedValidationResult();
        result.setBpmnProcess(process);
        if (process == null) {
            LOGGER.warn("Process could not parsed correctly. Further processing is skipped.");
        } else {
            this.refValidator.validate(process, result);
            this.extValidator.validate(process, result);
        }
        BPMNspector.logResult(result, resourceName);
        return result;
    }

    private static void logResult(ValidationResultBuilder result, String resourceName) {
        Object resultString = result.isValid() ? "valid" : "invalid";
        resultString = (String)resultString + (result.getWarnings().isEmpty() ? "" : " with warnings");
        LOGGER.debug("Overall result for '{}': {}", (Object)resourceName, resultString);
    }
}

