/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.api;

import com.github.blutorange.bpmnspector.api.LocationCoordinate;
import com.github.blutorange.bpmnspector.api.Resource;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;

public final class Location
implements Comparable<Location> {
    private final LocationCoordinate location;
    private final String xpath;
    private final Resource resource;

    public Location(Path filePath, LocationCoordinate location) {
        this.location = location;
        this.xpath = null;
        this.resource = new Resource(filePath);
    }

    public Location(Path filePath, LocationCoordinate location, String xpath) {
        this.location = location;
        this.xpath = xpath;
        this.resource = new Resource(filePath);
    }

    public Location(URL url, LocationCoordinate location) {
        this.location = location;
        this.xpath = null;
        this.resource = new Resource(url);
    }

    public Location(URL url, LocationCoordinate location, String xpath) {
        this.location = location;
        this.xpath = xpath;
        this.resource = new Resource(url);
    }

    public Location(Resource resource, LocationCoordinate location) {
        this.location = location;
        this.xpath = null;
        this.resource = resource;
    }

    public Location(Resource resource, LocationCoordinate location, String xpath) {
        this.location = location;
        this.xpath = xpath;
        this.resource = resource;
    }

    public LocationCoordinate getLocation() {
        return this.location != null ? this.location : LocationCoordinate.empty();
    }

    public String getXpath() {
        return this.xpath != null ? this.xpath : "";
    }

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public int compareTo(Location o) {
        Objects.requireNonNull(o);
        if (this.resource.equals(o.getResource())) {
            return this.getLocation().getId().compareTo(o.getLocation().getId());
        }
        return this.resource.compareTo(o.getResource());
    }

    public String toString() {
        return "Location{location=" + String.valueOf(this.location) + ", xpath=" + this.xpath + ", resource=" + String.valueOf(this.resource) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location1 = (Location)o;
        return Objects.equals(this.location, location1.location) && Objects.equals(this.xpath, location1.xpath) && Objects.equals(this.resource, location1.resource);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.xpath, this.resource);
    }
}

