/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.api;

public final class LocationCoordinate {
    private static final LocationCoordinate EMPTY = new LocationCoordinate(-1, -1);
    private final int row;
    private final int column;

    public LocationCoordinate(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public String getId() {
        return String.format("%d,%d", this.row, this.column);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationCoordinate location = (LocationCoordinate)o;
        if (this.column != location.column) {
            return false;
        }
        return this.row == location.row;
    }

    public int hashCode() {
        int result = this.row;
        result = 31 * result + this.column;
        return result;
    }

    public String toString() {
        return "Location{row=" + this.row + ", column=" + this.column + "}";
    }

    public static LocationCoordinate empty() {
        return EMPTY;
    }
}

