/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.api;

import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public final class Resource
implements Comparable<Resource> {
    private final String resourceName;
    private final URL url;
    private final Path path;
    private final ResourceType type;

    public Resource(Path path) {
        Objects.requireNonNull(path);
        this.path = path;
        this.resourceName = path.toAbsolutePath().toString();
        this.type = ResourceType.FILE;
        this.url = null;
    }

    public Resource(URL url) {
        Objects.requireNonNull(url);
        this.url = url;
        this.resourceName = url.toString();
        this.type = ResourceType.URL;
        this.path = null;
    }

    public Resource(String resourceName) {
        this.resourceName = resourceName;
        this.type = ResourceType.STREAM;
        this.path = null;
        this.url = null;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Optional<URL> getUrl() {
        return Optional.ofNullable(this.url);
    }

    public Optional<Path> getPath() {
        return Optional.ofNullable(this.path);
    }

    public ResourceType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        if (this.type != resource.type) {
            return false;
        }
        return this.resourceName.equals(resource.resourceName);
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }

    @Override
    public int compareTo(Resource resource) {
        Objects.requireNonNull(resource);
        return this.resourceName.compareTo(resource.getResourceName());
    }

    public String toString() {
        return this.resourceName;
    }

    public static enum ResourceType {
        URL,
        FILE,
        STREAM;

    }
}

