/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.api;

import com.github.blutorange.bpmnspector.api.AutoFixOptions;
import com.github.blutorange.bpmnspector.api.FixReport;
import com.github.blutorange.bpmnspector.api.Resource;
import com.github.blutorange.bpmnspector.api.Violation;
import com.github.blutorange.bpmnspector.api.Warning;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public interface ValidationResult {
    public FixReport<Void> autoFix(AutoFixOptions var1, Writer var2) throws IOException;

    public FixReport<Void> autoFix(AutoFixOptions var1, OutputStream var2) throws IOException;

    public FixReport<String> autoFix(AutoFixOptions var1);

    default public List<Path> getFilesWithViolations() {
        return this.getViolations().stream().map(v -> v.getLocation().getResource()).filter(r -> r.getType() == Resource.ResourceType.FILE && r.getPath().isPresent()).map(r -> r.getPath().get()).distinct().sorted().collect(Collectors.toList());
    }

    default public List<Path> getFoundFiles() {
        return this.getResources().stream().filter(r -> r.getType() == Resource.ResourceType.FILE && r.getPath().isPresent()).map(r -> r.getPath().get()).collect(Collectors.toList());
    }

    public List<Resource> getResources();

    default public List<Resource> getResourcesWithViolations() {
        return this.getViolations().stream().map(v -> v.getLocation().getResource()).distinct().sorted().collect(Collectors.toList());
    }

    default public List<String> getViolatedConstraints() {
        return this.getViolations().stream().map(Violation::getConstraint).distinct().sorted().collect(Collectors.toList());
    }

    public List<Violation> getViolations();

    public List<Warning> getWarnings();

    default public boolean isValid() {
        return this.getViolations().isEmpty();
    }
}

