/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.api;

import com.github.blutorange.bpmnspector.api.Location;
import java.util.Objects;

public final class Violation
implements Comparable<Violation> {
    private final String constraint;
    private final String message;
    private final Location location;

    public Violation(Location location, String message, String constraint) {
        this.location = Objects.requireNonNull(location);
        this.message = Objects.requireNonNull(message);
        this.constraint = Objects.requireNonNull(constraint);
    }

    public String getConstraint() {
        return this.constraint;
    }

    public String getMessage() {
        return this.message;
    }

    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return "Violation{constraint='" + this.constraint + "', message='" + this.message + "', indicator=" + String.valueOf(this.location) + "}";
    }

    @Override
    public int compareTo(Violation o) {
        Objects.requireNonNull(o);
        if (this.getConstraint().equals(o.getConstraint())) {
            if (this.getMessage().equals(o.getMessage())) {
                return this.getLocation().compareTo(o.getLocation());
            }
            return this.getMessage().compareTo(o.getMessage());
        }
        return this.getConstraint().compareTo(o.getConstraint());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Violation violation = (Violation)o;
        return Objects.equals(this.constraint, violation.constraint) && Objects.equals(this.message, violation.message) && Objects.equals(this.location, violation.location);
    }

    public int hashCode() {
        return Objects.hash(this.constraint, this.message, this.location);
    }
}

