/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.api;

import com.github.blutorange.bpmnspector.api.Location;
import java.util.Objects;

public final class Warning
implements Comparable<Warning> {
    private final String message;
    private final Location location;

    public Warning(String message, Location location) {
        this.message = Objects.requireNonNull(message);
        this.location = Objects.requireNonNull(location);
    }

    public String getMessage() {
        return this.message;
    }

    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return "Warning{message='" + this.message + "', indicator=" + String.valueOf(this.location) + "}";
    }

    @Override
    public int compareTo(Warning o) {
        Objects.requireNonNull(o);
        if (this.getMessage().equals(o.getMessage())) {
            return this.getLocation().compareTo(o.getLocation());
        }
        return this.getMessage().compareTo(o.getMessage());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Warning warning = (Warning)o;
        return Objects.equals(this.message, warning.message) && Objects.equals(this.location, warning.location);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.location);
    }
}

