/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.autofix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnXPathHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BpmnXPathHelper.class.getSimpleName());
    private final XPathFactory xPathFactory = XPathFactory.instance();
    private final List<String> FLOW_NODES_LIST_IN_OUT = Arrays.asList("exclusiveGateway", "inclusiveGateway", "parallelGateway", "complexGateway", "eventBasedGateway", "choreographyActivity", "choreographyTask", "subChoreography", "callChoreography", "task", "serviceTask", "sendTask", "receiveTask", "userTask", "manualTask", "scriptTask", "businessRuleTask", "subProcess", "adHocSubProcess", "transaction", "callActivity", "intermediateCatchEvent", "intermediateThrowEvent");
    private final List<String> FLOW_NODES_OUTGOING_ONLY = Arrays.asList("startEvent", "boundaryEvent");
    private final List<String> FLOW_NODES_INCOMING_ONLY = Collections.singletonList("endEvent");

    public Optional<Element> findSingleElementForXPath(Document document, String xPathExp) {
        XPathExpression expression = this.xPathFactory.compile(xPathExp, Filters.element(), null, new Namespace[]{Namespace.getNamespace((String)"bpmn", (String)"http://www.omg.org/spec/BPMN/20100524/MODEL")});
        List foundElements = expression.evaluate((Object)document);
        if (foundElements.isEmpty()) {
            LOGGER.warn("XPath expression '{}' returned an empty list.", (Object)xPathExp);
            return Optional.empty();
        }
        if (foundElements.size() > 1) {
            LOGGER.warn("XPath expression '{}' returned more than one hit - return the first one.", (Object)xPathExp);
        }
        return Optional.of((Element)foundElements.get(0));
    }

    public List<Element> findElementsForXPath(Document document, String xPathExp) {
        XPathExpression expression = this.xPathFactory.compile(xPathExp, Filters.element(), null, new Namespace[]{Namespace.getNamespace((String)"bpmn", (String)"http://www.omg.org/spec/BPMN/20100524/MODEL")});
        return expression.evaluate((Object)document);
    }

    public Optional<Element> findParentOfElementByNameRecursively(Element element, String nameOfParent) {
        Objects.requireNonNull(element, "Given element must not be null");
        Objects.requireNonNull(nameOfParent, "Given name of parent Element must not be null");
        while (element.getParentElement() != null) {
            if (nameOfParent.equals(element.getParentElement().getName())) {
                return Optional.of(element.getParentElement());
            }
            element = element.getParentElement();
        }
        return Optional.empty();
    }

    public String createRandomUniqueId() {
        return "id_" + String.valueOf(UUID.randomUUID());
    }

    public List<Element> determineFlowNodesWithNeededIncomingFlow(Element baseElem) {
        Objects.requireNonNull(baseElem);
        ArrayList<String> relevantElemNames = new ArrayList<String>(this.FLOW_NODES_LIST_IN_OUT);
        relevantElemNames.addAll(this.FLOW_NODES_INCOMING_ONLY);
        return this.findAllElementsByNameList(baseElem, relevantElemNames);
    }

    public List<Element> determineFlowNodesWithNeededOutgoingFlow(Element baseElem) {
        Objects.requireNonNull(baseElem);
        ArrayList<String> relevantElemNames = new ArrayList<String>(this.FLOW_NODES_LIST_IN_OUT);
        relevantElemNames.addAll(this.FLOW_NODES_OUTGOING_ONLY);
        return this.findAllElementsByNameList(baseElem, relevantElemNames);
    }

    private List<Element> findAllElementsByNameList(Element baseElem, List<String> names) {
        return baseElem.getChildren().stream().filter(e -> names.contains(e.getName())).collect(Collectors.toList());
    }

    public void insertOutgoingElementToFlowNode(Element flowNode, String outgoingIDREF) {
        Element newSubElem = new Element("outgoing", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        newSubElem.setText(outgoingIDREF);
        int index = this.determineIndexForElementInsertion(flowNode);
        if (index > flowNode.getChildren().size()) {
            flowNode.addContent((Content)newSubElem);
        } else {
            flowNode.addContent(index, (Content)newSubElem);
        }
    }

    public void insertIncomingElementToFlowNode(Element flowNode, String incomingIDREF) {
        Element newSubElem = new Element("incoming", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        newSubElem.setText(incomingIDREF);
        int index = this.determineIndexForElementInsertion(flowNode);
        if (index > flowNode.getChildren().size()) {
            flowNode.addContent((Content)newSubElem);
        } else {
            flowNode.addContent(index, (Content)newSubElem);
        }
    }

    public Element createSequenceFlow(String sourceRefID, String targetRefId) {
        Element sequenceFlow = new Element("sequenceFlow", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        sequenceFlow.setAttribute("id", this.createRandomUniqueId());
        sequenceFlow.setAttribute("sourceRef", sourceRefID);
        sequenceFlow.setAttribute("targetRef", targetRefId);
        return sequenceFlow;
    }

    public void createAndAddSequenceFlow(Element processToUse, Element source, Element target) {
        Element sequenceFlow = this.createSequenceFlow(source.getAttributeValue("id"), target.getAttributeValue("id"));
        processToUse.addContent((Content)sequenceFlow);
        this.insertOutgoingElementToFlowNode(source, sequenceFlow.getAttributeValue("id"));
        this.insertIncomingElementToFlowNode(target, sequenceFlow.getAttributeValue("id"));
    }

    private int determineIndexForElementInsertion(Element parent) {
        List<String> allowedElementsBefore = Arrays.asList("incoming", "categoryValueRef", "monitoring", "auditing", "extensionElements", "documentation");
        List children = parent.getChildren();
        for (String str : allowedElementsBefore) {
            List relevantElements = children.stream().filter(c -> c.getName().equals(str)).collect(Collectors.toList());
            if (relevantElements.isEmpty()) continue;
            return parent.indexOf((Content)relevantElements.get(relevantElements.size() - 1)) + 1;
        }
        return 0;
    }
}

