/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.autofix;

import com.github.blutorange.bpmnspector.api.Violation;
import com.github.blutorange.bpmnspector.autofix.FixReportBuilder;
import com.github.blutorange.bpmnspector.autofix.FixerRepository;
import com.github.blutorange.bpmnspector.autofix.FixingStrategy;
import com.github.blutorange.bpmnspector.autofix.ViolationFixer;
import com.github.blutorange.bpmnspector.common.importer.BPMNProcess;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jdom2.Document;

public class ConstraintFixer {
    private final BPMNProcess baseProcess;
    private final Map<Violation, FixingStrategy> foundViolations;
    private final FixerRepository fixerRepository;
    private final FixReportBuilder globalFixReport;
    private final Document documentClone;

    public ConstraintFixer(BPMNProcess processToFix, Map<Violation, FixingStrategy> foundViolations) {
        Objects.requireNonNull(processToFix, "BPMNProcess to fix must not be null");
        Objects.requireNonNull(foundViolations, "List of violations must not be null");
        this.baseProcess = processToFix;
        this.documentClone = this.baseProcess.getProcessAsDoc().clone();
        this.foundViolations = foundViolations;
        this.fixerRepository = new FixerRepository();
        this.globalFixReport = new FixReportBuilder();
    }

    public void fixAllPossibleIssues() {
        List usedFixers = this.foundViolations.entrySet().stream().map(e -> {
            if (e.getValue() == FixingStrategy.IGNORE) {
                return List.of();
            }
            if (e.getValue() == FixingStrategy.AUTO_FIX) {
                return this.fixerRepository.getAllFixersForConstraint(((Violation)e.getKey()).getConstraint());
            }
            return this.fixerRepository.getFixerForConstraintAndStrategy(((Violation)e.getKey()).getConstraint(), (FixingStrategy)((Object)((Object)e.getValue()))).map(List::of).orElseGet(List::of);
        }).flatMap(Collection::stream).collect(Collectors.toList());
        for (ViolationFixer fixer : usedFixers) {
            List<Violation> matchingViolations = this.foundViolations.entrySet().stream().filter(e -> ((Violation)e.getKey()).getConstraint().equals(fixer.getConstraintId())).filter(e -> e.getValue() == FixingStrategy.AUTO_FIX ? fixer.getSupportedStrategy() == FixingStrategy.FIRST_OPTION : ((FixingStrategy)((Object)((Object)e.getValue()))).equals((Object)fixer.getSupportedStrategy())).map(Map.Entry::getKey).collect(Collectors.toList());
            FixReportBuilder report = fixer.fixIssues(this.documentClone, matchingViolations);
            report.getFixedViolations().forEach(this.globalFixReport::addFixedViolation);
        }
    }

    public BPMNProcess fixAllPossibleIssuesAndReturnProcess() {
        this.fixAllPossibleIssues();
        return this.getFixedProcess();
    }

    public BPMNProcess getFixedProcess() {
        return new BPMNProcess(this.documentClone, this.baseProcess.getBaseURI(), this.baseProcess.getNamespace());
    }

    public FixReportBuilder getGlobalFixReport() {
        return this.globalFixReport;
    }
}

