/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.autofix;

import com.github.blutorange.bpmnspector.autofix.BpmnXPathHelper;
import com.github.blutorange.bpmnspector.autofix.FixerIdentifier;
import com.github.blutorange.bpmnspector.autofix.FixingStrategy;
import com.github.blutorange.bpmnspector.autofix.ViolationFixer;
import java.util.List;
import java.util.Optional;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EXT012SecondOptionMarkFormalExpFixer
implements ViolationFixer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EXT012SecondOptionMarkFormalExpFixer.class.getSimpleName());
    private static final String CONSTRAINT_ID = "EXT.012";
    private static final FixingStrategy SUPPORTED_STRATEGY = FixingStrategy.SECOND_OPTION;
    private final BpmnXPathHelper bpmnXPathHelper = new BpmnXPathHelper();

    @Override
    public String getConstraintId() {
        return CONSTRAINT_ID;
    }

    @Override
    public FixingStrategy getSupportedStrategy() {
        return SUPPORTED_STRATEGY;
    }

    @Override
    public String getDescription() {
        return "Marks the affected expression as a 'FormalExpression'";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public boolean fixSingleViolation(Document docToFix, String xPath) {
        Optional<Element> elementOptional = this.bpmnXPathHelper.findSingleElementForXPath(docToFix, xPath);
        if (elementOptional.isEmpty()) {
            LOGGER.warn("Could not fix EXT.012 violation: affected Element was not found");
            return false;
        }
        Element affectedElement = elementOptional.get();
        String elementName = affectedElement.getName();
        String usedBpmnNspPrefix = affectedElement.getNamespacePrefix();
        switch (elementName) {
            case "adHocSubProcess": {
                this.addAttributeToChild(affectedElement, "completionCondition");
                break;
            }
            case "assignment": {
                this.addAttributeToChild(affectedElement, "from");
                this.addAttributeToChild(affectedElement, "to");
                break;
            }
            case "complexGateway": {
                this.addAttributeToChild(affectedElement, "activationCondition");
                break;
            }
            case "multiInstanceLoopCharacteristics": {
                this.addAttributeToMultiLoopCharacteristics(affectedElement);
                break;
            }
            case "sequenceFlow": {
                this.addAttributeToChild(affectedElement, "conditionExpression");
                break;
            }
            case "standardLoopCharacteristics": {
                this.addAttributeToChild(affectedElement, "loopCondition");
                break;
            }
            case "timerEventDefinition": {
                this.addAttributeToTimerEventDef(affectedElement);
            }
        }
        return true;
    }

    private void addAttributeToTimerEventDef(Element affectedElement) {
        List children = affectedElement.getChildren();
        for (Element child : children) {
            if ("timeCycle".equals(child.getName())) {
                this.addAttributeToChild(affectedElement, "timeCycle");
                continue;
            }
            if ("timeDate".equals(child.getName())) {
                this.addAttributeToChild(affectedElement, "timeDate");
                continue;
            }
            if (!"timeDuration".equals(child.getName())) continue;
            this.addAttributeToChild(affectedElement, "timeDuration");
        }
    }

    private void addAttributeToMultiLoopCharacteristics(Element affectedElement) {
        List children = affectedElement.getChildren();
        for (Element child : children) {
            if ("completionCondition".equals(child.getName())) {
                this.addAttributeToChild(affectedElement, "loopCardinality");
            }
            if (!"loopCardinality".equals(child.getName())) continue;
            this.addAttributeToChild(affectedElement, "completionCondition");
        }
    }

    public static FixerIdentifier getFixerIdentifier() {
        return new FixerIdentifier(CONSTRAINT_ID, SUPPORTED_STRATEGY);
    }

    private void addAttributeToChild(Element elementToUse, String nameOfChild) {
        Element childToUse = elementToUse.getChild(nameOfChild, Namespace.getNamespace((String)"http://www.omg.org/spec/BPMN/20100524/MODEL"));
        if (childToUse != null) {
            childToUse.setAttribute("type", childToUse.getNamespacePrefix() + "tFormalExpression", this.getXSINamespace(childToUse));
        }
    }

    private Namespace getXSINamespace(Element element) {
        List allNamespaces = element.getAdditionalNamespaces();
        for (Namespace nsp : allNamespaces) {
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(nsp.getURI())) continue;
            return nsp;
        }
        return Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    }
}

