/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.autofix;

import com.github.blutorange.bpmnspector.autofix.BpmnXPathHelper;
import com.github.blutorange.bpmnspector.autofix.FixerIdentifier;
import com.github.blutorange.bpmnspector.autofix.FixingStrategy;
import com.github.blutorange.bpmnspector.autofix.ViolationFixer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EXT097AutoFixer
implements ViolationFixer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EXT097AutoFixer.class.getSimpleName());
    private static final String CONSTRAINT_ID = "EXT.097";
    private static final FixingStrategy SUPPORTED_STRATEGY = FixingStrategy.FIRST_OPTION;
    private final BpmnXPathHelper bpmnXPathHelper = new BpmnXPathHelper();

    @Override
    public String getConstraintId() {
        return CONSTRAINT_ID;
    }

    @Override
    public FixingStrategy getSupportedStrategy() {
        return SUPPORTED_STRATEGY;
    }

    @Override
    public String getDescription() {
        return "creates a new StartEvent which is connected via a Parallel Gateway to all unconnected Element";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public boolean fixSingleViolation(Document processAsDoc, String xPath) {
        Optional<Element> elementOptional = this.bpmnXPathHelper.findSingleElementForXPath(processAsDoc, xPath);
        if (elementOptional.isEmpty()) {
            return false;
        }
        Element parentProcessElement = elementOptional.get().getParentElement();
        Element newStart = new Element("startEvent", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        newStart.setAttribute("id", this.bpmnXPathHelper.createRandomUniqueId());
        newStart.setAttribute("name", "Auto-created StartEvent");
        parentProcessElement.addContent((Content)newStart);
        List<Element> childrenWithNeededIncomingSeqFlow = this.bpmnXPathHelper.determineFlowNodesWithNeededIncomingFlow(parentProcessElement);
        List unconnectedElems = childrenWithNeededIncomingSeqFlow.stream().filter(e -> e.getChild("incoming", Namespace.getNamespace((String)"http://www.omg.org/spec/BPMN/20100524/MODEL")) == null).collect(Collectors.toList());
        if (unconnectedElems.size() == 1) {
            this.bpmnXPathHelper.createAndAddSequenceFlow(parentProcessElement, newStart, (Element)unconnectedElems.get(0));
        } else if (unconnectedElems.size() > 1) {
            Element parallelGateway = new Element("parallelGateway", "http://www.omg.org/spec/BPMN/20100524/MODEL");
            parallelGateway.setAttribute("id", this.bpmnXPathHelper.createRandomUniqueId());
            parallelGateway.setAttribute("name", "Auto-created Gateway");
            parentProcessElement.addContent((Content)parallelGateway);
            this.bpmnXPathHelper.createAndAddSequenceFlow(parentProcessElement, newStart, parallelGateway);
            for (Element unconnected : unconnectedElems) {
                this.bpmnXPathHelper.createAndAddSequenceFlow(parentProcessElement, parallelGateway, unconnected);
            }
        } else {
            LOGGER.warn("No unconnected element found.");
            return false;
        }
        return true;
    }

    public static FixerIdentifier getFixerIdentifier() {
        return new FixerIdentifier(CONSTRAINT_ID, SUPPORTED_STRATEGY);
    }
}

