/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.autofix;

import com.github.blutorange.bpmnspector.autofix.BpmnXPathHelper;
import com.github.blutorange.bpmnspector.autofix.FixerIdentifier;
import com.github.blutorange.bpmnspector.autofix.FixingStrategy;
import com.github.blutorange.bpmnspector.autofix.ViolationFixer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EXT098RemoveInvalidTypeFixer
implements ViolationFixer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EXT098RemoveInvalidTypeFixer.class.getSimpleName());
    private static final String CONSTRAINT_ID = "EXT.098";
    private static final FixingStrategy SUPPORTED_STRATEGY = FixingStrategy.FIRST_OPTION;
    private final BpmnXPathHelper bpmnXPathHelper = new BpmnXPathHelper();
    private final List<String> INVALID_START_EVENT_DEFINITIONS = Arrays.asList("cancelEventDefinition", "escalationEventDefinition", "errorEventDefinition", "compensateEventDefinition", "linkEventDefinition", "terminateEventDefinition");

    @Override
    public String getConstraintId() {
        return CONSTRAINT_ID;
    }

    @Override
    public FixingStrategy getSupportedStrategy() {
        return SUPPORTED_STRATEGY;
    }

    @Override
    public String getDescription() {
        return "Removes the invalid EventDefinition - resulting in a 'None StartEvent'";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public boolean fixSingleViolation(Document processAsDoc, String xPath) {
        Optional<Element> elementOptional = this.bpmnXPathHelper.findSingleElementForXPath(processAsDoc, xPath);
        if (elementOptional.isEmpty()) {
            return false;
        }
        Element affectedStartEvent = elementOptional.get();
        List<Element> elemsToRemove = affectedStartEvent.getChildren().stream().filter(e -> this.INVALID_START_EVENT_DEFINITIONS.contains(e.getName())).collect(Collectors.toList());
        elemsToRemove.forEach(e -> affectedStartEvent.removeChild(e.getName(), Namespace.getNamespace((String)"http://www.omg.org/spec/BPMN/20100524/MODEL")));
        return true;
    }

    public static FixerIdentifier getFixerIdentifier() {
        return new FixerIdentifier(CONSTRAINT_ID, SUPPORTED_STRATEGY);
    }
}

