/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.autofix;

import com.github.blutorange.bpmnspector.autofix.BpmnXPathHelper;
import com.github.blutorange.bpmnspector.autofix.FixerIdentifier;
import com.github.blutorange.bpmnspector.autofix.FixingStrategy;
import com.github.blutorange.bpmnspector.autofix.ViolationFixer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EXT105AutoFixer
implements ViolationFixer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EXT105AutoFixer.class.getSimpleName());
    private static final String CONSTRAINT_ID = "EXT.105";
    private static final FixingStrategy SUPPORTED_STRATEGY = FixingStrategy.FIRST_OPTION;
    private final BpmnXPathHelper bpmnXPathHelper = new BpmnXPathHelper();

    @Override
    public String getConstraintId() {
        return CONSTRAINT_ID;
    }

    @Override
    public FixingStrategy getSupportedStrategy() {
        return SUPPORTED_STRATEGY;
    }

    @Override
    public String getDescription() {
        return "creates and links to a new EndEvent for the unconnected Element";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public boolean fixSingleViolation(Document processAsDoc, String xPath) {
        Optional<Element> elementOptional = this.bpmnXPathHelper.findSingleElementForXPath(processAsDoc, xPath);
        if (elementOptional.isEmpty()) {
            return false;
        }
        Element parentProcessElement = elementOptional.get().getParentElement();
        Element newEnd = new Element("endEvent", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        newEnd.setAttribute("id", this.bpmnXPathHelper.createRandomUniqueId());
        newEnd.setAttribute("name", "Auto-created EndEvent");
        parentProcessElement.addContent((Content)newEnd);
        List<Element> childrenWithNeededOutgoingSeqFlow = this.bpmnXPathHelper.determineFlowNodesWithNeededOutgoingFlow(parentProcessElement);
        List unconnectedElems = childrenWithNeededOutgoingSeqFlow.stream().filter(e -> e.getChild("outgoing", Namespace.getNamespace((String)"http://www.omg.org/spec/BPMN/20100524/MODEL")) == null).collect(Collectors.toList());
        for (Element unconnected : unconnectedElems) {
            this.bpmnXPathHelper.createAndAddSequenceFlow(parentProcessElement, unconnected, newEnd);
        }
        return true;
    }

    public static FixerIdentifier getFixerIdentifier() {
        return new FixerIdentifier(CONSTRAINT_ID, SUPPORTED_STRATEGY);
    }
}

