/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.autofix;

import com.github.blutorange.bpmnspector.autofix.BpmnXPathHelper;
import com.github.blutorange.bpmnspector.autofix.FixerIdentifier;
import com.github.blutorange.bpmnspector.autofix.FixingStrategy;
import com.github.blutorange.bpmnspector.autofix.ViolationFixer;
import java.util.Optional;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EXT128AutoFixer
implements ViolationFixer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EXT128AutoFixer.class.getSimpleName());
    private static final String CONSTRAINT_ID = "EXT.128";
    private static final FixingStrategy SUPPORTED_STRATEGY = FixingStrategy.FIRST_OPTION;
    private final BpmnXPathHelper bpmnXPathHelper = new BpmnXPathHelper();

    @Override
    public String getConstraintId() {
        return CONSTRAINT_ID;
    }

    @Override
    public FixingStrategy getSupportedStrategy() {
        return SUPPORTED_STRATEGY;
    }

    @Override
    public String getDescription() {
        return "sets the 'isExecutable' attribute of the process to false";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public boolean fixSingleViolation(Document processAsDoc, String xPath) {
        Optional<Element> elementOptional = this.bpmnXPathHelper.findSingleElementForXPath(processAsDoc, xPath);
        if (elementOptional.isEmpty()) {
            LOGGER.warn("Could not fix EXT.128 violation: affected MessageEventDefinition was not found");
            return false;
        }
        Element elem = elementOptional.get();
        Optional<Element> optionalParent = this.bpmnXPathHelper.findParentOfElementByNameRecursively(elem, "process");
        if (optionalParent.isEmpty()) {
            return false;
        }
        Element processElem = optionalParent.get();
        processElem.setAttribute("isExecutable", "false");
        LOGGER.debug("Set isExecutable attribute of element {} to false", (Object)processElem);
        return true;
    }

    public static FixerIdentifier getFixerIdentifier() {
        return new FixerIdentifier(CONSTRAINT_ID, SUPPORTED_STRATEGY);
    }
}

