/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.autofix;

import com.github.blutorange.bpmnspector.autofix.BpmnXPathHelper;
import com.github.blutorange.bpmnspector.autofix.FixerIdentifier;
import com.github.blutorange.bpmnspector.autofix.FixingStrategy;
import com.github.blutorange.bpmnspector.autofix.ViolationFixer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EXT150AutoFixer
implements ViolationFixer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EXT150AutoFixer.class.getSimpleName());
    private static final String CONSTRAINT_ID = "EXT.150";
    private static final FixingStrategy SUPPORTED_STRATEGY = FixingStrategy.FIRST_OPTION;
    private final BpmnXPathHelper bpmnXPathHelper = new BpmnXPathHelper();

    @Override
    public String getConstraintId() {
        return CONSTRAINT_ID;
    }

    @Override
    public FixingStrategy getSupportedStrategy() {
        return SUPPORTED_STRATEGY;
    }

    @Override
    public String getDescription() {
        return "Connects all elements not having an incoming SequenceFlow to the StartEvents of the Process (via a ParallelGateway)";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public boolean fixSingleViolation(Document processAsDoc, String xPath) {
        Optional<Element> elementOptional = this.bpmnXPathHelper.findSingleElementForXPath(processAsDoc, xPath);
        if (elementOptional.isEmpty()) {
            return false;
        }
        Element unconnectedElement = elementOptional.get();
        Element parentProcessElement = unconnectedElement.getParentElement();
        List startEvents = parentProcessElement.getChildren().stream().filter(e -> e.getName().equals("startEvent")).collect(Collectors.toList());
        for (Element startEvent : startEvents) {
            List outgoingSeqFlowIds = startEvent.getChildren("outgoing", Namespace.getNamespace((String)"http://www.omg.org/spec/BPMN/20100524/MODEL")).stream().map(Element::getText).collect(Collectors.toList());
            startEvent.removeChildren("outgoing", Namespace.getNamespace((String)"http://www.omg.org/spec/BPMN/20100524/MODEL"));
            Element parallelGateway = new Element("parallelGateway", "http://www.omg.org/spec/BPMN/20100524/MODEL");
            parallelGateway.setAttribute("id", this.bpmnXPathHelper.createRandomUniqueId());
            parallelGateway.setAttribute("gatewayDirection", "Diverging");
            parallelGateway.setAttribute("name", "Auto-created Parallel Gateway");
            parentProcessElement.addContent((Content)parallelGateway);
            this.bpmnXPathHelper.createAndAddSequenceFlow(parentProcessElement, startEvent, parallelGateway);
            this.bpmnXPathHelper.createAndAddSequenceFlow(parentProcessElement, parallelGateway, unconnectedElement);
            for (String seqFlowId : outgoingSeqFlowIds) {
                Element oldSeqFlow = parentProcessElement.getChildren("sequenceFlow", Namespace.getNamespace((String)"http://www.omg.org/spec/BPMN/20100524/MODEL")).stream().filter(e -> seqFlowId.equals(e.getAttributeValue("id"))).findFirst().orElseThrow(() -> new IllegalStateException("ID '" + seqFlowId + "' does not exist."));
                oldSeqFlow.setAttribute("sourceRef", parallelGateway.getAttributeValue("id"));
                this.bpmnXPathHelper.insertOutgoingElementToFlowNode(parallelGateway, seqFlowId);
            }
        }
        return true;
    }

    public static FixerIdentifier getFixerIdentifier() {
        return new FixerIdentifier(CONSTRAINT_ID, SUPPORTED_STRATEGY);
    }
}

