/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.autofix;

import com.github.blutorange.bpmnspector.autofix.EXT012FirstOptionNotExecutableFixer;
import com.github.blutorange.bpmnspector.autofix.EXT012SecondOptionMarkFormalExpFixer;
import com.github.blutorange.bpmnspector.autofix.EXT097AutoFixer;
import com.github.blutorange.bpmnspector.autofix.EXT098RemoveInvalidTypeFixer;
import com.github.blutorange.bpmnspector.autofix.EXT105AutoFixer;
import com.github.blutorange.bpmnspector.autofix.EXT106RemoveInvalidTypeFixer;
import com.github.blutorange.bpmnspector.autofix.EXT128AutoFixer;
import com.github.blutorange.bpmnspector.autofix.EXT150AutoFixer;
import com.github.blutorange.bpmnspector.autofix.EXT151AutoFixer;
import com.github.blutorange.bpmnspector.autofix.FixerIdentifier;
import com.github.blutorange.bpmnspector.autofix.FixingStrategy;
import com.github.blutorange.bpmnspector.autofix.ViolationFixer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class FixerRepository {
    private final Map<FixerIdentifier, ViolationFixer> availableFixes = new HashMap<FixerIdentifier, ViolationFixer>();

    public FixerRepository() {
        this.registerExistingFixers();
    }

    private void registerExistingFixers() {
        this.availableFixes.put(EXT012FirstOptionNotExecutableFixer.getFixerIdentifier(), new EXT012FirstOptionNotExecutableFixer());
        this.availableFixes.put(EXT012SecondOptionMarkFormalExpFixer.getFixerIdentifier(), new EXT012SecondOptionMarkFormalExpFixer());
        this.availableFixes.put(EXT098RemoveInvalidTypeFixer.getFixerIdentifier(), new EXT098RemoveInvalidTypeFixer());
        this.availableFixes.put(EXT097AutoFixer.getFixerIdentifier(), new EXT097AutoFixer());
        this.availableFixes.put(EXT105AutoFixer.getFixerIdentifier(), new EXT105AutoFixer());
        this.availableFixes.put(EXT106RemoveInvalidTypeFixer.getFixerIdentifier(), new EXT098RemoveInvalidTypeFixer());
        this.availableFixes.put(EXT128AutoFixer.getFixerIdentifier(), new EXT128AutoFixer());
        this.availableFixes.put(EXT150AutoFixer.getFixerIdentifier(), new EXT150AutoFixer());
        this.availableFixes.put(EXT151AutoFixer.getFixerIdentifier(), new EXT151AutoFixer());
    }

    public Optional<ViolationFixer> getFixerForConstraintAndStrategy(String constraintId, FixingStrategy strategy) {
        FixerIdentifier identifier = new FixerIdentifier(constraintId, strategy);
        return Optional.ofNullable(this.availableFixes.get(identifier));
    }

    public ViolationFixer getFirstFixerForConstraint(String constraintId) {
        return this.availableFixes.entrySet().stream().filter(entry -> ((FixerIdentifier)entry.getKey()).constraintId.equals(constraintId)).filter(entry -> ((FixerIdentifier)entry.getKey()).fixingStrategy == FixingStrategy.FIRST_OPTION).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public List<ViolationFixer> getAllFixersForConstraint(String constraintId) {
        return this.availableFixes.entrySet().stream().filter(entry -> ((FixerIdentifier)entry.getKey()).constraintId.equals(constraintId)).map(Map.Entry::getValue).collect(Collectors.toList());
    }
}

