/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.autofix;

import com.github.blutorange.bpmnspector.api.Violation;
import com.github.blutorange.bpmnspector.autofix.FixReportBuilder;
import com.github.blutorange.bpmnspector.autofix.FixingStrategy;
import java.util.List;
import org.jdom2.Document;
import org.slf4j.Logger;

public interface ViolationFixer {
    public String getConstraintId();

    public FixingStrategy getSupportedStrategy();

    public String getDescription();

    public Logger getLogger();

    public boolean fixSingleViolation(Document var1, String var2);

    default public FixReportBuilder fixIssues(Document docToFix, List<Violation> violationList) {
        if (violationList.isEmpty()) {
            return FixReportBuilder.createUnchangedFixReport();
        }
        FixReportBuilder report = new FixReportBuilder();
        for (Violation singleViolation : violationList) {
            if (!this.getConstraintId().equals(singleViolation.getConstraint())) {
                this.getLogger().warn("Invalid violation for {} fixer, constraint ID is: {}", (Object)this.getConstraintId(), (Object)singleViolation.getConstraint());
            }
            if (singleViolation.getLocation().getXpath().isEmpty()) {
                this.getLogger().warn("Could not fix {} violation {}: no XPath present.", (Object)this.getConstraintId(), (Object)singleViolation);
                continue;
            }
            if (!this.fixSingleViolation(docToFix, singleViolation.getLocation().getXpath())) continue;
            report.addFixedViolation(singleViolation);
        }
        return report;
    }
}

