/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.common.importer;

import com.github.blutorange.bpmnspector.api.Location;
import com.github.blutorange.bpmnspector.api.LocationCoordinate;
import com.github.blutorange.bpmnspector.api.ValidationException;
import com.github.blutorange.bpmnspector.common.util.ConstantHelper;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.located.LocatedElement;
import org.jdom2.util.IteratorIterable;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMNProcess {
    private final Document processAsDoc;
    private final String baseURI;
    private final String namespace;
    private final String generatedPrefix;
    private final BPMNProcess parent;
    private final List<BPMNProcess> children = new ArrayList<BPMNProcess>();
    private final List<Document> wsdls = new ArrayList<Document>();
    private final List<Document> xsds = new ArrayList<Document>();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BPMNProcess.class.getSimpleName());

    public BPMNProcess(Document processAsDoc, String baseURI, String namespace) {
        this(processAsDoc, baseURI, namespace, null);
    }

    public BPMNProcess(Document processAsDoc, String baseURI, String namespace, BPMNProcess parent) {
        this.processAsDoc = processAsDoc;
        this.baseURI = baseURI;
        this.namespace = namespace;
        this.parent = parent;
        this.generatedPrefix = this.createPrefixForProcess();
    }

    public List<BPMNProcess> getChildren() {
        return this.children;
    }

    public Document getProcessAsDoc() {
        return this.processAsDoc;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getGeneratedPrefix() {
        return this.generatedPrefix;
    }

    public BPMNProcess getParent() {
        return this.parent;
    }

    public List<Document> getWsdls() {
        return this.wsdls;
    }

    public List<Document> getXsds() {
        return this.xsds;
    }

    public void getAllProcessesRecursively(List<BPMNProcess> processList) {
        if (!processList.contains(this)) {
            processList.add(this);
            for (BPMNProcess child : this.getChildren()) {
                child.getAllProcessesRecursively(processList);
            }
        }
    }

    public List<BPMNProcess> findProcessByNamespace(String namespace) {
        ArrayList<BPMNProcess> allProcesses = new ArrayList<BPMNProcess>();
        this.getAllProcessesRecursively(allProcesses);
        return allProcesses.stream().filter(process -> process.getNamespace().equals(namespace)).collect(Collectors.toList());
    }

    public Optional<BPMNProcess> findProcessByGeneratedPrefix(String prefix) {
        ArrayList<BPMNProcess> allProcesses = new ArrayList<BPMNProcess>();
        this.getAllProcessesRecursively(allProcesses);
        return allProcesses.stream().filter(process -> process.getGeneratedPrefix().equals(prefix)).findFirst();
    }

    private String createPrefixForProcess() {
        return "ns" + (this.namespace + this.baseURI).hashCode();
    }

    public Optional<Element> findElementById(String id) {
        Objects.requireNonNull(id, "id must not be null.");
        IteratorIterable it = this.processAsDoc.getRootElement().getDescendants(Filters.element());
        while (it.hasNext()) {
            Element nextElem = (Element)it.next();
            Attribute nextId = nextElem.getAttribute("id");
            if (nextId == null || !id.equals(nextId.getValue())) continue;
            return Optional.of(nextElem);
        }
        return Optional.empty();
    }

    public Location determineLocationByXPath(String xpathExpression) throws ValidationException {
        LOGGER.debug("Found ID:{}", (Object)xpathExpression);
        int line = -1;
        int column = -1;
        String xpathObjectId = BPMNProcess.createIdBpmnExpression(xpathExpression);
        LOGGER.debug("Expression to evaluate: {}", (Object)xpathObjectId);
        XPathFactory fac = XPathFactory.instance();
        List elems = fac.compile(xpathObjectId, Filters.element(), null, new Namespace[]{ConstantHelper.BPMN_NAMESPACE}).evaluate((Object)this.processAsDoc);
        if (elems.size() == 1) {
            line = ((LocatedElement)elems.get(0)).getLine();
            column = ((LocatedElement)elems.get(0)).getColumn();
            xpathObjectId = BPMNProcess.createIdBpmnExpression(xpathExpression.substring(xpathExpression.indexOf(95) + 1));
        }
        if (line == -1 || column == -1) {
            throw new ValidationException("BPMN Element couldn't be found in file '" + this.baseURI + "'!");
        }
        return new Location(Paths.get(this.baseURI, new String[0]).toAbsolutePath(), new LocationCoordinate(line, column), xpathObjectId);
    }

    public boolean hasConditionalSeqFlowTasks() {
        IteratorIterable it = this.processAsDoc.getRootElement().getDescendants(Filters.element((String)"sequenceFlow", (Namespace)ConstantHelper.BPMN_NAMESPACE));
        while (it.hasNext()) {
            String elemName;
            String sourceId;
            Optional<Element> elem;
            Attribute sourceRefAttribute;
            Element seqFlow = (Element)it.next();
            if (seqFlow.getChild("conditionExpression", ConstantHelper.BPMN_NAMESPACE) == null || (sourceRefAttribute = seqFlow.getAttribute("sourceRef")) == null || !(elem = this.findElementById(sourceId = sourceRefAttribute.getValue())).isPresent() || "exclusiveGateway".equals(elemName = elem.get().getName()) || "parallelGateway".equals(elemName) || "inclusiveGateway".equals(elemName) || "complexGateway".equals(elemName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasBoundaryEvents() {
        IteratorIterable it = this.processAsDoc.getRootElement().getDescendants(Filters.element((String)"boundaryEvent", (Namespace)ConstantHelper.BPMN_NAMESPACE));
        return it.hasNext();
    }

    public boolean isMultiProcessModel() {
        List processElems = this.processAsDoc.getRootElement().getChildren("process", ConstantHelper.BPMN_NAMESPACE);
        if (processElems.size() > 1) {
            return true;
        }
        Element collaboration = this.processAsDoc.getRootElement().getChild("collaboration", ConstantHelper.BPMN_NAMESPACE);
        if (collaboration != null) {
            List participants = collaboration.getChildren("participant", ConstantHelper.BPMN_NAMESPACE);
            return participants.size() > 1;
        }
        return false;
    }

    private static String createIdBpmnExpression(String id) {
        return String.format("//bpmn:*[@id = '%s']", id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BPMNProcess that = (BPMNProcess)o;
        return Objects.equals(this.baseURI, that.baseURI) && Objects.equals(this.namespace, that.namespace) && this.processAsDoc.toString().equals(that.processAsDoc.toString());
    }

    public int hashCode() {
        return Objects.hash(this.baseURI, this.namespace);
    }
}

